/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.management.appservice;

import com.fasterxml.jackson.annotation.JsonValue;
import com.microsoft.azure.management.apigeneration.Fluent;
import com.microsoft.azure.management.appservice.SkuDescription;

@Fluent(ContainerName="/Microsoft.Azure.Management.AppService.Fluent")
public final class PricingTier {
    public static final PricingTier BASIC_B1 = new PricingTier("Basic", "B1");
    public static final PricingTier BASIC_B2 = new PricingTier("Basic", "B2");
    public static final PricingTier BASIC_B3 = new PricingTier("Basic", "B3");
    public static final PricingTier STANDARD_S1 = new PricingTier("Standard", "S1");
    public static final PricingTier STANDARD_S2 = new PricingTier("Standard", "S2");
    public static final PricingTier STANDARD_S3 = new PricingTier("Standard", "S3");
    public static final PricingTier PREMIUM_P1 = new PricingTier("Premium", "P1");
    public static final PricingTier PREMIUM_P2 = new PricingTier("Premium", "P2");
    public static final PricingTier PREMIUM_P3 = new PricingTier("Premium", "P3");
    public static final PricingTier FREE_F1 = new PricingTier("Free", "F1");
    public static final PricingTier SHARED_D1 = new PricingTier("Shared", "D1");
    private SkuDescription skuDescription;

    public PricingTier(String tier, String size) {
        this.skuDescription = new SkuDescription().withName(size).withTier(tier).withSize(size);
    }

    public static PricingTier fromSkuDescription(SkuDescription skuDescription) {
        if (skuDescription == null) {
            return null;
        }
        return new PricingTier(skuDescription.tier(), skuDescription.size());
    }

    public String toString() {
        return this.skuDescription.tier() + "_" + this.skuDescription.size();
    }

    @JsonValue
    public SkuDescription toSkuDescription() {
        return this.skuDescription;
    }

    public int hashCode() {
        return this.skuDescription.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PricingTier)) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        PricingTier rhs = (PricingTier)obj;
        return this.toString().equalsIgnoreCase(rhs.toString());
    }
}

