/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.Rate;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.AbstractRateLimitFilter;
import com.netflix.zuul.context.RequestContext;
import com.netflix.zuul.exception.ZuulException;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.cloud.netflix.zuul.util.ZuulRuntimeException;
import org.springframework.http.HttpStatus;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.util.UrlPathHelper;

public class RateLimitPreFilter
extends AbstractRateLimitFilter {
    private final RateLimiter rateLimiter;
    private final RateLimitKeyGenerator rateLimitKeyGenerator;

    public RateLimitPreFilter(RateLimitProperties properties, RouteLocator routeLocator, UrlPathHelper urlPathHelper, RateLimiter rateLimiter, RateLimitKeyGenerator rateLimitKeyGenerator) {
        super(properties, routeLocator, urlPathHelper);
        this.rateLimiter = rateLimiter;
        this.rateLimitKeyGenerator = rateLimitKeyGenerator;
    }

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return -1;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletResponse response = ctx.getResponse();
        HttpServletRequest request = ctx.getRequest();
        Route route = this.route();
        this.policy(route).ifPresent(policy -> {
            String key = this.rateLimitKeyGenerator.key(request, route, (RateLimitProperties.Policy)policy);
            Rate rate = this.rateLimiter.consume((RateLimitProperties.Policy)policy, key, null);
            Long limit = policy.getLimit();
            Long remaining = rate.getRemaining();
            if (limit != null) {
                response.setHeader("X-RateLimit-Limit", String.valueOf(limit));
                response.setHeader("X-RateLimit-Remaining", String.valueOf(Math.max(remaining, 0L)));
            }
            Long quota = policy.getQuota();
            Long remainingQuota = rate.getRemainingQuota();
            if (quota != null) {
                RequestContextHolder.getRequestAttributes().setAttribute("rateLimitRequestStartTime", (Object)System.currentTimeMillis(), 0);
                response.setHeader("X-RateLimit-Quota", String.valueOf(quota));
                response.setHeader("X-RateLimit-Remaining-Quota", String.valueOf(TimeUnit.MILLISECONDS.toSeconds(Math.max(remainingQuota, 0L))));
            }
            response.setHeader("X-RateLimit-Reset", String.valueOf(rate.getReset()));
            if (limit != null && remaining < 0L || quota != null && remainingQuota < 0L) {
                HttpStatus tooManyRequests = HttpStatus.TOO_MANY_REQUESTS;
                ctx.setResponseStatusCode(tooManyRequests.value());
                ctx.put((Object)"rateLimitExceeded", (Object)"true");
                ctx.setSendZuulResponse(false);
                ZuulException zuulException = new ZuulException(tooManyRequests.toString(), tooManyRequests.value(), null);
                throw new ZuulRuntimeException(zuulException);
            }
        });
        return null;
    }
}

