/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters;

import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.AbstractRateLimitFilter;
import com.netflix.zuul.context.RequestContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.util.UrlPathHelper;

public class RateLimitPostFilter
extends AbstractRateLimitFilter {
    private final RateLimiter rateLimiter;
    private final RateLimitKeyGenerator rateLimitKeyGenerator;

    public RateLimitPostFilter(RateLimitProperties properties, RouteLocator routeLocator, UrlPathHelper urlPathHelper, RateLimiter rateLimiter, RateLimitKeyGenerator rateLimitKeyGenerator) {
        super(properties, routeLocator, urlPathHelper);
        this.rateLimiter = rateLimiter;
        this.rateLimitKeyGenerator = rateLimitKeyGenerator;
    }

    public String filterType() {
        return "post";
    }

    public int filterOrder() {
        return 990;
    }

    @Override
    public boolean shouldFilter() {
        return super.shouldFilter() && this.getRequestStartTime() != null;
    }

    private Long getRequestStartTime() {
        RequestAttributes requestAttributes = RequestContextHolder.getRequestAttributes();
        return (Long)requestAttributes.getAttribute("rateLimitRequestStartTime", 0);
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        HttpServletRequest request = ctx.getRequest();
        Route route = this.route();
        this.policy(route).ifPresent(policy -> {
            Long requestTime = System.currentTimeMillis() - this.getRequestStartTime();
            String key = this.rateLimitKeyGenerator.key(request, route, (RateLimitProperties.Policy)policy);
            this.rateLimiter.consume((RateLimitProperties.Policy)policy, key, requestTime);
        });
        return null;
    }
}

