/*
 * Decompiled with CFR 0.152.
 */
package com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit;

import com.ecwid.consul.v1.ConsulClient;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.DefaultRateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimitKeyGenerator;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.RateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.properties.RateLimitProperties;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.ConsulRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.InMemoryRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.RedisRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.springdata.JpaRateLimiter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.config.repository.springdata.RateLimiterRepository;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.RateLimitPostFilter;
import com.marcosbarbero.cloud.autoconfigure.zuul.ratelimit.filters.RateLimitPreFilter;
import com.netflix.zuul.ZuulFilter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.consul.ConditionalOnConsulEnabled;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.web.util.UrlPathHelper;

@Configuration
@EnableConfigurationProperties(value={RateLimitProperties.class})
@ConditionalOnProperty(prefix="zuul.ratelimit", name={"enabled"}, havingValue="true")
public class RateLimitAutoConfiguration {
    private final UrlPathHelper urlPathHelper = new UrlPathHelper();

    @Bean
    public ZuulFilter rateLimiterPreFilter(RateLimiter rateLimiter, RateLimitProperties rateLimitProperties, RouteLocator routeLocator, RateLimitKeyGenerator rateLimitKeyGenerator) {
        return new RateLimitPreFilter(rateLimitProperties, routeLocator, this.urlPathHelper, rateLimiter, rateLimitKeyGenerator);
    }

    @Bean
    public ZuulFilter rateLimiterPostFilter(RateLimiter rateLimiter, RateLimitProperties rateLimitProperties, RouteLocator routeLocator, RateLimitKeyGenerator rateLimitKeyGenerator) {
        return new RateLimitPostFilter(rateLimitProperties, routeLocator, this.urlPathHelper, rateLimiter, rateLimitKeyGenerator);
    }

    @Bean
    @ConditionalOnMissingBean(value={RateLimitKeyGenerator.class})
    public RateLimitKeyGenerator ratelimitKeyGenerator(RateLimitProperties properties) {
        return new DefaultRateLimitKeyGenerator(properties);
    }

    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="IN_MEMORY", matchIfMissing=true)
    public static class InMemoryConfiguration {
        @Bean
        public RateLimiter inMemoryRateLimiter() {
            return new InMemoryRateLimiter();
        }
    }

    @EntityScan
    @EnableJpaRepositories
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="JPA")
    public static class SpringDataConfiguration {
        @Bean
        public RateLimiter springDataRateLimiter(RateLimiterRepository rateLimiterRepository) {
            return new JpaRateLimiter(rateLimiterRepository);
        }
    }

    @ConditionalOnConsulEnabled
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="CONSUL")
    public static class ConsulConfiguration {
        @Bean
        public RateLimiter consultRateLimiter(ConsulClient consulClient, ObjectMapper objectMapper) {
            return new ConsulRateLimiter(consulClient, objectMapper);
        }
    }

    @ConditionalOnClass(value={RedisTemplate.class})
    @ConditionalOnMissingBean(value={RateLimiter.class})
    @ConditionalOnProperty(prefix="zuul.ratelimit", name={"repository"}, havingValue="REDIS")
    public static class RedisConfiguration {
        @Bean(value={"rateLimiterRedisTemplate"})
        public StringRedisTemplate redisTemplate(RedisConnectionFactory connectionFactory) {
            return new StringRedisTemplate(connectionFactory);
        }

        @Bean
        public RateLimiter redisRateLimiter(@Qualifier(value="rateLimiterRedisTemplate") RedisTemplate redisTemplate) {
            return new RedisRateLimiter(redisTemplate);
        }
    }
}

