/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.proto;

import com.luhuiguo.fastdfs.conn.Connection;
import com.luhuiguo.fastdfs.exception.FdfsIOException;
import com.luhuiguo.fastdfs.proto.FdfsCommand;
import com.luhuiguo.fastdfs.proto.FdfsRequest;
import com.luhuiguo.fastdfs.proto.FdfsResponse;
import com.luhuiguo.fastdfs.proto.ProtoHead;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractFdfsCommand<T>
implements FdfsCommand<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractFdfsCommand.class);
    protected FdfsRequest request;
    protected FdfsResponse<T> response;

    @Override
    public T execute(Connection conn) {
        try {
            this.send(conn.getOutputStream(), conn.getCharset());
        }
        catch (IOException e) {
            LOGGER.error("send conent error", (Throwable)e);
            throw new FdfsIOException("socket io exception occured while sending cmd", e);
        }
        try {
            return this.receive(conn.getInputStream(), conn.getCharset());
        }
        catch (IOException e) {
            LOGGER.error("receive conent error", (Throwable)e);
            throw new FdfsIOException("socket io exception occured while receive content", e);
        }
    }

    protected void send(OutputStream out, Charset charset) throws IOException {
        byte[] head = this.request.getHeadByte(charset);
        byte[] param = this.request.encodeParam(charset);
        InputStream inputFile = this.request.getInputFile();
        long fileSize = this.request.getFileSize();
        LOGGER.debug("\u53d1\u51fa\u4ea4\u6613\u8bf7\u6c42..\u62a5\u6587\u5934\u4e3a{}", (Object)this.request.getHead());
        LOGGER.debug("\u4ea4\u6613\u53c2\u6570\u4e3a{}", (Object)param);
        out.write(head);
        if (null != param) {
            out.write(param);
        }
        if (null != inputFile) {
            this.sendFileContent(inputFile, fileSize, out);
        }
    }

    protected T receive(InputStream in, Charset charset) throws IOException {
        ProtoHead head = ProtoHead.createFromInputStream(in);
        LOGGER.debug("\u670d\u52a1\u7aef\u8fd4\u56de\u62a5\u6587\u5934{}", (Object)head);
        head.validateResponseHead();
        return this.response.decode(head, in, charset);
    }

    protected void sendFileContent(InputStream ins, long size, OutputStream ous) throws IOException {
        LOGGER.debug("\u5f00\u59cb\u4e0a\u4f20\u6587\u4ef6\u6d41\u5927\u5c0f\u4e3a{}", (Object)size);
        long remainBytes = size;
        byte[] buff = new byte[262144];
        while (remainBytes > 0L) {
            int bytes = ins.read(buff, 0, remainBytes > (long)buff.length ? buff.length : (int)remainBytes);
            if (bytes < 0) {
                throw new IOException("the end of the stream has been reached. not match the expected size ");
            }
            ous.write(buff, 0, bytes);
            LOGGER.debug("\u5269\u4f59\u6570\u636e\u91cf{}", (Object)(remainBytes -= (long)bytes));
        }
    }
}

