/*
 * Decompiled with CFR 0.152.
 */
package com.luhuiguo.fastdfs.conn;

import com.luhuiguo.fastdfs.conn.Connection;
import com.luhuiguo.fastdfs.conn.ConnectionManager;
import com.luhuiguo.fastdfs.conn.FdfsConnectionPool;
import com.luhuiguo.fastdfs.domain.TrackerLocator;
import com.luhuiguo.fastdfs.exception.FdfsConnectException;
import com.luhuiguo.fastdfs.proto.FdfsCommand;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.List;

public class TrackerConnectionManager
extends ConnectionManager {
    private TrackerLocator trackerLocator;
    private List<String> trackerList = new ArrayList<String>();

    public TrackerConnectionManager(FdfsConnectionPool pool, List<String> trackerList) {
        super(pool);
        this.trackerList = trackerList;
        this.trackerLocator = new TrackerLocator(trackerList);
    }

    public <T> T executeFdfsTrackerCmd(FdfsCommand<T> command) {
        Connection conn = null;
        InetSocketAddress address = null;
        try {
            address = this.trackerLocator.getTrackerAddress();
            LOGGER.debug("\u83b7\u53d6\u5230Tracker\u8fde\u63a5\u5730\u5740{}", (Object)address);
            conn = this.getConnection(address);
            this.trackerLocator.setActive(address);
        }
        catch (FdfsConnectException e) {
            this.trackerLocator.setInActive(address);
            throw e;
        }
        catch (Exception e) {
            LOGGER.error("Unable to borrow buffer from pool", (Throwable)e);
            throw new RuntimeException("Unable to borrow buffer from pool", e);
        }
        return this.execute(address, conn, command);
    }

    public List<String> getTrackerList() {
        return this.trackerList;
    }

    public void setTrackerList(List<String> trackerList) {
        this.trackerList = trackerList;
    }
}

