/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider.asymmetric.gm;

import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.util.Hashtable;
import java.util.Map;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.generators.ECKeyPairGenerator;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.crypto.params.ECKeyGenerationParameters;
import org.bouncycastle.crypto.params.ECPrivateKeyParameters;
import org.bouncycastle.crypto.params.ECPublicKeyParameters;
import org.bouncycastle.jcajce.provider.asymmetric.gm.BCSM2PrivateKey;
import org.bouncycastle.jcajce.provider.asymmetric.gm.BCSM2PublicKey;
import org.bouncycastle.jcajce.provider.asymmetric.util.EC5Util;
import org.bouncycastle.jcajce.provider.asymmetric.util.ECUtil;
import org.bouncycastle.jcajce.provider.config.ProviderConfiguration;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveGenParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Integers;

public abstract class KeyPairGeneratorSpi
extends KeyPairGenerator {
    public KeyPairGeneratorSpi(String string) {
        super(string);
    }

    public static class SM2
    extends GM {
        public SM2() {
            super("SM2", BouncyCastleProvider.CONFIGURATION);
        }
    }

    public static class GM
    extends KeyPairGeneratorSpi {
        ECKeyGenerationParameters param;
        ECKeyPairGenerator engine = new ECKeyPairGenerator();
        Object ecParams = null;
        int strength = 239;
        SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
        boolean initialised = false;
        String algorithm;
        ProviderConfiguration configuration;
        private static Hashtable ecParameters = new Hashtable();

        public GM() {
            super("GM");
            this.algorithm = "GM";
            this.configuration = BouncyCastleProvider.CONFIGURATION;
        }

        public GM(String string, ProviderConfiguration providerConfiguration) {
            super(string);
            this.algorithm = string;
            this.configuration = providerConfiguration;
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
            ECGenParameterSpec eCGenParameterSpec = (ECGenParameterSpec)ecParameters.get(Integers.valueOf(n));
            if (eCGenParameterSpec == null) {
                throw new InvalidParameterException("unknown key size.");
            }
            try {
                this.initialize(eCGenParameterSpec, secureRandom);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new InvalidParameterException("key size not configurable.");
            }
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (algorithmParameterSpec == null) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = this.configuration.getEcImplicitlyCa();
                if (eCParameterSpec == null) {
                    throw new InvalidAlgorithmParameterException("null parameter passed but no implicitCA set");
                }
                this.ecParams = null;
                this.param = this.createKeyGenParamsBC(eCParameterSpec, secureRandom);
            } else if (algorithmParameterSpec instanceof org.bouncycastle.jce.spec.ECParameterSpec) {
                this.ecParams = algorithmParameterSpec;
                this.param = this.createKeyGenParamsBC((org.bouncycastle.jce.spec.ECParameterSpec)algorithmParameterSpec, secureRandom);
            } else if (algorithmParameterSpec instanceof ECParameterSpec) {
                this.ecParams = algorithmParameterSpec;
                this.param = this.createKeyGenParamsJCE((ECParameterSpec)algorithmParameterSpec, secureRandom);
            } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
                this.initializeNamedCurve(((ECGenParameterSpec)algorithmParameterSpec).getName(), secureRandom);
            } else if (algorithmParameterSpec instanceof ECNamedCurveGenParameterSpec) {
                this.initializeNamedCurve(((ECNamedCurveGenParameterSpec)algorithmParameterSpec).getName(), secureRandom);
            } else {
                String string = ECUtil.getNameFrom(algorithmParameterSpec);
                if (string != null) {
                    this.initializeNamedCurve(string, secureRandom);
                } else {
                    throw new InvalidAlgorithmParameterException("invalid parameterSpec: " + algorithmParameterSpec);
                }
            }
            this.engine.init(this.param);
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            if (!this.initialised) {
                this.initialize(this.strength, new SecureRandom());
            }
            AsymmetricCipherKeyPair asymmetricCipherKeyPair = this.engine.generateKeyPair();
            ECPublicKeyParameters eCPublicKeyParameters = (ECPublicKeyParameters)asymmetricCipherKeyPair.getPublic();
            ECPrivateKeyParameters eCPrivateKeyParameters = (ECPrivateKeyParameters)asymmetricCipherKeyPair.getPrivate();
            if (this.ecParams instanceof org.bouncycastle.jce.spec.ECParameterSpec) {
                org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec = (org.bouncycastle.jce.spec.ECParameterSpec)this.ecParams;
                BCSM2PublicKey bCSM2PublicKey = new BCSM2PublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec, this.configuration);
                return new KeyPair(bCSM2PublicKey, new BCSM2PrivateKey(this.algorithm, eCPrivateKeyParameters, bCSM2PublicKey, eCParameterSpec, this.configuration));
            }
            if (this.ecParams == null) {
                return new KeyPair(new BCSM2PublicKey(this.algorithm, eCPublicKeyParameters, this.configuration), new BCSM2PrivateKey(this.algorithm, eCPrivateKeyParameters, this.configuration));
            }
            ECParameterSpec eCParameterSpec = (ECParameterSpec)this.ecParams;
            BCSM2PublicKey bCSM2PublicKey = new BCSM2PublicKey(this.algorithm, eCPublicKeyParameters, eCParameterSpec, this.configuration);
            return new KeyPair(bCSM2PublicKey, new BCSM2PrivateKey(this.algorithm, eCPrivateKeyParameters, bCSM2PublicKey, eCParameterSpec, this.configuration));
        }

        protected ECKeyGenerationParameters createKeyGenParamsBC(org.bouncycastle.jce.spec.ECParameterSpec eCParameterSpec, SecureRandom secureRandom) {
            return new ECKeyGenerationParameters(new ECDomainParameters(eCParameterSpec.getCurve(), eCParameterSpec.getG(), eCParameterSpec.getN(), eCParameterSpec.getH()), secureRandom);
        }

        protected ECKeyGenerationParameters createKeyGenParamsJCE(ECParameterSpec eCParameterSpec, SecureRandom secureRandom) {
            Object object;
            if (eCParameterSpec instanceof ECNamedCurveSpec && (object = GM.getDomainParametersFromName(((ECNamedCurveSpec)eCParameterSpec).getName())) != null) {
                ECDomainParameters eCDomainParameters = new ECDomainParameters(((X9ECParameters)object).getCurve(), ((X9ECParameters)object).getG(), ((X9ECParameters)object).getN(), ((X9ECParameters)object).getH());
                return new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
            }
            object = EC5Util.convertCurve(eCParameterSpec.getCurve());
            ECPoint eCPoint = EC5Util.convertPoint((ECCurve)object, eCParameterSpec.getGenerator());
            BigInteger bigInteger = eCParameterSpec.getOrder();
            BigInteger bigInteger2 = BigInteger.valueOf(eCParameterSpec.getCofactor());
            ECDomainParameters eCDomainParameters = new ECDomainParameters((ECCurve)object, eCPoint, bigInteger, bigInteger2);
            return new ECKeyGenerationParameters(eCDomainParameters, secureRandom);
        }

        static X9ECParameters getDomainParametersFromName(String string) {
            X9ECParameters x9ECParameters;
            try {
                if (string.charAt(0) >= '0' && string.charAt(0) <= '2') {
                    ASN1ObjectIdentifier aSN1ObjectIdentifier = new ASN1ObjectIdentifier(string);
                    x9ECParameters = ECUtil.getNamedCurveByOid(aSN1ObjectIdentifier);
                } else if (string.indexOf(32) > 0) {
                    string = string.substring(string.indexOf(32) + 1);
                    x9ECParameters = ECUtil.getNamedCurveByName(string);
                } else {
                    x9ECParameters = ECUtil.getNamedCurveByName(string);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                x9ECParameters = ECUtil.getNamedCurveByName(string);
            }
            return x9ECParameters;
        }

        static X962Parameters getDomainParametersFromName(ECParameterSpec eCParameterSpec, boolean bl) {
            X962Parameters x962Parameters;
            if (eCParameterSpec instanceof ECNamedCurveSpec) {
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)eCParameterSpec).getName());
                if (aSN1ObjectIdentifier == null) {
                    aSN1ObjectIdentifier = new ASN1ObjectIdentifier(((ECNamedCurveSpec)eCParameterSpec).getName());
                }
                x962Parameters = new X962Parameters(aSN1ObjectIdentifier);
            } else if (eCParameterSpec == null) {
                x962Parameters = new X962Parameters(DERNull.INSTANCE);
            } else {
                ECCurve eCCurve = EC5Util.convertCurve(eCParameterSpec.getCurve());
                X9ECParameters x9ECParameters = new X9ECParameters(eCCurve, new X9ECPoint(EC5Util.convertPoint(eCCurve, eCParameterSpec.getGenerator()), bl), eCParameterSpec.getOrder(), BigInteger.valueOf(eCParameterSpec.getCofactor()), eCParameterSpec.getCurve().getSeed());
                x962Parameters = new X962Parameters(x9ECParameters);
            }
            return x962Parameters;
        }

        protected ECNamedCurveSpec createNamedCurveSpec(String string) throws InvalidAlgorithmParameterException {
            Map map;
            X9ECParameters x9ECParameters = GM.getDomainParametersFromName(string);
            if (x9ECParameters == null) {
                try {
                    x9ECParameters = ECNamedCurveTable.getByOID(new ASN1ObjectIdentifier(string));
                    if (x9ECParameters == null && (x9ECParameters = (X9ECParameters)(map = this.configuration.getAdditionalECParameters()).get(new ASN1ObjectIdentifier(string))) == null) {
                        throw new InvalidAlgorithmParameterException("unknown curve OID: " + string);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw new InvalidAlgorithmParameterException("unknown curve name: " + string);
                }
            }
            map = null;
            return new ECNamedCurveSpec(string, x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), (byte[])map);
        }

        protected void initializeNamedCurve(String string, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            ECNamedCurveSpec eCNamedCurveSpec = this.createNamedCurveSpec(string);
            this.ecParams = eCNamedCurveSpec;
            this.param = this.createKeyGenParamsJCE(eCNamedCurveSpec, secureRandom);
        }

        static {
            ecParameters.put(Integers.valueOf(256), new ECGenParameterSpec("sm2p256v1"));
        }
    }
}

