/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.util;

import com.liferay.portal.kernel.util.CalendarUtil;
import com.liferay.portal.kernel.util.DateFormatFactoryUtil;
import com.liferay.portal.kernel.util.FastDateFormatFactoryUtil;
import com.liferay.portal.kernel.util.TimeZoneUtil;
import com.liferay.portal.kernel.util.Validator;
import java.text.DateFormat;
import java.text.Format;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DateUtil {
    public static final String ISO_8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ssZ";
    private static final Map<Locale, Boolean> _formatAmPmMap = new HashMap<Locale, Boolean>();

    public static int compareTo(Date date1, Date date2) {
        if (date1 == date2) {
            return 0;
        }
        if (date1 == null) {
            return 1;
        }
        if (date2 == null) {
            return -1;
        }
        return Long.compare(date1.getTime(), date2.getTime());
    }

    public static boolean equals(Date date1, Date date2) {
        return DateUtil.compareTo(date1, date2) == 0;
    }

    public static String formatDate(String fromPattern, String dateString, Locale locale) throws ParseException {
        Date dateValue = DateUtil.parseDate(fromPattern, dateString, locale);
        Format dateFormat = FastDateFormatFactoryUtil.getDate(locale);
        return dateFormat.format(dateValue);
    }

    public static String getCurrentDate(String pattern, Locale locale) {
        return DateUtil.getDate(new Date(), pattern, locale);
    }

    public static String getCurrentDate(String pattern, Locale locale, TimeZone timeZone) {
        return DateUtil.getDate(new Date(), pattern, locale, timeZone);
    }

    public static String getDate(Date date, String pattern, Locale locale) {
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat(pattern, locale);
        return dateFormat.format(date);
    }

    public static String getDate(Date date, String pattern, Locale locale, TimeZone timeZone) {
        Format dateFormat = FastDateFormatFactoryUtil.getSimpleDateFormat(pattern, locale, timeZone);
        return dateFormat.format(date);
    }

    public static int getDaysBetween(Date date1, Date date2) {
        return DateUtil.getDaysBetween(date1, date2, null);
    }

    public static int getDaysBetween(Date date1, Date date2, TimeZone timeZone) {
        if (date1.after(date2)) {
            Date tempDate = date1;
            date1 = date2;
            date2 = tempDate;
        }
        GregorianCalendar startCal = null;
        GregorianCalendar endCal = null;
        int offsetDate1 = 0;
        int offsetDate2 = 0;
        if (timeZone == null) {
            startCal = new GregorianCalendar();
            endCal = new GregorianCalendar();
        } else {
            startCal = new GregorianCalendar(timeZone);
            endCal = new GregorianCalendar(timeZone);
            offsetDate1 = timeZone.getOffset(date1.getTime());
            offsetDate2 = timeZone.getOffset(date2.getTime());
        }
        startCal.setTime(date1);
        ((Calendar)startCal).add(14, offsetDate1);
        endCal.setTime(date2);
        ((Calendar)endCal).add(14, offsetDate2);
        int daysBetween = 0;
        while (CalendarUtil.beforeByDay(startCal.getTime(), endCal.getTime())) {
            ((Calendar)startCal).add(5, 1);
            ++daysBetween;
        }
        return daysBetween;
    }

    public static DateFormat getISO8601Format() {
        return DateFormatFactoryUtil.getSimpleDateFormat(ISO_8601_PATTERN);
    }

    public static DateFormat getISOFormat() {
        return DateUtil.getISOFormat("");
    }

    public static DateFormat getISOFormat(String text) {
        String pattern = "";
        pattern = text.length() == 8 ? "yyyyMMdd" : (text.length() == 12 ? "yyyyMMddHHmm" : (text.length() == 13 ? "yyyyMMdd'T'HHmm" : (text.length() == 14 ? "yyyyMMddHHmmss" : (text.length() == 15 ? "yyyyMMdd'T'HHmmss" : (text.length() > 8 && text.charAt(8) == 'T' ? "yyyyMMdd'T'HHmmssz" : "yyyyMMddHHmmssz")))));
        return DateFormatFactoryUtil.getSimpleDateFormat(pattern);
    }

    public static DateFormat getUTCFormat() {
        return DateUtil.getUTCFormat("");
    }

    public static DateFormat getUTCFormat(String text) {
        String pattern = "";
        pattern = text.length() == 8 ? "yyyyMMdd" : (text.length() == 12 ? "yyyyMMddHHmm" : (text.length() == 13 ? "yyyyMMdd'T'HHmm" : (text.length() == 14 ? "yyyyMMddHHmmss" : (text.length() == 15 ? "yyyyMMdd'T'HHmmss" : "yyyyMMdd'T'HHmmssz"))));
        return DateFormatFactoryUtil.getSimpleDateFormat(pattern, TimeZoneUtil.getTimeZone("UTC"));
    }

    public static boolean isFormatAmPm(Locale locale) {
        Boolean formatAmPm = _formatAmPmMap.get(locale);
        if (formatAmPm == null) {
            SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getTimeInstance(3, locale);
            String pattern = simpleDateFormat.toPattern();
            formatAmPm = pattern.contains("a");
            _formatAmPmMap.put(locale, formatAmPm);
        }
        return formatAmPm;
    }

    public static Date newDate() {
        return new Date();
    }

    public static Date newDate(long date) {
        return new Date(date);
    }

    public static long newTime() {
        Date date = new Date();
        return date.getTime();
    }

    public static Date parseDate(String dateString, Locale locale) throws ParseException {
        return DateUtil.parseDate(null, dateString, locale);
    }

    public static Date parseDate(String pattern, String dateString, Locale locale) throws ParseException {
        DateFormat dateFormat = null;
        dateFormat = Validator.isNull(pattern) ? DateFormat.getDateInstance(3, locale) : DateFormatFactoryUtil.getSimpleDateFormat(pattern, locale);
        return dateFormat.parse(dateString);
    }
}

