/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.settings;

import com.liferay.portal.kernel.settings.BaseSettings;
import com.liferay.portal.kernel.settings.Settings;
import com.liferay.portal.kernel.util.Validator;
import java.util.Map;

public class ParameterMapSettings
extends BaseSettings {
    public static final String PREFERENCES_PREFIX = "preferences--";
    public static final String SETTINGS_PREFIX = "settings--";
    private final Map<String, String[]> _parameterMap;
    private String _parameterNamePrefix;

    public ParameterMapSettings(Map<String, String[]> parameterMap, Settings parentSettings) {
        super(parentSettings);
        this._parameterMap = parameterMap;
    }

    public String getParameterNamePrefix() {
        return this._parameterNamePrefix;
    }

    public void setParameterNamePrefix(String parameterNamePrefix) {
        this._parameterNamePrefix = parameterNamePrefix;
    }

    @Override
    protected String doGetValue(String key) {
        String[] values = this.doGetValues(key);
        if (values == null) {
            return null;
        }
        return values[0];
    }

    @Override
    protected String[] doGetValues(String key) {
        String[] values = null;
        if (Validator.isNotNull(this._parameterNamePrefix)) {
            values = this._parameterMap.get(this._parameterNamePrefix + key);
        }
        if (values == null) {
            values = this._parameterMap.get(key);
        }
        if (values == null) {
            values = this._parameterMap.get(PREFERENCES_PREFIX + key + "--");
        }
        if (values == null) {
            values = this._parameterMap.get(SETTINGS_PREFIX + key + "--");
        }
        return values;
    }
}

