/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.repository.model;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;

public class FileContentReference {
    private final String _extension;
    private final File _file;
    private final InputStream _inputStream;
    private final String _mimeType;
    private final long _size;
    private final String _sourceFileName;

    public static final FileContentReference fromBytes(String sourceFileName, String extension, String mimeType, byte[] bytes) {
        return FileContentReference.fromInputStream(sourceFileName, extension, mimeType, new ByteArrayInputStream(bytes), bytes.length);
    }

    public static final FileContentReference fromFile(String sourceFileName, String extension, String mimeType, File file) {
        return new FileContentReference(sourceFileName, extension, mimeType, file, null, 0L);
    }

    public static final FileContentReference fromInputStream(String sourceFileName, String extension, String mimeType, InputStream inputStream, long size) {
        return new FileContentReference(sourceFileName, extension, mimeType, null, inputStream, size);
    }

    public String getExtension() {
        return this._extension;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public long getSize() {
        if (this._inputStream != null) {
            return this._size;
        }
        if (this._file != null) {
            return this._file.length();
        }
        return 0L;
    }

    public String getSourceFileName() {
        return this._sourceFileName;
    }

    protected FileContentReference(String sourceFileName, String extension, String mimeType, File file, InputStream inputStream, long size) {
        this._sourceFileName = sourceFileName;
        this._extension = extension;
        this._mimeType = mimeType;
        this._file = file;
        this._inputStream = inputStream;
        this._size = size;
    }
}

