/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.portlet;

import com.liferay.portal.kernel.model.LayoutTypePortlet;
import com.liferay.portal.kernel.model.Portlet;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.Validator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.portlet.MimeResponse;
import javax.portlet.PortletException;
import javax.portlet.PortletMode;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;

public class PortletURLUtil {
    private static final int _CURRENT_URL_PARAMETER_THRESHOLD = 32768;
    private static final String[] _PORTLET_URL_REFRESH_URL_RESERVED_PARAMETERS = PropsUtil.getArray("portlet.url.refresh.url.reserved.parameters");

    public static PortletURL clone(LiferayPortletURL liferayPortletURL, String lifecycle, LiferayPortletResponse liferayPortletResponse) throws PortletException {
        PortletMode portletMode;
        LiferayPortletURL newLiferayPortletURL = liferayPortletResponse.createLiferayPortletURL(lifecycle);
        newLiferayPortletURL.setPortletId(liferayPortletURL.getPortletId());
        WindowState windowState = liferayPortletURL.getWindowState();
        if (windowState != null) {
            newLiferayPortletURL.setWindowState(windowState);
        }
        if ((portletMode = liferayPortletURL.getPortletMode()) != null) {
            newLiferayPortletURL.setPortletMode(portletMode);
        }
        newLiferayPortletURL.setParameters(liferayPortletURL.getParameterMap());
        return newLiferayPortletURL;
    }

    public static PortletURL clone(PortletURL portletURL, LiferayPortletResponse liferayPortletResponse) throws PortletException {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        return PortletURLUtil.clone(liferayPortletURL, liferayPortletURL.getLifecycle(), liferayPortletResponse);
    }

    public static PortletURL clone(PortletURL portletURL, MimeResponse mimeResponse) throws PortletException {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        return PortletURLUtil.clone(liferayPortletURL, liferayPortletURL.getLifecycle(), (LiferayPortletResponse)mimeResponse);
    }

    public static PortletURL clone(PortletURL portletURL, String lifecycle, LiferayPortletResponse liferayPortletResponse) throws PortletException {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        return PortletURLUtil.clone(liferayPortletURL, lifecycle, liferayPortletResponse);
    }

    public static PortletURL clone(PortletURL portletURL, String lifecycle, MimeResponse mimeResponse) throws PortletException {
        LiferayPortletURL liferayPortletURL = (LiferayPortletURL)portletURL;
        return PortletURLUtil.clone(liferayPortletURL, lifecycle, (LiferayPortletResponse)mimeResponse);
    }

    public static PortletURL getCurrent(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        PortletURL portletURL = (PortletURL)liferayPortletRequest.getAttribute("CURRENT_PORTLET_URL");
        if (portletURL != null) {
            return portletURL;
        }
        portletURL = liferayPortletResponse.createRenderURL();
        Enumeration enu = liferayPortletRequest.getParameterNames();
        while (enu.hasMoreElements()) {
            String param = (String)enu.nextElement();
            String[] values = liferayPortletRequest.getParameterValues(param);
            boolean addParam = true;
            for (int i = 0; i < values.length; ++i) {
                if (values[i].length() <= 32768) continue;
                addParam = false;
                break;
            }
            if (!addParam) continue;
            portletURL.setParameter(param, values);
        }
        liferayPortletRequest.setAttribute("CURRENT_PORTLET_URL", portletURL);
        return portletURL;
    }

    public static PortletURL getCurrent(PortletRequest portletRequest, MimeResponse mimeResponse) {
        return PortletURLUtil.getCurrent((LiferayPortletRequest)portletRequest, (LiferayPortletResponse)mimeResponse);
    }

    public static String getRefreshURL(HttpServletRequest request, ThemeDisplay themeDisplay) {
        return PortletURLUtil.getRefreshURL(request, themeDisplay, true);
    }

    public static String getRefreshURL(HttpServletRequest request, ThemeDisplay themeDisplay, boolean includeParameters) {
        String doAsUserId;
        StringBundler sb = new StringBundler(34);
        sb.append(themeDisplay.getPathMain());
        sb.append("/portal/render_portlet?p_l_id=");
        long plid = themeDisplay.getPlid();
        sb.append(plid);
        Portlet portlet = (Portlet)request.getAttribute("RENDER_PORTLET");
        String portletId = portlet.getPortletId();
        sb.append("&p_p_id=");
        sb.append(portletId);
        sb.append("&p_p_lifecycle=0&p_t_lifecycle=");
        sb.append(themeDisplay.getLifecycle());
        WindowState windowState = WindowState.NORMAL;
        if (themeDisplay.isStatePopUp()) {
            windowState = LiferayWindowState.POP_UP;
        } else {
            LayoutTypePortlet layoutTypePortlet = themeDisplay.getLayoutTypePortlet();
            if (layoutTypePortlet.hasStateMaxPortletId(portletId)) {
                windowState = WindowState.MAXIMIZED;
            } else if (layoutTypePortlet.hasStateMinPortletId(portletId)) {
                windowState = WindowState.MINIMIZED;
            }
        }
        sb.append("&p_p_state=");
        sb.append(windowState);
        sb.append("&p_p_mode=view&p_p_col_id=");
        String columnId = (String)request.getAttribute("RENDER_PORTLET_COLUMN_ID");
        sb.append(columnId);
        Integer columnPos = (Integer)request.getAttribute("RENDER_PORTLET_COLUMN_POS");
        sb.append("&p_p_col_pos=");
        sb.append(columnPos);
        Integer columnCount = (Integer)request.getAttribute("RENDER_PORTLET_COLUMN_COUNT");
        sb.append("&p_p_col_count=");
        sb.append(columnCount);
        if (portlet.isStatic()) {
            sb.append("&p_p_static=1");
            if (portlet.isStaticStart()) {
                sb.append("&p_p_static_start=1");
            }
        }
        sb.append("&p_p_isolated=1");
        long sourceGroupId = ParamUtil.getLong(request, "p_v_l_s_g_id");
        if (sourceGroupId > 0L) {
            sb.append("&p_v_l_s_g_id=");
            sb.append(sourceGroupId);
        }
        if (Validator.isNotNull(doAsUserId = themeDisplay.getDoAsUserId())) {
            sb.append("&doAsUserId=");
            sb.append(HttpUtil.encodeURL(doAsUserId));
        }
        String currentURL = PortalUtil.getCurrentURL(request);
        sb.append("&currentURL=");
        sb.append(HttpUtil.encodeURL(currentURL));
        String ppid = ParamUtil.getString(request, "p_p_id");
        if (!ppid.equals(portletId)) {
            return sb.toString();
        }
        String settingsScope = (String)request.getAttribute("SETTINGS_SCOPE");
        if (Validator.isNotNull(settingsScope = ParamUtil.get(request, "settingsScope", settingsScope))) {
            sb.append("&settingsScope=");
            sb.append(settingsScope);
        }
        if (includeParameters) {
            Map<String, String[]> parameters = PortletURLUtil.getRefreshURLParameters(request);
            for (Map.Entry<String, String[]> entry : parameters.entrySet()) {
                String name = entry.getKey();
                String[] values = entry.getValue();
                for (int i = 0; i < values.length; ++i) {
                    sb.append("&");
                    sb.append(name);
                    sb.append("=");
                    sb.append(HttpUtil.encodeURL(values[i]));
                }
            }
        }
        return sb.toString();
    }

    public static Map<String, String[]> getRefreshURLParameters(HttpServletRequest request) {
        Portlet portlet;
        HashMap<String, String[]> refreshURLParameters = new HashMap<String, String[]>();
        String ppid = ParamUtil.getString(request, "p_p_id");
        if (ppid.equals((portlet = (Portlet)request.getAttribute("RENDER_PORTLET")).getPortletId())) {
            String namespace = PortalUtil.getPortletNamespace(portlet.getPortletId());
            Map parameters = request.getParameterMap();
            for (Map.Entry entry : parameters.entrySet()) {
                String[] values;
                String name = (String)entry.getKey();
                if (name.startsWith("_") && !name.startsWith(namespace) || PortalUtil.isReservedParameter(name) || name.equals("currentURL") || name.equals("settingsScope") || PortletURLUtil.isRefreshURLReservedParameter(name, namespace) || (values = (String[])entry.getValue()) == null) continue;
                refreshURLParameters.put(name, values);
            }
        }
        return refreshURLParameters;
    }

    protected static boolean isRefreshURLReservedParameter(String parameter, String namespace) {
        if (ArrayUtil.isEmpty(_PORTLET_URL_REFRESH_URL_RESERVED_PARAMETERS)) {
            return false;
        }
        for (String reservedParameter : _PORTLET_URL_REFRESH_URL_RESERVED_PARAMETERS) {
            if (!parameter.equals(reservedParameter) && !parameter.equals(namespace.concat(reservedParameter))) continue;
            return true;
        }
        return false;
    }
}

