/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.model;

import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import java.security.InvalidParameterException;

public class PortletInstance {
    public static final int PORTLET_INSTANCE_KEY_MAX_LENGTH = 255 - "_INSTANCE_".length() + "_USER_".length() + 39;
    private static final String _INSTANCE_SEPARATOR = "_INSTANCE_";
    private static final String _USER_SEPARATOR = "_USER_";
    private final String[] _PORTLET_NAME_KEYWORDS = new String[]{"_INSTANCE_", "_USER_"};
    private final String _instanceId;
    private final String _portletName;
    private final long _userId;

    public static PortletInstance fromPortletInstanceKey(String portletInstanceKey) {
        return new PortletInstance(PortletInstance._getPortletName(portletInstanceKey), PortletInstance._getUserId(portletInstanceKey), PortletInstance._getInstanceId(portletInstanceKey));
    }

    public static PortletInstance fromPortletNameAndUserIdAndInstanceId(String portletName, String userIdAndInstanceId) {
        UserIdAndInstanceIdEncoder userIdAndInstanceIdEncoder = PortletInstance._buildUserIdAndInstanceIdEncoder(userIdAndInstanceId);
        return new PortletInstance(portletName, userIdAndInstanceIdEncoder.getUserId(), userIdAndInstanceIdEncoder.getInstanceId());
    }

    public PortletInstance(String portletName) {
        this(portletName, StringUtil.randomString(12));
    }

    public PortletInstance(String portletName, long userId) {
        this(portletName, userId, null);
    }

    public PortletInstance(String portletName, long userId, String instanceId) {
        this._validatePortletName(portletName);
        this._portletName = portletName;
        this._userId = userId;
        this._instanceId = instanceId;
    }

    public PortletInstance(String portletName, String instanceId) {
        this(portletName, 0L, instanceId);
    }

    public String getInstanceId() {
        return this._instanceId;
    }

    public String getPortletInstanceKey() {
        StringBundler sb = new StringBundler(5);
        sb.append(this._portletName);
        if (this._userId > 0L) {
            sb.append(_USER_SEPARATOR);
            sb.append(this._userId);
        }
        if (Validator.isNotNull(this._instanceId)) {
            sb.append(_INSTANCE_SEPARATOR);
            sb.append(this._instanceId);
        }
        return sb.toString();
    }

    public String getPortletName() {
        return this._portletName;
    }

    public long getUserId() {
        return this._userId;
    }

    public String getUserIdAndInstanceId() {
        UserIdAndInstanceIdEncoder userIdAndInstanceIdEncoder = new UserIdAndInstanceIdEncoder(this._userId, this._instanceId);
        return userIdAndInstanceIdEncoder.encode();
    }

    public boolean hasIdenticalPortletName(PortletInstance portletInstance) {
        return this.hasIdenticalPortletName(portletInstance.getPortletName());
    }

    public boolean hasIdenticalPortletName(String portletName) {
        return this._portletName.equals(portletName);
    }

    public boolean hasInstanceId() {
        return Validator.isNotNull(this._instanceId);
    }

    public boolean hasUserId() {
        return this._userId > 0L;
    }

    public String toString() {
        return this.getPortletInstanceKey();
    }

    private static UserIdAndInstanceIdEncoder _buildUserIdAndInstanceIdEncoder(String userIdAndInstanceId) {
        if (userIdAndInstanceId == null) {
            throw new InvalidParameterException("User ID and instance ID are null");
        }
        if (userIdAndInstanceId.isEmpty()) {
            return new UserIdAndInstanceIdEncoder(0L, null);
        }
        int slashCount = StringUtil.count(userIdAndInstanceId, '/');
        if (slashCount > 0) {
            throw new InvalidParameterException("User ID and instance ID contain slashes");
        }
        int underlineCount = StringUtil.count(userIdAndInstanceId, '_');
        if (underlineCount > 1) {
            throw new InvalidParameterException("User ID and instance ID has more than one underscore");
        }
        if (underlineCount == 1) {
            int index = userIdAndInstanceId.indexOf(95);
            long userId = GetterUtil.getLong(userIdAndInstanceId.substring(0, index), -1L);
            if (userId == -1L) {
                throw new InvalidParameterException("User ID is not a number");
            }
            String instanceId = null;
            if (index < userIdAndInstanceId.length() - 1) {
                instanceId = userIdAndInstanceId.substring(index + 1);
            }
            return new UserIdAndInstanceIdEncoder(userId, instanceId);
        }
        return new UserIdAndInstanceIdEncoder(0L, userIdAndInstanceId);
    }

    private static String _getInstanceId(String portletInstanceKey) {
        int index = portletInstanceKey.indexOf(_INSTANCE_SEPARATOR);
        if (index == -1) {
            return null;
        }
        return portletInstanceKey.substring(index + _INSTANCE_SEPARATOR.length());
    }

    private static String _getPortletName(String portletInstanceKey) {
        int x = portletInstanceKey.indexOf(_USER_SEPARATOR);
        int y = portletInstanceKey.indexOf(_INSTANCE_SEPARATOR);
        if (x == -1 && y == -1) {
            return portletInstanceKey;
        }
        if (x != -1) {
            return portletInstanceKey.substring(0, x);
        }
        return portletInstanceKey.substring(0, y);
    }

    private static long _getUserId(String portletInstanceKey) {
        int x = portletInstanceKey.indexOf(_USER_SEPARATOR);
        int y = portletInstanceKey.indexOf(_INSTANCE_SEPARATOR);
        if (x == -1) {
            return 0L;
        }
        if (y != -1) {
            return GetterUtil.getLong(portletInstanceKey.substring(x + _USER_SEPARATOR.length(), y));
        }
        return GetterUtil.getLong(portletInstanceKey.substring(x + _USER_SEPARATOR.length()));
    }

    private void _validatePortletName(String portletName) {
        for (String keyword : this._PORTLET_NAME_KEYWORDS) {
            if (!portletName.contains(keyword)) continue;
            throw new InvalidParameterException("The portletName '" + portletName + "' must not contain the keyword " + keyword);
        }
    }

    private static final class UserIdAndInstanceIdEncoder {
        private String _instanceId;
        private long _userId;

        public UserIdAndInstanceIdEncoder(long userId, String instanceId) {
            this._userId = userId;
            this._instanceId = instanceId;
        }

        public String encode() {
            if (this._userId <= 0L && Validator.isBlank(this._instanceId)) {
                return null;
            }
            StringBundler sb = new StringBundler(3);
            if (this._userId > 0L) {
                sb.append(this._userId);
                sb.append("_");
            }
            if (this._instanceId != null) {
                sb.append(this._instanceId);
            }
            return sb.toString();
        }

        public String getInstanceId() {
            return this._instanceId;
        }

        public long getUserId() {
            return this._userId;
        }

        public String toString() {
            return this.encode();
        }
    }
}

