/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.portal.kernel.concurrent;

import com.liferay.portal.kernel.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.portal.kernel.concurrent.DefaultNoticeableFuture;
import com.liferay.portal.kernel.concurrent.FutureListener;
import com.liferay.portal.kernel.concurrent.NoticeableFuture;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.memory.FinalizeAction;
import com.liferay.portal.kernel.memory.FinalizeManager;
import com.liferay.portal.kernel.util.ReflectionUtil;
import java.lang.ref.Reference;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Future;

public class AsyncBroker<K, V> {
    private static final Field _REFERENT_FIELD;
    private static final Log _log;
    private final ConcurrentMap<K, DefaultNoticeableFuture<V>> _defaultNoticeableFutures = new ConcurrentReferenceValueHashMap<K, DefaultNoticeableFuture<V>>(FinalizeManager.WEAK_REFERENCE_FACTORY);

    public Map<K, NoticeableFuture<V>> getOpenBids() {
        return Collections.unmodifiableMap(this._defaultNoticeableFutures);
    }

    public NoticeableFuture<V> post(K key) {
        DefaultNoticeableFuture defaultNoticeableFuture = new DefaultNoticeableFuture();
        NoticeableFuture previousNoticeableFuture = this.post(key, defaultNoticeableFuture);
        if (previousNoticeableFuture == null) {
            return defaultNoticeableFuture;
        }
        return previousNoticeableFuture;
    }

    public NoticeableFuture<V> post(final K key, final DefaultNoticeableFuture<V> defaultNoticeableFuture) {
        DefaultNoticeableFuture<V> previousDefaultNoticeableFuture = this._defaultNoticeableFutures.putIfAbsent(key, defaultNoticeableFuture);
        if (previousDefaultNoticeableFuture != null) {
            return previousDefaultNoticeableFuture;
        }
        defaultNoticeableFuture.addFutureListener(new FutureListener<V>(){

            @Override
            public void complete(Future<V> future) {
                AsyncBroker.this._defaultNoticeableFutures.remove(key, defaultNoticeableFuture);
            }
        });
        if (_REFERENT_FIELD != null) {
            FinalizeManager.register(defaultNoticeableFuture, new CancellationFinalizeAction(key), FinalizeManager.PHANTOM_REFERENCE_FACTORY);
        }
        return null;
    }

    public NoticeableFuture<V> take(K key) {
        return (NoticeableFuture)this._defaultNoticeableFutures.remove(key);
    }

    public boolean takeWithException(K key, Throwable throwable) {
        DefaultNoticeableFuture defaultNoticeableFuture = (DefaultNoticeableFuture)this._defaultNoticeableFutures.remove(key);
        if (defaultNoticeableFuture == null) {
            return false;
        }
        defaultNoticeableFuture.setException(throwable);
        return true;
    }

    public boolean takeWithResult(K key, V result) {
        DefaultNoticeableFuture defaultNoticeableFuture = (DefaultNoticeableFuture)this._defaultNoticeableFutures.remove(key);
        if (defaultNoticeableFuture == null) {
            return false;
        }
        defaultNoticeableFuture.set(result);
        return true;
    }

    static {
        Field referentField;
        block2: {
            _log = LogFactoryUtil.getLog(AsyncBroker.class);
            referentField = null;
            try {
                referentField = ReflectionUtil.getDeclaredField(Reference.class, "referent");
            }
            catch (Throwable t) {
                if (!_log.isWarnEnabled()) break block2;
                _log.warn("Cancellation of orphaned noticeable futures is disabled because the JVM does not support phantom reference resurrection", t);
            }
        }
        _REFERENT_FIELD = referentField;
    }

    private static class CancellationFinalizeAction
    implements FinalizeAction {
        private final Object _key;

        public CancellationFinalizeAction(Object key) {
            this._key = key;
        }

        @Override
        public void doFinalize(Reference<?> reference) {
            try {
                NoticeableFuture noticeableFuture = (NoticeableFuture)_REFERENT_FIELD.get(reference);
                if (noticeableFuture.cancel(true) && _log.isWarnEnabled()) {
                    _log.warn("Cancelled orphan noticeable future " + noticeableFuture + " with key " + this._key);
                }
            }
            catch (Exception e) {
                _log.error("Unable to access referent of " + reference, e);
            }
        }
    }
}

