/*
 * Decompiled with CFR 0.152.
 */
package com.librato.metrics;

import com.codahale.metrics.Histogram;
import com.codahale.metrics.Metered;
import com.codahale.metrics.Metric;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaTracker {
    private static final Logger LOG = LoggerFactory.getLogger(DeltaTracker.class);
    private final ConcurrentMap<String, Long> lookup = new ConcurrentHashMap<String, Long>();

    public DeltaTracker() {
        this(new MetricSupplier(){

            @Override
            public Map<String, Metric> getMetrics() {
                return new HashMap<String, Metric>();
            }
        });
    }

    public DeltaTracker(MetricSupplier supplier) {
        for (Map.Entry<String, Metric> entry : supplier.getMetrics().entrySet()) {
            String name = entry.getKey();
            Metric metric = entry.getValue();
            if (metric instanceof Metered) {
                this.lookup.put(name, ((Metered)metric).getCount());
            }
            if (!(metric instanceof Histogram)) continue;
            this.lookup.put(name, ((Histogram)metric).getCount());
        }
    }

    public Long peekDelta(String name, long count) {
        Long previous = (Long)this.lookup.get(name);
        if (previous == null) {
            previous = 0L;
        }
        return this.calculateDelta(name, previous, count);
    }

    public Long getDelta(String name, long count) {
        Long previous = this.lookup.put(name, count);
        if (previous == null) {
            previous = 0L;
        }
        return this.calculateDelta(name, previous, count);
    }

    private Long calculateDelta(String name, Long previous, long count) {
        if (count < previous) {
            LOG.error("Saw a non-monotonically increasing value for metric {}", (Object)name);
            return 0L;
        }
        return count - previous;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface MetricSupplier {
        public Map<String, Metric> getMetrics();
    }
}

