/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import com.landicorp.android.eptapi.log.Logger;

public class TimeSlicer {
    private static final Logger logger = Logger.getLogger(TimeSlicer.class);
    private long beginTimeMillis = System.currentTimeMillis();
    private long currentTimeMillis = System.currentTimeMillis();
    private boolean isInited = false;

    private TimeSlicer() {
    }

    public static TimeSlicer create() {
        return new TimeSlicer();
    }

    public void reset() {
        this.beginTimeMillis = System.currentTimeMillis();
    }

    public void mark() {
        if (!this.isInited) {
            this.beginTimeMillis = System.currentTimeMillis();
            this.isInited = true;
        }
        this.currentTimeMillis = System.currentTimeMillis();
    }

    public void slice(String info) {
        long totalTime = System.currentTimeMillis() - this.beginTimeMillis;
        long elapsedTime = System.currentTimeMillis() - this.currentTimeMillis;
        logger.debug(info + " # elapsedTime: " + elapsedTime + "(ms), totalTime: " + totalTime + "(ms) #", new Object[0]);
        this.currentTimeMillis = System.currentTimeMillis();
    }
}

