/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.TLV;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class TLVList {
    private List<TLV> data = new ArrayList<TLV>();

    public static TLVList fromBinary(byte[] data) {
        TLV d;
        TLVList l = new TLVList();
        for (int offset = 0; offset < data.length; offset += d.getRawData().length) {
            d = TLV.fromRawData(data, offset);
            l.addTLV(d);
        }
        return l;
    }

    public static TLVList fromBinary(String data) {
        return TLVList.fromBinary(BytesUtil.hexString2Bytes(data));
    }

    public int size() {
        return this.data.size();
    }

    public byte[] toBinary() {
        byte[][] allData = new byte[this.data.size()][];
        for (int i = 0; i < this.data.size(); ++i) {
            allData[i] = this.data.get(i).getRawData();
        }
        return BytesUtil.merage(allData);
    }

    public boolean contains(String tag) {
        return null != this.getTLV(tag);
    }

    public TLV getTLV(String tag) {
        for (TLV d : this.data) {
            if (!d.getTag().equals(tag)) continue;
            return d;
        }
        return null;
    }

    public TLVList getTLVs(String ... tags) {
        TLVList list = new TLVList();
        for (String tag : tags) {
            TLV data = this.getTLV(tag);
            if (data == null) continue;
            list.addTLV(data);
        }
        if (list.size() == 0) {
            return null;
        }
        return list;
    }

    public TLV getTLV(int index) {
        return this.data.get(index);
    }

    public void addTLV(TLV tlv) {
        if (!tlv.isValid()) {
            throw new IllegalArgumentException("tlv is not valid!");
        }
        this.data.add(tlv);
    }

    public void retainAll(String ... tags) {
        List<String> tagList = Arrays.asList(tags);
        int index = 0;
        while (index < this.data.size()) {
            if (!tagList.contains(this.data.get(index).getTag())) {
                this.data.remove(index);
                continue;
            }
            ++index;
        }
    }

    public void remove(String tag) {
        int i = 0;
        while (i < this.data.size()) {
            if (tag.equals(this.data.get(i).getTag())) {
                this.data.remove(i);
                continue;
            }
            ++i;
        }
    }

    public void removeAll(String ... tags) {
        List<String> tagList = Arrays.asList(tags);
        int i = 0;
        while (i < this.data.size()) {
            if (tagList.contains(this.data.get(i).getTag())) {
                this.data.remove(i);
                continue;
            }
            ++i;
        }
    }

    public String toString() {
        return this.data.isEmpty() ? "" : BytesUtil.bytes2HexString(this.toBinary());
    }
}

