/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import com.landicorp.android.eptapi.utils.BytesUtil;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;

public class TLV {
    private byte[] data;
    private String tag;
    private int length = -1;
    private byte[] value;

    private TLV() {
    }

    public static TLV fromRawData(byte[] tlData, int tlOffset, byte[] vData, int vOffset) {
        int tLen = TLV.getTLength(tlData, tlOffset);
        int lLen = TLV.getLLength(tlData, tlOffset + tLen);
        int vLen = TLV.calcValueLength(tlData, tlOffset + tLen, lLen);
        TLV d = new TLV();
        d.data = BytesUtil.merage(BytesUtil.subBytes(tlData, tlOffset, tLen + lLen), BytesUtil.subBytes(vData, vOffset, vLen));
        d.getTag();
        d.getLength();
        d.getBytesValue();
        return d;
    }

    public static TLV fromData(String tagName, byte[] value) {
        byte[] tag = BytesUtil.hexString2Bytes(tagName);
        TLV d = new TLV();
        d.data = BytesUtil.merage(tag, TLV.makeLengthData(value.length), value);
        d.tag = tagName;
        d.length = value.length;
        d.value = value;
        return d;
    }

    public static TLV fromRawData(byte[] data, int offset) {
        int len = TLV.getDataLength(data, offset);
        TLV d = new TLV();
        d.data = BytesUtil.subBytes(data, offset, len);
        d.getTag();
        d.getLength();
        d.getBytesValue();
        return d;
    }

    public String getTag() {
        if (this.tag != null) {
            return this.tag;
        }
        int tLen = TLV.getTLength(this.data, 0);
        this.tag = BytesUtil.bytes2HexString(BytesUtil.subBytes(this.data, 0, tLen));
        return this.tag;
    }

    public int getLength() {
        if (this.length > -1) {
            return this.length;
        }
        int offset = TLV.getTLength(this.data, 0);
        int l = TLV.getLLength(this.data, offset);
        if (l == 1) {
            return this.data[offset] & 0xFF;
        }
        int afterLen = 0;
        for (int i = 1; i < l; ++i) {
            afterLen <<= 8;
            afterLen |= this.data[offset + i] & 0xFF;
        }
        this.length = afterLen;
        return this.length;
    }

    public int getTLLength() {
        if (this.data == null) {
            return -1;
        }
        return this.data.length - this.getBytesValue().length;
    }

    public String getValue() {
        byte[] temp = this.getBytesValue();
        return BytesUtil.bytes2HexString(temp == null ? new byte[]{} : temp);
    }

    public byte getByteValue() {
        return this.getBytesValue()[0];
    }

    public String getGBKValue() {
        try {
            return new String(this.getBytesValue(), "GBK");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getNumberValue() {
        String num = this.getValue();
        if (num == null) {
            return null;
        }
        return String.valueOf(Long.parseLong(num));
    }

    public byte[] getNumberASCValue() {
        try {
            String result = this.getNumberValue();
            if (result == null) {
                return null;
            }
            return result.getBytes("GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public byte[] getBCDValue() {
        String result = this.getGBKValue();
        if (result == null) {
            return null;
        }
        return BytesUtil.hexString2Bytes(result);
    }

    public byte[] getRawData() {
        return this.data;
    }

    public byte[] getBytesValue() {
        if (this.value != null) {
            return this.value;
        }
        int l = this.getLength();
        this.value = BytesUtil.subBytes(this.data, this.data.length - l, l);
        return this.value;
    }

    public boolean isValid() {
        return this.data != null;
    }

    private static int getTLength(byte[] data, int offset) {
        if ((data[offset] & 0x1F) == 31) {
            return TLV.parseTLength(data, ++offset, 2);
        }
        return 1;
    }

    private static int parseTLength(byte[] data, int nextOffset, int clen) {
        if ((data[nextOffset] & 0x80) == 128) {
            ++clen;
            clen = TLV.parseTLength(data, ++nextOffset, clen);
        }
        return clen;
    }

    private static int getLLength(byte[] data, int offset) {
        if ((data[offset] & 0x80) == 0) {
            return 1;
        }
        return (data[offset] & 0x7F) + 1;
    }

    private static int getDataLength(byte[] data, int offset) {
        int tLen = TLV.getTLength(data, offset);
        int lLen = TLV.getLLength(data, offset + tLen);
        int vLen = TLV.calcValueLength(data, offset + tLen, lLen);
        return tLen + lLen + vLen;
    }

    private static int calcValueLength(byte[] l, int offset, int lLen) {
        if (lLen == 1) {
            return l[offset] & 0xFF;
        }
        int vLen = 0;
        for (int i = 1; i < lLen; ++i) {
            vLen <<= 8;
            vLen |= l[offset + i] & 0xFF;
        }
        return vLen;
    }

    private static byte[] makeLengthData(int len) {
        if (len > 127) {
            byte[] tempLen = BytesUtil.intToBytes(len);
            int start = 0;
            for (int i = 0; i < tempLen.length; ++i) {
                if (tempLen[i] == 0) continue;
                start = i;
                break;
            }
            byte[] lenData = BytesUtil.subBytes(tempLen, start, -1);
            lenData = BytesUtil.merage({(byte)(0x80 | lenData.length)}, lenData);
            return lenData;
        }
        return new byte[]{(byte)len};
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TLV)) {
            return false;
        }
        if (this.data == null || ((TLV)obj).data == null) {
            return false;
        }
        return Arrays.equals(this.data, ((TLV)obj).data);
    }

    public String toString() {
        if (this.data == null) {
            return super.toString();
        }
        return BytesUtil.bytes2HexString(this.data);
    }
}

