/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class StringUtil {
    private static final String PLATFORM_DEFAULT_ENCODING = Charset.defaultCharset().name();
    public static final String SHIFT_JIS = "SJIS";
    public static final String GB18030 = "GB18030";
    public static final String EUC_JP = "EUC_JP";
    public static final String UTF8 = "UTF8";
    public static final String ISO88591 = "ISO8859_1";
    private static final boolean ASSUME_SHIFT_JIS = "SJIS".equalsIgnoreCase(PLATFORM_DEFAULT_ENCODING) || "EUC_JP".equalsIgnoreCase(PLATFORM_DEFAULT_ENCODING);
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    public static byte[] getGBK(String str) {
        if (str == null) {
            return EMPTY_BYTE_ARRAY;
        }
        try {
            return str.getBytes("GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static byte[] getGB18030(String str) {
        if (str == null) {
            return EMPTY_BYTE_ARRAY;
        }
        try {
            return str.getBytes(GB18030);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String fromGBK(byte[] strData) {
        try {
            return new String(strData, "GBK");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String fromUTF8(byte[] strData) {
        try {
            return new String(strData, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    public static String guessEncoding(byte[] bytes) {
        int length = bytes.length;
        boolean canBeISO88591 = true;
        boolean canBeShiftJIS = true;
        boolean canBeUTF8 = true;
        boolean canBeGB18030 = true;
        int gb18030Bytes = 0;
        int utf8BytesLeft = 0;
        int utf2BytesChars = 0;
        int utf3BytesChars = 0;
        int utf4BytesChars = 0;
        int sjisBytesLeft = 0;
        int sjisKatakanaChars = 0;
        int sjisCurKatakanaWordLength = 0;
        int sjisCurDoubleBytesWordLength = 0;
        int sjisMaxKatakanaWordLength = 0;
        int sjisMaxDoubleBytesWordLength = 0;
        int isoHighOther = 0;
        boolean utf8bom = bytes.length > 3 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65;
        for (int i = 0; i < length && (canBeISO88591 || canBeShiftJIS || canBeUTF8 || canBeGB18030); ++i) {
            int value = bytes[i] & 0xFF;
            if (canBeUTF8) {
                if (utf8BytesLeft > 0) {
                    if ((value & 0x80) == 0) {
                        canBeUTF8 = false;
                    } else {
                        --utf8BytesLeft;
                    }
                } else if ((value & 0x80) != 0) {
                    if ((value & 0x40) == 0) {
                        canBeUTF8 = false;
                    } else {
                        ++utf8BytesLeft;
                        if ((value & 0x20) == 0) {
                            ++utf2BytesChars;
                        } else {
                            ++utf8BytesLeft;
                            if ((value & 0x10) == 0) {
                                ++utf3BytesChars;
                            } else {
                                ++utf8BytesLeft;
                                if ((value & 8) == 0) {
                                    ++utf4BytesChars;
                                } else {
                                    canBeUTF8 = false;
                                }
                            }
                        }
                    }
                }
            }
            if (canBeISO88591) {
                if (value > 127 && value < 160) {
                    canBeISO88591 = false;
                } else if (value > 159 && (value < 192 || value == 215 || value == 247)) {
                    ++isoHighOther;
                }
            }
            if (canBeGB18030) {
                if (gb18030Bytes > 0) {
                    switch (gb18030Bytes) {
                        case 2: {
                            if (value >= 64 && value <= 126 || value >= 128 && value <= 254) {
                                gb18030Bytes = 0;
                                break;
                            }
                            if (value >= 48 && value <= 57) {
                                gb18030Bytes = 3;
                                break;
                            }
                            canBeGB18030 = false;
                            break;
                        }
                        case 3: {
                            if (value >= 129 && value <= 4067) {
                                gb18030Bytes = 4;
                                break;
                            }
                            canBeGB18030 = false;
                            break;
                        }
                        case 4: {
                            if (value >= 48 && value <= 57) {
                                gb18030Bytes = 0;
                                break;
                            }
                            canBeGB18030 = false;
                            break;
                        }
                        default: {
                            canBeGB18030 = false;
                            break;
                        }
                    }
                } else if (value < 0 || value > 127) {
                    if (value >= 129 && value <= 254) {
                        gb18030Bytes = 2;
                    } else {
                        canBeGB18030 = false;
                    }
                }
            }
            if (!canBeShiftJIS) continue;
            if (sjisBytesLeft > 0) {
                if (64 <= value && value <= 126 || 128 <= value && value <= 252) {
                    int code = (bytes[i - 1] & 0xFF) << 8 | bytes[i] & 0xFF;
                    if (33197 <= code && code <= 33207 || 33216 <= code && code <= 33223 || 33231 <= code && code <= 33241 || 33257 <= code && code <= 33263 || 33272 <= code && code <= 33276 || 33344 <= code && code <= 33358 || 33369 <= code && code <= 33375 || 33402 <= code && code <= 33408 || 33435 <= code && code <= 33438 || 33522 <= code && code <= 33532 || 33687 <= code && code <= 33694 || 33719 <= code && code <= 33726 || 33751 <= code && code <= 33788 || 33889 <= code && code <= 33903 || 33938 <= code && code <= 33950 || 33983 <= code && code <= 34044 || 34112 <= code && code <= 34974 || 39027 <= code && code <= 39070 || 60325 <= code && code <= 60412 || 60224 <= code && code <= 61436) {
                        canBeShiftJIS = false;
                        continue;
                    }
                    sjisBytesLeft = 0;
                    sjisCurKatakanaWordLength = 0;
                    if (++sjisCurDoubleBytesWordLength <= sjisMaxDoubleBytesWordLength) continue;
                    sjisMaxDoubleBytesWordLength = sjisCurDoubleBytesWordLength;
                    continue;
                }
                canBeShiftJIS = false;
                continue;
            }
            if (0 <= value && value <= 31 || value == 127 || 32 <= value && value <= 126 || 161 <= value && value <= 223) {
                if (161 > value || value > 223) continue;
                ++sjisKatakanaChars;
                sjisCurDoubleBytesWordLength = 0;
                if (++sjisCurKatakanaWordLength <= sjisMaxKatakanaWordLength) continue;
                sjisMaxKatakanaWordLength = sjisCurKatakanaWordLength;
                continue;
            }
            if (129 <= value && value <= 159 || 224 <= value && value <= 239) {
                sjisBytesLeft = 1;
                continue;
            }
            canBeShiftJIS = false;
        }
        if (canBeUTF8 && utf8BytesLeft > 0) {
            canBeUTF8 = false;
        }
        if (canBeShiftJIS && sjisBytesLeft > 0) {
            canBeShiftJIS = false;
        }
        if (canBeGB18030 && gb18030Bytes > 0) {
            canBeGB18030 = false;
        }
        if (canBeUTF8 && (utf8bom || utf2BytesChars + utf3BytesChars + utf4BytesChars > 0)) {
            return UTF8;
        }
        if (canBeGB18030) {
            if (canBeShiftJIS) {
                return sjisMaxKatakanaWordLength > sjisMaxDoubleBytesWordLength ? GB18030 : SHIFT_JIS;
            }
            return GB18030;
        }
        if (canBeShiftJIS && (ASSUME_SHIFT_JIS || sjisMaxKatakanaWordLength >= 3 || sjisMaxDoubleBytesWordLength >= 3)) {
            return SHIFT_JIS;
        }
        if (canBeISO88591 && canBeShiftJIS) {
            return sjisMaxKatakanaWordLength == 2 && sjisKatakanaChars == 2 || isoHighOther * 10 >= length ? SHIFT_JIS : ISO88591;
        }
        if (canBeISO88591) {
            return ISO88591;
        }
        if (canBeShiftJIS) {
            return SHIFT_JIS;
        }
        if (canBeUTF8) {
            return UTF8;
        }
        return PLATFORM_DEFAULT_ENCODING;
    }
}

