/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.utils;

import java.util.Locale;

public final class Precondition {
    private Precondition() {
    }

    public static void checkArgument(boolean expression) {
        if (!expression) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(Precondition.format(message));
        }
    }

    public static void checkTrue(boolean condition) {
        if (!condition) {
            throw new IllegalStateException();
        }
    }

    public static void checkTrue(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(Precondition.format(message));
        }
    }

    public static void checkFalse(boolean condition) {
        Precondition.checkTrue(!condition);
    }

    public static void checkFalse(boolean condition, String message) {
        Precondition.checkTrue(!condition, message);
    }

    public static <T> void checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException();
        }
    }

    public static <T> void checkNotNull(T object, String message) {
        if (object == null) {
            throw new NullPointerException(Precondition.format(message));
        }
    }

    public static <T> void checkNotNullEmpty(T[] array) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException();
        }
    }

    public static <T> void checkNotNullEmpty(T[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(Precondition.format(message));
        }
    }

    public static void checkArraySize(byte[] array, int size) {
        Precondition.checkArraySize(array, size, null);
    }

    public static void checkArraySize(byte[] array, int size, String message) {
        if (array == null) {
            throw new NullPointerException(Precondition.format(message));
        }
        if (array.length != size) {
            throw new IllegalArgumentException(Precondition.format(array, size, message));
        }
    }

    private static String format(byte[] array, int size, String message) {
        String formatted = "";
        if (message != null) {
            formatted = formatted + message + "";
        }
        return formatted + "expected size:<" + size + "> but real size:<" + size + ">";
    }

    public static void checkNotEmpty(byte[] array) {
        Precondition.checkNotEmpty(array, null);
    }

    public static void checkNotEmpty(byte[] array, String message) {
        if (array == null || array.length == 0) {
            throw new IllegalArgumentException(Precondition.format(message));
        }
    }

    public static void checkNotEmpty(String str) {
        Precondition.checkNotEmpty(str, null);
    }

    public static void checkNotEmpty(String str, String message) {
        if (str == null || str.length() == 0) {
            throw new IllegalArgumentException(Precondition.format(message));
        }
    }

    private static String format(String message) {
        return message == null ? "" : message;
    }

    public static boolean checkInRange(long actual, long lower, long upper) {
        return actual >= lower && actual <= upper;
    }

    public static boolean checkNotInRange(long actual, long lower, long upper) {
        return actual < lower || actual > upper;
    }

    public static void checkRange(long actual, long lower, long upper) {
        if (!Precondition.checkInRange(actual, lower, upper)) {
            throw new IllegalArgumentException(Precondition.format(actual, lower, upper, null));
        }
    }

    public static void checkRange(long actual, long lower, long upper, String message) {
        if (!Precondition.checkInRange(actual, lower, upper)) {
            throw new IllegalArgumentException(Precondition.format(actual, lower, upper, message));
        }
    }

    static String format(long actual, long lower, long upper, String message) {
        String formatted = "";
        if (message != null) {
            formatted = formatted + message + " ";
        }
        return formatted + "actual:<" + actual + "> but range:[" + lower + ", " + upper + "]";
    }

    public static void checkElementIndex(int index, int size) {
        Precondition.checkElementIndex(index, size, null);
    }

    public static void checkElementIndex(int index, int size, String message) {
        if (index < 0 || index >= size) {
            throw new IndexOutOfBoundsException(Precondition.badElementIndex(index, size, message));
        }
    }

    private static String badElementIndex(int index, int size, String message) {
        String formatted;
        String string = formatted = message == null ? "" : message;
        if (index < 0) {
            return String.format(Locale.US, "%s (%d) must not be negative.", formatted, index);
        }
        if (size < 0) {
            return String.format(Locale.US, "%s negative size: %d.", formatted, size);
        }
        return String.format(Locale.US, "%s (%d) must be less than size: %d.", formatted, index, size);
    }
}

