/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.tms;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.RemoteException;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.tms.AppInfo;
import com.landicorp.android.eptapi.tms.ITMS;
import com.landicorp.android.eptapi.tms.ModuleConfigInfo;
import com.landicorp.android.eptapi.tms.ResultListener;
import com.landicorp.android.eptapi.tms.TermInfo;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class TMS {
    private ITMS iTMS = new ITMS();
    private static final String TAG = "TMS";
    private int apk_nums = 0;

    public boolean update() throws RequestException {
        try {
            return this.iTMS.installApplication();
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
    }

    @Deprecated
    public boolean updateManu() {
        return this.iTMS.updateManu();
    }

    public void reboot() throws RequestException {
        try {
            this.iTMS.reboot();
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
    }

    public void getTermInfo(TermInfo info) throws RequestException {
        String content;
        try {
            content = new String(this.iTMS.getTerminalInfo());
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
        String[] arr = content.split("\n");
        info.setEquipmentManufacturers(arr[0]);
        info.setTerminalType(arr[1]);
        info.setSn(arr[2]);
        info.setPlatform(arr[3]);
    }

    public void getAppInfo(List<AppInfo> list) throws RequestException {
        String strApps;
        try {
            strApps = StringUtil.fromGBK(this.iTMS.getApplicationInfo());
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
        String[] arrApps = strApps.split("\n");
        for (int i = 5; i < arrApps.length; ++i) {
            if (0 != arrApps[i].indexOf("FileName:")) continue;
            list.add(this.makeAppInfo(arrApps, i));
        }
    }

    public byte[] getAppInfo() throws RequestException {
        try {
            return this.iTMS.getApplicationInfo();
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
    }

    public void getAppInfo(Context context, List<AppInfo> list) throws RequestException {
        String strApps;
        try {
            strApps = this.createUploadCurProgs(context);
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
        String[] arrApps = strApps.split("\n");
        for (int i = 5; i < arrApps.length; ++i) {
            if (0 != arrApps[i].indexOf("FileName:")) continue;
            list.add(this.makeAppInfo(arrApps, i));
        }
    }

    private AppInfo makeAppInfo(String[] arrApps, int index) {
        AppInfo info = new AppInfo();
        info.setAppName(this.getValue(arrApps[index++]));
        info.setApkSize(this.getValue(arrApps[index++]));
        info.setProgramSize(this.getValue(arrApps[index++]));
        info.setDataFileSize(this.getValue(arrApps[index++]));
        info.setMemoryFileSize(this.getValue(arrApps[index++]));
        info.setExtendLen(this.getValue(arrApps[index++]));
        info.setAppType(this.getValue(arrApps[index++]));
        info.setDisplayName(this.getValue(arrApps[index++]));
        info.setVersion(this.getValue(arrApps[index++]));
        info.setAreaName(this.getValue(arrApps[index++]));
        info.setProcFlag(this.getValue(arrApps[index++]));
        info.setBakFlag(this.getValue(arrApps[index++]));
        info.setPriority(this.getValue(arrApps[index++]));
        info.setDefaultApp(this.getValue(arrApps[index++]));
        return info;
    }

    private String getValue(String info) {
        String[] arr = info.split(":");
        if (arr.length > 1) {
            return info.split(":")[1].trim();
        }
        return "";
    }

    public byte[] getAppInfo(Context context) throws RequestException {
        try {
            return StringUtil.getGBK(this.createUploadCurProgs(context));
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
    }

    private String createUploadCurProgs(Context context) throws RemoteException {
        String pkgInfoStr = StringUtil.fromGBK(this.iTMS.getApplicationInfo());
        String apkinfos = this.getInstalledApps(context);
        String pkgNum = pkgInfoStr.substring(pkgInfoStr.indexOf("PkgNum"));
        pkgNum = pkgNum.substring(0, pkgNum.indexOf("\n"));
        int pkgNumInt = Integer.parseInt(pkgNum.substring(pkgNum.indexOf(": ") + 2));
        String newPkgNum = "PkgNum: " + (pkgNumInt += this.apk_nums);
        pkgInfoStr = pkgInfoStr.replace(pkgNum, newPkgNum);
        apkinfos = apkinfos.substring(apkinfos.indexOf("\n")) + "\nEssentialNum";
        pkgInfoStr = pkgInfoStr.replace("EssentialNum", apkinfos);
        return pkgInfoStr;
    }

    private String getInstalledApps(Context context) {
        this.apk_nums = 0;
        StringBuilder apps = new StringBuilder();
        PackageManager pm = context.getPackageManager();
        List installedPackages = pm.getInstalledPackages(0);
        for (PackageInfo packageInfo : installedPackages) {
            if ((packageInfo.applicationInfo.flags & 1) != 0 || (packageInfo.applicationInfo.flags & 0x80) != 0) continue;
            ++this.apk_nums;
            apps.append(this.createApkInfo(packageInfo.packageName, packageInfo.versionName));
        }
        return apps.toString();
    }

    private String createApkInfo(String packageName, String versionName) {
        StringBuilder app = new StringBuilder();
        app.append("\n");
        app.append("FileName: " + packageName + "\n");
        app.append("FileSize: 0\n");
        app.append("ProgramSize: 0\n");
        app.append("DataFileSize: 0\n");
        app.append("MemoryFileSize: 0\n");
        app.append("ExtendLen: 0\n");
        app.append("FileType: EPT-AND-APK\n");
        app.append("DisplayName: \n");
        app.append("Version: " + versionName + "\n");
        app.append("AreaName: EPT_Super\n");
        app.append("ProcFlag: 0\n");
        app.append("BakFlag: 0\n");
        app.append("Priority: 0\n");
        app.append("DefaultApp: 0");
        return app.toString();
    }

    public int getDownloadFreeSpace() throws RequestException {
        try {
            return this.iTMS.getDownloadFreeSpace();
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
    }

    public String getDownloadPath() throws RequestException {
        try {
            return this.iTMS.getDownloadPath();
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
    }

    public String getOSVersion() throws RequestException {
        try {
            return this.iTMS.getOSVersion();
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
    }

    public void getUpdateResult(final ResultListener listener) throws RequestException {
        if (listener == null) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                while (true) {
                    String result = null;
                    try {
                        result = TMS.this.iTMS.getUpdateResult();
                    }
                    catch (RemoteException e1) {
                        listener.onError(-1);
                        return;
                    }
                    if ("2".equals(result)) {
                        JSONObject json = new JSONObject();
                        try {
                            json.put("install", true);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                            listener.onSuccess(null);
                            return;
                        }
                        json.toString();
                        listener.onSuccess(json);
                        return;
                    }
                    try {
                        Thread.sleep(1000L);
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                        continue;
                    }
                    break;
                }
            }
        }.start();
    }

    public Map<String, String> getModulesVersion(String path, List<String> modules) {
        HashMap<String, String> modulesVersion = new HashMap<String, String>();
        for (String module : modules) {
            try {
                String version = this.iTMS.getModuleVersion(path + "/" + module);
                modulesVersion.put(module, version);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
        return modulesVersion;
    }

    public ModuleConfigInfo getModuleConfigInfo(int moduleId) {
        try {
            return this.iTMS.getModuleConfigInfo(moduleId);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean isOvsTerm() {
        return this.iTMS.isOvsTerm();
    }
}

