/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.service;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.Context;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Parcel;
import android.os.RemoteException;
import android.text.TextUtils;
import com.landicorp.android.eptapi.exception.ReloginException;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.exception.ServiceOccupiedException;
import com.landicorp.android.eptapi.exception.UnsupportMultiProcess;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.ClientInfo;
import com.landicorp.android.eptapi.service.ClientManager;
import com.landicorp.android.eptapi.service.RequestCode;
import com.landicorp.android.eptapi.service.RunnableBinder;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.service.SystemServiceManager;
import java.util.List;

public class MasterController {
    static final Logger logger = Logger.getLogger(MasterController.class);
    private static final int TXN_CLIENT_LOGIN = 2;
    private static final int TXN_CLIENT_LOGOUT = 3;
    private static final int TXN_CLIENT_REQUEST = 4;
    private static final int TXN_CLIENT_SET_TASK = 5;
    private static final int TXN_CLIENT_CHECK_LOGIN = 6;
    private static final int TXN_CLIENT_LOGIN_DEVICE = 7;
    private static final int TXN_CLIENT_RUNONIPC = 8;
    private static final int TXN_CLIENT_REQUEST_UPDATE_DEPENDENCE = 10003;
    private static final int TXN_STATIC_REQUEST = 65536;
    static final int TXN_EVENT_UPDATE_RESULT = 10004;
    private static final int EXTEND_REQUEST_MASK = Integer.MIN_VALUE;
    private static final int EXTEND_NEED_BINDER_MASK = 0x40000000;
    public static final int SYSTEM_SET_TIME = -2147483647;
    public static final int SYSTEM_ENABLE_USB_STORAGE = -1073741822;
    public static final int SYSTEM_DISABLE_USB_STORAGE = -1073741821;
    private static final int ERROR_NONE = 0;
    private static final int ERROR_ALREADY_LOGIN = 1;
    private static final int ERROR_UNSUPPORT_MULTI_PROCESS = 2;
    private static final int ERROR_MC_IS_OCCUPIED = 3;
    public static final String DEFAULT_NATIVE_APP_NAME = "__default_native_app_name__";
    private static MasterController mInstance = new MasterController();
    private static String defaultAppName = "__default_native_app_name__";
    private static final int RETRY_DELAY = 500;
    private IBinder mListenBinder;
    private IBinder mServiceBinder = null;
    private Context mContext;
    private Handler uiHandler = new Handler(Looper.getMainLooper());
    private IBinder.DeathRecipient mServiceDeathRecipient = new IBinder.DeathRecipient(){

        public void binderDied() {
            ClientManager.instance().resetClients();
            ServiceVariable.clear();
        }
    };

    private MasterController() {
    }

    public static MasterController getInstance() {
        return mInstance;
    }

    public void init(Context context) {
        this.mContext = context;
    }

    public String getDefaultAppName() {
        if (this.mContext != null) {
            Context appContext = this.mContext.getApplicationContext();
            defaultAppName = appContext.getPackageName();
        }
        return defaultAppName;
    }

    public boolean isThirdPartyDevice() {
        return false;
    }

    private IBinder getServiceBinder() throws RequestException {
        IBinder service = null;
        try {
            service = SystemServiceManager.getService("masterCtlService");
            if (service == null) {
                throw new RequestException();
            }
        }
        catch (Exception e) {
            throw new RequestException();
        }
        return service;
    }

    private IBinder getExtendServiceBinder() throws RequestException {
        IBinder service = null;
        try {
            service = SystemServiceManager.getService("masterCtlService_extend");
            if (service == null) {
                throw new RequestException();
            }
        }
        catch (Exception e) {
            throw new RequestException();
        }
        return service;
    }

    public void listenServiceDeath(final IBinder.DeathRecipient deathListener) {
        try {
            if (this.mListenBinder == null) {
                this.mListenBinder = this.getServiceBinder();
            }
            this.mListenBinder.linkToDeath(new IBinder.DeathRecipient(){

                public void binderDied() {
                    MasterController.this.mListenBinder = null;
                    if (deathListener != null) {
                        deathListener.binderDied();
                    }
                    MasterController.this.uiHandler.postDelayed(new Runnable(){

                        @Override
                        public void run() {
                            MasterController.this.listenServiceDeath(deathListener);
                        }
                    }, 500L);
                }
            }, 0);
        }
        catch (RequestException e) {
            e.printStackTrace();
            this.uiHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MasterController.this.listenServiceDeath(deathListener);
                }
            }, 500L);
        }
        catch (RemoteException e) {
            e.printStackTrace();
            this.uiHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    MasterController.this.listenServiceDeath(deathListener);
                }
            }, 500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean switchDebug(int mode) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            IBinder binder = this.createOrOpenBinder();
            data.writeInt(0xFF0004);
            data.writeInt(mode);
            binder.transact(65536, data, reply, 0);
            boolean bl = reply.readInt() == 0;
            return bl;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            logger.error("MC Service down!!!", new Object[0]);
        }
        catch (RequestException e) {
            e.printStackTrace();
            logger.error("No permission!!!", new Object[0]);
        }
        finally {
            data.recycle();
            reply.recycle();
        }
        return false;
    }

    public Context getMasterControlContext() {
        return this.mContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClientLogin(String packageName) {
        int pid = 0;
        pid = this.getPidByAppName(packageName);
        if (pid == 0) {
            return false;
        }
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeString(packageName);
            data.writeInt(pid);
            this.getServiceBinder().transact(6, data, reply, 0);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        catch (RemoteException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        catch (RequestException e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    private int getPidByAppName(String pkgName) {
        int pid = 0;
        ActivityManager am = (ActivityManager)this.mContext.getSystemService("activity");
        List apps = am.getRunningAppProcesses();
        if (apps != null) {
            for (ActivityManager.RunningAppProcessInfo appInfo : apps) {
                if (!appInfo.processName.equals(pkgName)) continue;
                pid = appInfo.pid;
                break;
            }
        }
        return pid;
    }

    public synchronized boolean login(Context ctx) throws ServiceOccupiedException, ReloginException, UnsupportMultiProcess, RequestException {
        if (ctx == null) {
            logger.warn("---------- login | client Context is null! ----------", new Object[0]);
            return false;
        }
        Context appContext = ctx.getApplicationContext();
        defaultAppName = appContext.getPackageName();
        return this.login(ctx, defaultAppName);
    }

    public synchronized boolean login(Context ctx, String packageName) throws ServiceOccupiedException, ReloginException, UnsupportMultiProcess, RequestException {
        if (ctx == null || TextUtils.isEmpty((CharSequence)packageName)) {
            logger.warn("---------- login | client Context is null or packageName is empty! ----------", new Object[0]);
            return false;
        }
        this.mContext = ctx;
        ClientInfo client = ClientManager.instance().newClient(packageName);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeStrongBinder((IBinder)client.getAppBinder());
            data.writeString(client.getPackageName());
            this.getServiceBinder().transact(2, data, reply, 0);
            int errorCode = reply.readInt();
            switch (errorCode) {
                case 0: {
                    break;
                }
                case 1: {
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    throw new UnsupportMultiProcess();
                }
                case 3: {
                    throw new ServiceOccupiedException();
                }
                default: {
                    throw new RequestException("login error: " + errorCode);
                }
            }
            client.setSupportIpcInvoke(reply.readInt() == 1);
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
        client.setLogin(true);
        logger.debug("---------- login | client [" + client.getPackageName() + "] login success ----------", new Object[0]);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean logout(String packageName) {
        ClientInfo client = ClientManager.instance().getClient(packageName);
        if (client == null) {
            logger.error("### logout | client [" + packageName + "] invalid, logout failed! ###", new Object[0]);
            return false;
        }
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeString(client.getPackageName());
            this.getServiceBinder().transact(3, data, reply, 0);
            ClientManager.instance().removeClient(client.getPackageName());
            logger.debug("---------- logout | client [" + client.getPackageName() + "] logout success ----------", new Object[0]);
            boolean bl = true;
            return bl;
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
        logger.warn("---------- logout | client [" + client.getPackageName() + "] logout fail ----------", new Object[0]);
        return false;
    }

    public synchronized boolean logout() {
        return this.logout(defaultAppName);
    }

    public synchronized boolean login(Context ctx, String[] useDevType) throws ServiceOccupiedException, ReloginException, UnsupportMultiProcess, RequestException {
        if (ctx == null) {
            return false;
        }
        return this.login(ctx, ctx.getApplicationContext().getPackageName(), useDevType);
    }

    public synchronized boolean login(Context ctx, String packageName, String[] useDevType) throws ServiceOccupiedException, ReloginException, UnsupportMultiProcess, RequestException {
        if (ctx == null || TextUtils.isEmpty((CharSequence)packageName)) {
            logger.warn("---------- login | client Context is null or packageName is empty! ----------", new Object[0]);
            return false;
        }
        this.mContext = ctx;
        ClientInfo client = ClientManager.instance().newClient(packageName);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeStrongBinder((IBinder)client.getAppBinder());
            data.writeString(packageName);
            if (useDevType != null) {
                data.writeInt(useDevType.length);
                for (int i = 0; i < useDevType.length; ++i) {
                    data.writeString(useDevType[i]);
                }
            }
            this.getServiceBinder().transact(2, data, reply, 0);
            int errorCode = reply.readInt();
            switch (errorCode) {
                case 0: {
                    break;
                }
                case 1: {
                    boolean bl = true;
                    return bl;
                }
                case 2: {
                    throw new UnsupportMultiProcess();
                }
                case 3: {
                    throw new ServiceOccupiedException();
                }
                default: {
                    throw new RequestException("login error: " + errorCode);
                }
            }
            client.setSupportIpcInvoke(reply.readInt() == 1);
        }
        catch (RemoteException e) {
            throw new RequestException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
        client.setLogin(true);
        logger.debug("---------- login | client [" + client.getPackageName() + "] login success ----------", new Object[0]);
        return true;
    }

    public void installListener(RemoteListener listener) {
        this.installListener(defaultAppName, listener);
    }

    public void installListener(String packageName, RemoteListener listener) {
        ClientManager.instance().installListener(packageName, listener);
    }

    public void uninstallListener(RemoteListener listener) {
        this.uninstallListener(defaultAppName, listener);
    }

    public void uninstallListener(String packageName, RemoteListener listener) {
        ClientManager.instance().uninstallListener(packageName, listener);
    }

    public void uninstallListener(int eventId) {
        this.uninstallListeners(defaultAppName, eventId);
    }

    public void uninstallListeners(int eventId) {
        this.uninstallListeners(defaultAppName, eventId);
    }

    public void uninstallListeners(String packageName, int eventId) {
        ClientManager.instance().uninstallListeners(packageName, eventId);
    }

    public void uninstallListener(String packageName, int eventId) {
        ClientManager.instance().uninstallListeners(packageName, eventId);
    }

    public void request(int code, Parcel data, Parcel reply, RemoteListener listener) throws RequestException {
        this.request(defaultAppName, code, data, reply, listener);
    }

    public void request(String packageName, int code, Parcel data, Parcel reply, RemoteListener listener) throws RequestException {
        if (!ClientManager.instance().isLogin(packageName)) {
            throw new RequestException("client:" + packageName + " unlogin!");
        }
        ClientInfo client = ClientManager.instance().getClient(packageName);
        logger.debug("## request | appName: " + client.getPackageName() + ", REQ: " + RequestCode.getDescription(code), new Object[0]);
        boolean isExtendServiceRequest = (Integer.MIN_VALUE & code) != 0;
        boolean needTransferBinder = false;
        if (isExtendServiceRequest) {
            needTransferBinder = (0x40000000 & code) != 0;
            code &= 0x3FFFFFFF;
        }
        Parcel trueData = Parcel.obtain();
        try {
            IBinder requestBinder = isExtendServiceRequest ? this.getExtendServiceBinder() : this.createOrOpenBinder();
            boolean ipcInvokeDirectly = client.isSupportIpcInvoke() && client.isIPCInvokeEnabled();
            logger.debug("## request | ipcInvokeDirectly: " + ipcInvokeDirectly, new Object[0]);
            if (!ipcInvokeDirectly) {
                trueData.writeString(client.getPackageName());
                trueData.writeInt(code);
                if (needTransferBinder) {
                    trueData.writeStrongBinder((IBinder)client.getAppBinder());
                }
            } else {
                trueData.writeInt(code);
            }
            if (data != null) {
                trueData.appendFrom(data, 0, data.dataSize());
            }
            requestBinder.transact(4, trueData, reply, 0);
            if (listener != null && reply != null) {
                Parcel trueReply = Parcel.obtain();
                trueReply.appendFrom(reply, 0, reply.dataSize());
                trueReply.setDataPosition(0);
                listener.notifyData(trueReply);
            }
        }
        catch (SecurityException e) {
            throw new RequestException("no permission!");
        }
        catch (RemoteException e) {
            logger.error("master controller service down !", new Object[0]);
            if (!isExtendServiceRequest) {
                this.closeBinder();
            }
            throw new RequestException();
        }
        finally {
            if (trueData != null) {
                trueData.recycle();
            }
        }
    }

    public void setTaskID(int taskid) throws RequestException {
        this.setTaskID(defaultAppName, taskid);
    }

    public void setTaskID(Activity a) throws RequestException {
        this.setTaskID(a.getPackageName(), a.getTaskId());
    }

    public void setTaskID(String clientPkgName, Activity a) throws RequestException {
        this.setTaskID(a.getPackageName(), a.getTaskId());
    }

    public void setTaskID(String packageName, int taskId) throws RequestException {
        logger.debug("## setTaskID | packageName: " + packageName + ", taskId: " + taskId, new Object[0]);
        ClientInfo client = ClientManager.instance().getClient(packageName);
        if (client == null) {
            throw new RequestException("client:" + packageName + " unlogin!!");
        }
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            IBinder requestBinder = this.createOrOpenBinder();
            data.writeString(client.getPackageName());
            data.writeInt(taskId);
            requestBinder.transact(5, data, reply, 0);
        }
        catch (SecurityException e) {
            throw new RequestException("no permission !");
        }
        catch (RemoteException e) {
            logger.error("master controller service down !", new Object[0]);
            this.closeBinder();
            throw new RequestException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public void runOnIPC(String packageName, Runnable runnable) throws RequestException {
        logger.debug("## runOnIPC | packageName: " + packageName, new Object[0]);
        ClientInfo client = ClientManager.instance().getClient(packageName);
        if (client == null || !client.isSupportIpcInvoke()) {
            throw new RequestException("unsupport running on IPC");
        }
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            RunnableBinder runBinder = new RunnableBinder(client, runnable);
            IBinder requestBinder = this.createOrOpenBinder();
            data.writeString(client.getPackageName());
            data.writeStrongBinder((IBinder)runBinder);
            requestBinder.transact(8, data, reply, 0);
        }
        catch (SecurityException e) {
            throw new RequestException("no permission !");
        }
        catch (RemoteException e) {
            logger.error("master controller service down !", new Object[0]);
            this.closeBinder();
            throw new RequestException();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public void runOnIPC(Runnable runnable) throws RequestException {
        this.runOnIPC(defaultAppName, runnable);
    }

    synchronized void closeBinder() {
        this.mServiceBinder = null;
    }

    synchronized IBinder createOrOpenBinder() throws RemoteException, RequestException {
        if (this.mServiceBinder == null || !this.mServiceBinder.isBinderAlive()) {
            this.mServiceBinder = this.getServiceBinder();
            this.mServiceBinder.linkToDeath(this.mServiceDeathRecipient, 0);
        }
        return this.mServiceBinder;
    }

    public void request(int code) throws RequestException {
        this.request(code, null, null, null);
    }

    public void request(String packageName, int code) throws RequestException {
        this.request(packageName, code, null, null, null);
    }

    public void request(int code, Parcel data, Parcel reply) throws RequestException {
        this.request(code, data, reply, null);
    }

    public void request(String packageName, int code, Parcel data, Parcel reply) throws RequestException {
        this.request(packageName, code, data, reply, null);
    }

    public void request(int code, Parcel data) throws RequestException {
        this.request(code, data, null, null);
    }

    public void request(String packageName, int code, Parcel data) throws RequestException {
        this.request(packageName, code, data, null, null);
    }

    public void request(String packageName, int code, Parcel data, RemoteListener listener) throws RequestException {
        this.request(packageName, code, data, null, listener);
    }

    public void requestCallback(String packageName, int code, Parcel data, RemoteListener listener) throws RequestException {
        if (!ClientManager.instance().isLogin(packageName)) {
            throw new RequestException("client:" + packageName + " unlogin!");
        }
        ClientInfo client = ClientManager.instance().getClient(packageName);
        try {
            this.installListener(client.getPackageName(), listener);
            this.request(client.getPackageName(), code, data, null, listener);
        }
        catch (RequestException e) {
            this.uninstallListener(client.getPackageName(), listener);
            throw e;
        }
    }
}

