/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.service;

import android.text.TextUtils;
import com.landicorp.android.eptapi.listener.EventCode;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.ClientInfo;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ObserverBinder;
import java.util.HashMap;
import java.util.Map;

public class ClientManager {
    static final Logger logger = Logger.getLogger(ClientManager.class);
    private static final ClientManager instance = new ClientManager();
    private Map<String, ClientInfo> clientList = new HashMap<String, ClientInfo>();

    private ClientManager() {
    }

    public static ClientManager instance() {
        return instance;
    }

    public boolean isLogin(String pkgName) {
        ClientInfo client = this.getClient(pkgName);
        return client == null ? false : client.isLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo newClient(String pkgName) {
        Map<String, ClientInfo> map = this.clientList;
        synchronized (map) {
            if (this.clientList.containsKey(pkgName)) {
                logger.warn("newClient | appName: " + pkgName + " already exists!", new Object[0]);
                return this.clientList.get(pkgName);
            }
            ObserverBinder appBinder = new ObserverBinder();
            ClientInfo client = new ClientInfo(pkgName, appBinder);
            this.clientList.put(pkgName, client);
            logger.debug("newClient | appName: " + pkgName + ", appBinder: " + (Object)((Object)appBinder), new Object[0]);
            return client;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClient(String pkgName) {
        Map<String, ClientInfo> map = this.clientList;
        synchronized (map) {
            if (!this.clientList.containsKey(pkgName)) {
                logger.warn("removeClient | appName: " + pkgName + " not exists!", new Object[0]);
                return;
            }
            ClientInfo client = this.clientList.remove(pkgName);
            logger.debug("removeClient | appName: " + pkgName, new Object[0]);
            client.quitApp();
        }
    }

    public void logout(String pkgName) {
        ClientInfo client = this.getClient(pkgName);
        if (client == null || !client.isLogin()) {
            logger.warn("logout | appName: " + pkgName + " is not login!", new Object[0]);
            return;
        }
        client.quitApp();
        logger.debug("logout | appName: " + pkgName, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetClients() {
        Map<String, ClientInfo> map = this.clientList;
        synchronized (map) {
            for (String pkgName : this.clientList.keySet()) {
                ClientInfo client = this.clientList.get(pkgName);
                if (client == null) continue;
                client.getAppBinder().notifySerivceCrash();
                client.quitApp();
                logger.debug("resetClients | appName: " + client.getPackageName(), new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClientInfo getClient(String pkgName) {
        Map<String, ClientInfo> map = this.clientList;
        synchronized (map) {
            String appName = ClientManager.convertAppNameIfNeeded(pkgName);
            if (!this.clientList.containsKey(appName)) {
                logger.warn("getClient | appName: " + appName + " not found!", new Object[0]);
                return null;
            }
            return this.clientList.get(appName);
        }
    }

    public void installListener(String pkgName, RemoteListener listener) {
        ClientInfo client = this.getClient(pkgName);
        if (client != null) {
            ObserverBinder appBinder = client.getAppBinder();
            if (appBinder != null) {
                appBinder.installListener(listener);
                logger.debug("installListener | appName: " + pkgName, new Object[0]);
            }
        } else {
            logger.warn("installListener | appName: " + pkgName + " not found!", new Object[0]);
        }
    }

    public void uninstallListener(String pkgName, RemoteListener listener) {
        ClientInfo client = this.getClient(pkgName);
        if (client != null) {
            ObserverBinder appBinder = client.getAppBinder();
            if (appBinder != null) {
                appBinder.uninstallListener(listener);
                logger.debug("uninstallListener | appName: " + pkgName, new Object[0]);
            }
        } else {
            logger.warn("uninstallListener | appName: " + pkgName + " not found!", new Object[0]);
        }
    }

    public void uninstallListeners(String pkgName, int eventId) {
        ClientInfo client = this.getClient(pkgName);
        if (client != null) {
            ObserverBinder appBinder = client.getAppBinder();
            if (appBinder != null) {
                appBinder.uninstallListeners(eventId);
                logger.debug("uninstallListeners | appName: " + pkgName + ", eventId: " + EventCode.getDescription(eventId), new Object[0]);
            }
        } else {
            logger.warn("uninstallListeners | appName: " + pkgName + ", eventId: " + EventCode.getDescription(eventId) + " not found!", new Object[0]);
        }
    }

    public static String convertAppNameIfNeeded(String packageName) {
        if (ClientManager.isNativeAppName(packageName)) {
            return MasterController.getInstance().getDefaultAppName();
        }
        return packageName;
    }

    private static boolean isNativeAppName(String packageName) {
        return TextUtils.isEmpty((CharSequence)packageName) || "__default_native_app_name__".equalsIgnoreCase(packageName);
    }
}

