/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.emv.process;

import android.content.Context;
import android.content.pm.PackageManager;
import android.os.Parcel;
import android.text.TextUtils;
import com.landicorp.android.eptapi.card.CpuCardDriver;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.card.RFDriver;
import com.landicorp.android.eptapi.emv.EmvRequestExecutor;
import com.landicorp.android.eptapi.emv.data.EMVConfig;
import com.landicorp.android.eptapi.emv.process.data.BaseParameter;
import com.landicorp.android.eptapi.emv.process.data.CAPKey;
import com.landicorp.android.eptapi.emv.process.data.CVMData;
import com.landicorp.android.eptapi.emv.process.data.CandidateAIDInfo;
import com.landicorp.android.eptapi.emv.process.data.DisplayMessage;
import com.landicorp.android.eptapi.emv.process.data.ECCLog;
import com.landicorp.android.eptapi.emv.process.data.FinalSelectData;
import com.landicorp.android.eptapi.emv.process.data.GroupParameter;
import com.landicorp.android.eptapi.emv.process.data.ICCLog;
import com.landicorp.android.eptapi.emv.process.data.PBOCParameter;
import com.landicorp.android.eptapi.emv.process.data.RecCert;
import com.landicorp.android.eptapi.emv.process.data.RecordData;
import com.landicorp.android.eptapi.emv.process.data.SMCAPKey;
import com.landicorp.android.eptapi.emv.process.data.StartEmvParameter;
import com.landicorp.android.eptapi.emv.process.data.TransactionData;
import com.landicorp.android.eptapi.emv.process.data.VISAParameter;
import com.landicorp.android.eptapi.emv.process.data.VerifyOfflinePinResult;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BinaryData;
import com.landicorp.android.eptapi.utils.BooleanBuffer;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import com.landicorp.android.eptapi.utils.TLV;
import com.landicorp.android.eptapi.utils.TLVList;
import java.util.List;

public class EMVL2Process {
    static final Logger logger = Logger.getLogger(EMVL2Process.class);
    protected static final int EMV_SIGNAL_ACT = 1;
    protected static final int EMV_SIGNAL_NEXT = 2;
    protected static final int EMV_SINGAL_ACT_GPO = 17;
    protected static final int EMV_SIGNAL_STOP = 240;
    protected static final int EMV_SIGNAL_CLEAN = 192;
    public static final int EMV_KERNELID_EMV = 0;
    public static final int EMV_KERNELID_EMVCTLess = 1;
    public static final int EMV_KERNELID_MASTER = 2;
    public static final int EMV_KERNELID_VISA = 3;
    public static final int EMV_KERNELID_AMEX = 4;
    public static final int EMV_KERNELID_JCB = 5;
    public static final int EMV_KERNELID_DISCOVER = 6;
    public static final int EMV_KERNELID_PBOC = 7;
    public static final int EMV_KERNELID_NSICC = 218;
    public static final int EMV_KERNELID_DEFINE = 222;
    public static final int EMV_CONFIG_C0 = 192;
    public static final int EMV_CONFIG_C1 = 193;
    public static final int EMV_CONFIG_C2 = 194;
    public static final int EMV_CONFIG_C3 = 195;
    public static final int EMV_CONFIG_C4 = 196;
    public static final int EMV_CONFIG_C5 = 197;
    public static final int EMV_CONFIG_C6 = 198;
    public static final int EMV_FLOWTYPE_EMV = 1;
    public static final int EMV_FLOWTYPE_ECASH = 3;
    public static final int EMV_FLOWTYPE_QPBOC = 17;
    public static final int EMV_FLOWTYPE_PBOC_CTLESS = 18;
    public static final int EMV_FLOWTYPE_MSD = 19;
    public static final int EMV_FLOWTYPE_MSD_LEGACY = 20;
    public static final int EMV_FLOWTYPE_QVSDC = 33;
    public static final int EMV_FLOWTYPE_WAVE2 = 34;
    public static final int EMV_FLOWTYPE_M_CHIP = 49;
    public static final int EMV_FLOWTYPE_M_STRIPE = 50;
    public static final int EMV_FLOWTYPE_J_EMV = 51;
    public static final int EMV_FLOWTYPE_J_MAG = 52;
    public static final int EMV_FLOWTYPE_J_LEGACY = 53;
    public static final int EMV_FLOWTYPE_A_XP2_MS = 65;
    public static final int EMV_FLOWTYPE_A_XP2_EMV = 66;
    public static final int EMV_FLOWTYPE_A_XPM_MS = 67;
    public static final int EMV_FLOWTYPE_A_XPM_EMV = 68;
    public static final int EMV_FLOWTYPE_D_DPAS_MS = 81;
    public static final int EMV_FLOWTYPE_D_DPAS_EMV = 82;
    public static final int EMV_FLOWTYPE_D_ZIP = 83;
    public static final int EMV_SERVETYPE_GOOD = 0;
    public static final int EMV_SERVETYPE_SERVICE = 0;
    public static final int EMV_SERVETYPE_CASH = 1;
    public static final int EMV_SERVETYPE_CASHBACK = 9;
    public static final int EMV_SERVETYPE_REFUND = 32;
    public static final int EMV_CVMFLAG_NOCVM = 0;
    public static final int EMV_CVMFLAG_OFFLINEPIN = 1;
    public static final int EMV_CVMFLAG_ONLINEPIN = 2;
    public static final int EMV_CVMFLAG_SIGNATURE = 3;
    public static final int EMV_CVMFLAG_OLPIN_SIGN = 4;
    public static final int EMV_CVMFLAG_CDV = 5;
    public static final int EMV_CVMFLAG_CCV = 6;
    public static final int EMV_CVMFLAG_CERTIFICATE = 17;
    public static final int EMV_CVMFLAG_ECASHPIN = 33;
    public static final int EMV_ACTION_AAC = 0;
    public static final int EMV_ACTION_TC = 1;
    public static final int EMV_ACTION_ARQC = 2;
    public static final int EMV_FLAG_ADD = 1;
    public static final int EMV_FLAG_DELETE = 2;
    public static final int EMV_FLAG_CLEAR = 3;
    public static final int EMV_LEN_MAX_AID = 16;
    public static final int EMV_MSGID_AMOUNT = 31;
    public static final int EMV_MSGID_BALANCE = 2;
    public static final int EMV_MSGID_PROCESSING = 3;
    public static final int EMV_MSGID_PROCESS_ERROR = 4;
    public static final int EMV_MSGID_INSERT_CARD = 29;
    public static final int EMV_MSGID_SHOW_CARD = 6;
    public static final int EMV_MSGID_APPSELECT = 7;
    public static final int EMV_MSGID_APPSEL_AGAIN = 8;
    public static final int EMV_MSGID_READCARD_OK = 23;
    public static final int EMV_MSGID_TRY_AGAIN = 33;
    public static final int EMV_MSGID_APPROVED = 3;
    public static final int EMV_MSGID_APPROVED_SIGN = 26;
    public static final int EMV_MSGID_DECLINED = 7;
    public static final int EMV_MSGID_OTHER_CARD = 28;
    public static final int EMV_MSGID_SEE_PHONE = 32;
    public static final int EMV_MSGID_NOCARD = 16;
    public static final int EMV_MSGID_CARD_READ_OK = 23;
    public static final int EMV_MSGID_AUTH_WAIT = 27;
    public static final int EMV_MSGID_CLEAR_DISPLAY = 30;
    public static final int EMV_MSGID_PCII = 241;
    public static final int EMV_L1_ERR_TIMEOUT = 1;
    public static final int EMV_L1_ERR_TRANSMISSION = 2;
    public static final int EMV_L1_ERR_PROTOCOL = 3;
    public static final int EMV_L2_ERR_ICC_DATA_MISS = 1;
    public static final int EMV_L2_ERR_CAM_FAILED = 2;
    public static final int EMV_L2_ERR_ICC_STATUS = 3;
    public static final int EMV_L2_ERR_PARSING = 4;
    public static final int EMV_L2_ERR_MAX_EXCEEDED = 5;
    public static final int EMV_L2_ERR_ICC_DATA = 6;
    public static final int EMV_L2_ERR_MAG_NOT_SUP = 7;
    public static final int EMV_L2_ERR_NO_PPSE = 8;
    public static final int EMV_L2_ERR_PPSE_FAULT = 9;
    public static final int EMV_L2_ERR_NO_CAND_AID = 10;
    public static final int EMV_L2_ERR_TERM_DATA = 15;
    public static final int EMV_L3_ERR_TIMEOUT = 1;
    public static final int EMV_L3_ERR_STOP = 2;
    public static final int EMV_L3_ERR_AMOOUNT = 3;
    public static final int EMV_RESULT_NORMAL = 0;
    public static final int EMV_RESULT_BUSY = 60929;
    public static final int EMV_RESULT_NOAPP = 60930;
    public static final int EMV_RESULT_NOPUBKEY = 60931;
    public static final int EMV_RESULT_EXPIRY = 60932;
    public static final int EMV_RESULT_FLASHCARD = 60934;
    public static final int EMV_RESULT_STOP = 60935;
    public static final int EMV_RESULT_REPOWERICC = 60936;
    public static final int EMV_RESULT_REFUSESERVICE = 60937;
    public static final int EMV_RESULT_CARDLOCK = 60938;
    public static final int EMV_RESULT_APPLOCK = 60939;
    public static final int EMV_RESULT_EXCEED_CTLMT = 60940;
    public static final int EMV_RESULT_APDU_ERROR = 60941;
    public static final int EMV_RESULT_APDU_STATUS_ERROR = 60942;
    public static final int EMV_RESULT_ALL_FLASH_CARD = 60943;
    public static final int EMV_INS_SET_TORN = 161;
    public static final int EMV_INS_DEL_TORN = 209;
    public static final int EMV_INS_DISPLAY = 162;
    public static final int EMV_INS_TLVDATA = 163;
    public static final int EMV_INS_CLOSERF = 164;
    public static final int EMV_INS_DBLOG = 219;
    public static final int EMV_INS_GET_TORN = 177;
    public static final int EMV_INS_APPSELECT_DATA = 193;
    public static final int EMV_INS_SET_FAIL_WATER = 165;
    public static final int EMV_INS_DEL_FAIL_WATER = 166;
    public static final int EMV_INS_SEND_DISC = 225;
    public static final int EMV_FLAG_NORMAL = 0;
    public static final int EMV_FLAG_SHOW_CARD_AGAIN = 1;
    public static final int EMV_FLAG_ISS_SCRIPT_UPDATE = 2;
    public static final int EMV_FLAG_EXECUTE_CDCVM = 3;
    public static final int DOL_TYPE_DDOL = 1;
    public static final int DOL_TYPE_TDOL = 2;
    public static final int DOL_TYPE_UDOL = 3;
    public static final int DOL_ACTION_SET = 1;
    public static final int DOL_ACTION_GET = 2;
    public static final int OPTION_ENABLE_BEEPER = 17;
    public static final int OPTION_BEEPER_FREQUENCY = 18;
    private static final int REQ_INITIAL = 1;
    private static final int REQ_SETPARAMBASE = 2;
    private static final int REQ_SETPARAMPBOC = 3;
    private static final int REQ_SETPARAMVISA = 4;
    private static final int REQ_MANAGEAID = 5;
    private static final int REQ_UPDATECAINDEXLIST = 6;
    private static final int REQ_SETCAPUBKEY = 7;
    private static final int REQ_SETCAPUBKEY_SM = 8;
    private static final int REQ_MANAGERECCERT = 9;
    private static final int REQ_MANAGEDOL = 10;
    private static final int REQ_SIGNALIN = 11;
    private static final int REQ_GETTRANSDATA = 12;
    private static final int REQ_GETBALANCE = 13;
    private static final int REQ_GETDATAAPDU = 14;
    private static final int REQ_GETICCLOG = 15;
    private static final int REQ_GETECCLOG = 16;
    private static final int REQ_KERNELVERSION = 17;
    private static final int REQ_SETTLV = 18;
    private static final int REQ_SETTLVLIST = 19;
    private static final int REQ_GETTLV = 20;
    private static final int REQ_GETLOG = 21;
    private static final int REQ_SETCARDDRIVER = 22;
    private static final int REQ_SETVERIFYOFFLINEPINRESULT = 23;
    private static final int REQ_SIGNALINTLV = 24;
    private static final int REQ_CLEARCARDDRIVER = 25;
    private static final int REQ_SWITCHDEBUG = 26;
    private static final int REQ_TRANSFER = 101;
    private static final int REQ_SETEMVOPTIMIZATION = 102;
    private static final int REQ_MANAGECAPUBKEY = 103;
    private static final int REQ_MANAGESMCAPUBKEY = 104;
    private static final int REQ_PREPROCESS = 105;
    private static final int REQ_MANAGEAIDEX = 106;
    private static final int REQ_GETCHECKSUM = 107;
    private static final int REQ_SETEMVOPTION = 108;
    private static final int CARD_TYPE_INSERT = 0;
    private static final int CARD_TYPE_RF = 1;
    @Deprecated
    public static final int LOG_LEVEL_NORMAL = 1;
    public static final int LOG_LEVEL_AFTERTRANS = 1;
    @Deprecated
    public static final int LOG_LEVEL_DETAIL = 2;
    public static final int LOG_LEVEL_REALTIME = 2;
    public static final int LOG_LEVEL_CLOSE = 3;
    private static final int LOG_LEVEL_DEFAULT = 1;
    private static final int ERROR_NONE = 0;
    private static final int ERROR_FAIL = 1;
    private static int logLevel = 1;
    private CpuCardDriver<?> driver;
    private EMVL2ProcessHandler handler;
    private ProcessListener listener;
    private int signinReq = -1;
    private String packageName;
    private Context context;

    public EMVL2Process(Context context, CpuCardDriver<?> driver, EMVL2ProcessHandler handler) {
        this(context, driver, handler, null);
    }

    public EMVL2Process(Context context, CpuCardDriver<?> driver, EMVL2ProcessHandler handler, PausableHandler pausableHandler) {
        this(context, null, driver, handler, pausableHandler);
    }

    public EMVL2Process(Context context, String packageName, CpuCardDriver<?> driver, EMVL2ProcessHandler handler) {
        this(context, packageName, driver, handler, null);
    }

    public EMVL2Process(Context context, String packageName, CpuCardDriver<?> driver, EMVL2ProcessHandler handler, PausableHandler pausableHandler) {
        this(context, packageName, driver, handler, pausableHandler, null);
    }

    public EMVL2Process(Context context, String packageName, CpuCardDriver<?> driver, EMVL2ProcessHandler handler, PausableHandler pausableHandler, EMVConfig emvConfig) {
        Precondition.checkNotNull(handler);
        this.context = context;
        this.packageName = this.getPackageName(context, packageName);
        this.driver = driver;
        this.handler = handler;
        this.listener = pausableHandler == null ? new ProcessListener() : new ProcessListener(pausableHandler);
        this.listener.setPackageName(this.packageName);
        MasterController.getInstance().uninstallListeners(packageName, this.listener.getEventId());
        MasterController.getInstance().installListener(this.packageName, this.listener);
        this.initial(emvConfig);
    }

    private String getPackageName(Context context) {
        if (context != null) {
            return context.getPackageName();
        }
        return MasterController.getInstance().getDefaultAppName();
    }

    private String getPackageName(Context context, String packageName) {
        if (!TextUtils.isEmpty((CharSequence)packageName)) {
            return packageName;
        }
        return this.getPackageName(context);
    }

    private int sendSignal(int reqCode, final int action, final byte[] param) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(action);
                if (action == 1) {
                    int cardType = -1;
                    String deviceName = "";
                    if (EMVL2Process.this.driver instanceof InsertDriver) {
                        cardType = 0;
                        deviceName = ((InsertDriver)((Object)EMVL2Process.this.driver)).getDeviceName();
                    } else if (EMVL2Process.this.driver instanceof RFDriver) {
                        cardType = 1;
                        deviceName = ((RFDriver)((Object)EMVL2Process.this.driver)).getDeviceName();
                    }
                    data.writeInt(cardType);
                    data.writeByteArray(StringUtil.getGBK(deviceName));
                }
                if (param != null) {
                    data.writeByteArray(param);
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(reqCode);
    }

    public void switchDebug(final int level) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(level);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        executor.execute(26);
    }

    public static void setLogLevel(int level) {
        logLevel = level;
    }

    public void setDriver(CpuCardDriver<?> driver) {
        this.driver = driver;
    }

    public int clearDriver() {
        int ret = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        }.execute(25);
        if (ret == 0) {
            logger.debug("# clearDriver | clear driver!", new Object[0]);
            this.driver = null;
        }
        return ret;
    }

    private int initial(final EMVConfig emvConfig) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(logLevel);
                if (emvConfig != null) {
                    data.writeByteArray(emvConfig.toBinary());
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    EMVL2Process.this.signinReq = resp.readInt();
                }
            }
        };
        return executor.execute(1);
    }

    public int start(StartEmvParameter parameter) {
        MasterController.getInstance().uninstallListeners(this.packageName, this.listener.getEventId());
        MasterController.getInstance().installListener(this.packageName, this.listener);
        this.signinReq = 11;
        return this.sendSignal(11, 1, parameter.toBinary());
    }

    public int start(TLVList parameter) {
        MasterController.getInstance().uninstallListeners(this.packageName, this.listener.getEventId());
        MasterController.getInstance().installListener(this.packageName, this.listener);
        this.signinReq = 24;
        return this.sendSignal(24, 1, parameter.toBinary());
    }

    private boolean checkPackageName(Context context, String packageName) {
        if (context == null) {
            return false;
        }
        if (packageName == null || "".equals(packageName)) {
            return false;
        }
        try {
            context.getPackageManager().getApplicationInfo(packageName, 8192);
            return true;
        }
        catch (PackageManager.NameNotFoundException e) {
            return false;
        }
    }

    public int transfer(final String transferToApp) throws PackageManager.NameNotFoundException {
        Precondition.checkNotEmpty(transferToApp);
        if (!this.checkPackageName(this.context, transferToApp)) {
            throw new PackageManager.NameNotFoundException("Not found application:" + transferToApp);
        }
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(transferToApp));
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        int result = executor.execute(101);
        if (result == 0) {
            MasterController.getInstance().uninstallListener(this.packageName, this.listener);
        }
        return result;
    }

    public int abort() {
        return this.sendSignal(24, 240, null);
    }

    public int next(final CpuCardDriver<?> driver) {
        this.driver = driver;
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                int cardType = 0;
                String deviceName = null;
                if (driver instanceof InsertDriver) {
                    cardType = 0;
                    deviceName = ((InsertDriver)((Object)driver)).getDeviceName();
                } else if (driver instanceof RFDriver) {
                    cardType = 1;
                    deviceName = ((RFDriver)((Object)driver)).getDeviceName();
                } else {
                    throw new IllegalArgumentException("driver cannot regcognized!");
                }
                data.writeInt(cardType);
                data.writeByteArray(StringUtil.getGBK(deviceName));
                if (EMVL2Process.this.signinReq != 11) {
                    data.writeInt(1);
                } else {
                    data.writeInt(0);
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(22);
    }

    public int next(StepResult result) {
        return this.next(result == null ? null : result.toBinary());
    }

    @Deprecated
    public int next(byte[] result) {
        if (this.signinReq != 11) {
            throw new IllegalAccessError("doesn't matchPackageName the start mode!");
        }
        if (result == null) {
            return this.sendSignal(11, 2, null);
        }
        return this.sendSignal(11, 2, result);
    }

    public int nextWithTLV(TLVList result) {
        return this.nextWithTLV(result == null ? null : result.toBinary());
    }

    public int nextWithTLV(byte[] result) {
        if (this.signinReq != 24) {
            throw new IllegalAccessError("doesn't matchPackageName the start mode!");
        }
        if (result == null) {
            return this.sendSignal(24, 2, null);
        }
        return this.sendSignal(24, 2, result);
    }

    void setVerifyOfflinePinResult(final VerifyOfflinePinResult result) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                result.writeToParcel(data);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        executor.execute(23);
    }

    @Deprecated
    public int setBaseParameter(final BaseParameter parameter) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(parameter.toBinary());
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(2);
    }

    @Deprecated
    public int setPBOCParameter(final PBOCParameter parameter) {
        RequestExecutor executer = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(parameter.toBinary());
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executer.execute(3);
    }

    @Deprecated
    public int setVISAParameter(final VISAParameter parameter) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(parameter.toBinary());
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(4);
    }

    public int manageAID(final int action, final byte[] aid, final int partSlt, final int kernelId) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(aid);
                data.writeInt(partSlt);
                data.writeInt(kernelId);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(5);
    }

    public int addAID(byte[] aid, boolean isPartFragment) {
        return this.manageAID(1, aid, isPartFragment ? 1 : 0, 0);
    }

    public int addAID(byte[] aid, boolean isPartFragment, int kernelId) {
        return this.manageAID(1, aid, isPartFragment ? 1 : 0, kernelId);
    }

    public int removeAID(byte[] aid) {
        return this.manageAID(2, aid, 0, 0);
    }

    public int clearAID() {
        return this.manageAID(3, null, 0, 0);
    }

    public int updateCAIndexList(final byte[] rid, final int[] indexs) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(rid);
                if (indexs != null) {
                    byte[] bytesIndexs = new byte[indexs.length];
                    for (int i = 0; i < bytesIndexs.length; ++i) {
                        bytesIndexs[i] = (byte)indexs[i];
                    }
                    data.writeByteArray(bytesIndexs);
                } else {
                    data.writeByteArray(null);
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(6);
    }

    public int setCAPubKey(final CAPKey key) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(key == null ? null : key.toBinary());
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(7);
    }

    public int setSMCAPubKey(final SMCAPKey key, final GroupParameter group) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(key == null ? null : key.toBinary());
                if (group != null) {
                    group.writeToParcel(data);
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(8);
    }

    public int manageRecCert(final int action, final RecCert cert) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(cert == null ? null : cert.toBinary());
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(9);
    }

    public int addRecCert(RecCert data) {
        return this.manageRecCert(1, data);
    }

    public int removeRecCert(RecCert data) {
        return this.manageRecCert(2, data);
    }

    public int clearRecCert() {
        return this.manageRecCert(3, null);
    }

    public int manageDOL(final int flag, final int action, final BytesBuffer dol) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(flag);
                data.writeInt(action);
                if (dol != null) {
                    data.writeByteArray(dol.getData());
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (resp.dataAvail() > 0) {
                    dol.setData(resp.createByteArray());
                }
            }
        };
        return executor.execute(10);
    }

    public int getTDOL(BytesBuffer dol) {
        return this.manageDOL(2, 2, dol);
    }

    public int setTDOL(byte[] dol) {
        BytesBuffer data = new BytesBuffer();
        data.setData(dol);
        return this.manageDOL(2, 1, data);
    }

    public int getDDOL(BytesBuffer dol) {
        return this.manageDOL(1, 2, dol);
    }

    public int setDDOL(byte[] dol) {
        BytesBuffer data = new BytesBuffer();
        data.setData(dol);
        return this.manageDOL(1, 1, data);
    }

    public int getUDOL(BytesBuffer dol) {
        return this.manageDOL(3, 2, dol);
    }

    public int setUDOL(byte[] dol) {
        BytesBuffer data = new BytesBuffer();
        data.setData(dol);
        return this.manageDOL(3, 1, data);
    }

    public int getBalance(final BytesBuffer balance) {
        Precondition.checkNotNull(balance);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (balance != null) {
                    balance.setData(resp.createByteArray());
                }
            }
        };
        return executor.execute(13);
    }

    public int getDataAPDU(final int p1, final int p2, final BytesBuffer data) {
        Precondition.checkNotNull(data);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(p1);
                request.writeInt(p2);
                request.writeByteArray(data.getData());
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (data != null) {
                    data.setData(resp.createByteArray());
                }
            }
        };
        return executor.execute(14);
    }

    public int getICCLog(final byte[] aid, final List<ICCLog> logs) {
        Precondition.checkNotNull(aid);
        Precondition.checkNotNull(logs);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(aid);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (logs != null) {
                    19.getList(resp, ICCLog.class, logs);
                }
            }
        };
        return executor.execute(15);
    }

    public int getECCLog(final byte[] aid, final List<ECCLog> logs) {
        Precondition.checkNotNull(aid);
        Precondition.checkNotNull(logs);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeByteArray(aid);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (logs != null) {
                    20.getList(resp, ECCLog.class, logs);
                }
            }
        };
        return executor.execute(16);
    }

    public int getKernelVersion(final StringBuilder version) {
        Precondition.checkNotNull(version);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (version != null) {
                    byte[] gbkVersion = resp.createByteArray();
                    version.setLength(0);
                    version.append(StringUtil.fromGBK(gbkVersion));
                }
            }
        };
        return executor.execute(17);
    }

    public String getKernelLog() {
        final StringBuilder log = new StringBuilder();
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                log.append(resp.readString());
            }
        };
        executor.execute(21);
        return log.toString();
    }

    public int getTransactionData(final TransactionData data) {
        Precondition.checkNotNull(data);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (data != null) {
                    data.fromBinary(resp.createByteArray());
                }
            }
        };
        return executor.execute(12);
    }

    public int setTLV(int kernelId, TLV tlv) {
        Precondition.checkNotNull(tlv);
        return this.setTLVInner(kernelId, BytesUtil.hexString2Bytes(tlv.getTag()), tlv.getBytesValue());
    }

    public int setTLV(int kernelId, String tag, byte[] value) {
        return this.setTLVInner(kernelId, BytesUtil.hexString2Bytes(tag), value);
    }

    public int setTLVWithGBKValue(int kernelId, String tag, String value) {
        return this.setTLVInner(kernelId, BytesUtil.hexString2Bytes(tag), StringUtil.getGBK(value));
    }

    public int setTLV(int kernelId, String tag, String value) {
        return this.setTLVInner(kernelId, BytesUtil.hexString2Bytes(tag), BytesUtil.hexString2Bytes(value));
    }

    private int setTLVInner(final int action, final byte[] tag, final byte[] value) {
        Precondition.checkNotNull(tag);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel request) {
                request.writeInt(action);
                request.writeByteArray(tag);
                request.writeByteArray(value);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(18);
    }

    public int getTLV(final String tag, final BytesBuffer value) {
        Precondition.checkNotNull(value);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(BytesUtil.hexString2Bytes(tag));
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (value != null) {
                    value.setData(resp.createByteArray());
                }
            }
        };
        return executor.execute(20);
    }

    public int setTLVList(int kernelId, TLVList tlvList) {
        Precondition.checkNotNull(tlvList);
        return this.setTLVList(kernelId, tlvList.toBinary());
    }

    public int setTLVList(int kernelId, String tlvList) {
        Precondition.checkNotNull(tlvList);
        return this.setTLVList(kernelId, BytesUtil.hexString2Bytes(tlvList));
    }

    public int setTLVList(final int kernelId, final byte[] tlvList) {
        Precondition.checkNotNull(tlvList);
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(kernelId);
                data.writeByteArray(tlvList);
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(19);
    }

    public void updateCallback() {
        if (this.listener != null) {
            MasterController.getInstance().installListener(this.packageName, this.listener);
        }
    }

    public void setEMVOptimization(final boolean optimization, final BooleanBuffer isSupported) {
        new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(optimization ? 1 : 0);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (isSupported != null) {
                    if (resp.dataAvail() == 0) {
                        isSupported.setData(false);
                    } else {
                        isSupported.setData(resp.readInt() == 1);
                    }
                }
            }
        }.execute(102);
    }

    public int manageCAPubKey(final int action, final CAPKey capKey) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(capKey == null ? null : capKey.toBinary());
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(103);
    }

    public int manageSMCAPubKey(final int action, final SMCAPKey smcapKey, final GroupParameter groupParameter) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(smcapKey == null ? null : smcapKey.toBinary());
                if (groupParameter != null) {
                    groupParameter.writeToParcel(data);
                }
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(104);
    }

    public int preProcess(final String tlvList, final BytesBuffer result) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeByteArray(tlvList == null ? null : BytesUtil.hexString2Bytes(tlvList));
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (result != null) {
                    result.setData(resp.createByteArray());
                }
            }
        };
        return executor.execute(105);
    }

    public int manageAIDEx(final int action, final String aid, final String kid, final String tlvList) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(action);
                data.writeByteArray(aid == null ? null : BytesUtil.hexString2Bytes(aid));
                data.writeByteArray(kid == null ? null : BytesUtil.hexString2Bytes(kid));
                data.writeByteArray(tlvList == null ? null : BytesUtil.hexString2Bytes(tlvList));
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(106);
    }

    public int getCheckSum(final int flag, final StringBuilder checkSum) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(flag);
            }

            @Override
            public void handleResponseData(Parcel resp) {
                if (checkSum != null) {
                    checkSum.setLength(0);
                    checkSum.append(resp.readString());
                }
            }
        };
        return executor.execute(107);
    }

    public int setEMVOption(final int key, final String value) {
        RequestExecutor executor = new RequestExecutor(this.packageName){

            @Override
            public void makeRequestData(Parcel data) {
                data.writeInt(key);
                data.writeByteArray(StringUtil.getGBK(value));
            }

            @Override
            public void handleResponseData(Parcel resp) {
            }
        };
        return executor.execute(108);
    }

    public class ProcessListener
    extends RemoteListener {
        private static final int EV_WAITCARD = 1;
        private static final int EV_APP_SELECTION = 2;
        private static final int EV_FINAL_SLT = 3;
        private static final int EV_READ_RECORD = 4;
        private static final int EV_CARD_HOLDER_VERIFY = 5;
        private static final int EV_ONLINE_PROCESS = 6;
        private static final int EV_END_PROCESS = 8;
        private static final int EV_SEND_OUT = 9;
        private static final int EV_OBTAIN = 10;
        private static final int EV_VERIFY_OFFLINE_PIN = 11;
        private static final int EV_TRANSFER = 12;

        public ProcessListener() {
            this.setRunOnIPCThread();
        }

        public ProcessListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        public int getEventId() {
            return 1538;
        }

        @Override
        protected void onListened(Parcel data) {
            int responseType = data.readInt();
            logger.debug("-------------------emv proc listen[" + this.getEventDescription(responseType) + "] ---------------", new Object[0]);
            switch (responseType) {
                case 12: {
                    logger.debug("-------------------emv proc listen EV_TRANSFER ---------------", new Object[0]);
                    if (data.dataAvail() <= 0) break;
                    EMVL2Process.this.signinReq = data.readInt();
                    logger.debug("-------------------emv proc set signinReq: " + EMVL2Process.this.signinReq + "---------------", new Object[0]);
                    break;
                }
                case 1: {
                    this.onWaitCard(data);
                    break;
                }
                case 2: {
                    this.onAppSelection(data);
                    break;
                }
                case 3: {
                    this.onFinalSelect(data);
                    break;
                }
                case 4: {
                    this.onReadRecord(data);
                    break;
                }
                case 5: {
                    this.onCardHolderVerify(data);
                    break;
                }
                case 6: {
                    this.onOnlineProcess(data);
                    break;
                }
                case 8: {
                    this.onEndProcess(data);
                    break;
                }
                case 9: {
                    this.onSendOut(data);
                    break;
                }
                case 10: {
                    this.onObtain(data);
                    break;
                }
                case 11: {
                    logger.debug("-------------------EV_VERIFY_OFFLINE_PIN ---------------" + responseType, new Object[0]);
                    this.onVerifyOfflinePin(data);
                }
            }
        }

        private String getEventDescription(int eventType) {
            switch (eventType) {
                case 1: {
                    return "EV_WAITCARD";
                }
                case 2: {
                    return "EV_APP_SELECTION";
                }
                case 3: {
                    return "EV_FINAL_SLT";
                }
                case 4: {
                    return "EV_READ_RECORD";
                }
                case 5: {
                    return "EV_CARD_HOLDER_VERIFY";
                }
                case 6: {
                    return "EV_ONLINE_PROCESS";
                }
                case 8: {
                    return "EV_END_PROCESS";
                }
                case 9: {
                    return "EV_SEND_OUT";
                }
                case 10: {
                    return "EV_OBTAIN";
                }
                case 11: {
                    return "EV_VERIFY_OFFLINE_PIN";
                }
            }
            return Integer.toHexString(eventType);
        }

        private void onEndProcess(Parcel data) {
            int result = data.readInt();
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onEndProcess(result, this.load(data, new TransactionData()));
            }
        }

        private void onOnlineProcess(Parcel data) {
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onOnlineProcess(this.load(data, new TransactionData()));
            }
        }

        private void onCardHolderVerify(Parcel data) {
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onCardHolderVerify(this.load(data, new CVMData()));
            }
        }

        private void onReadRecord(Parcel data) {
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onReadRecord(this.load(data, new RecordData()));
            }
        }

        private void onFinalSelect(Parcel data) {
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onFinalSelect(this.load(data, new FinalSelectData()));
            }
        }

        private void onAppSelection(Parcel data) {
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onAppSelection(data.readInt() != 0, RequestExecutor.getList(data, CandidateAIDInfo.class), data.createByteArray());
            }
        }

        private void onWaitCard(Parcel data) {
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onWaitCard(data.readInt());
            }
        }

        private void onSendOut(Parcel data) {
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onSendOut(data.readInt(), data.createByteArray());
            }
        }

        private void onObtain(Parcel data) {
            if (EMVL2Process.this.handler != null) {
                EMVL2Process.this.handler.onObtain(data.readInt(), data.createByteArray());
            }
        }

        private void onVerifyOfflinePin(Parcel data) {
            int flag = data.readInt();
            byte[] random = data.createByteArray();
            CAPKey key = this.load(data, new CAPKey());
            logger.debug("-------------------onVerifyOfflinePin begin ---------------", new Object[0]);
            logger.debug("## [onVerifyOfflinePin] tid: %d, thread: %s ##", Thread.currentThread().getId(), Thread.currentThread().getName());
            if (EMVL2Process.this.handler != null) {
                VerifyOfflinePinResult result = new VerifyOfflinePinResult();
                EMVL2Process.this.handler.onVerifyOfflinePin(flag, random.length == 0 ? null : random, key, result);
                logger.debug("# onVerifyOfflinePin | result: " + result.getResult() + ", sw12: " + result.getSw1Sw2(), new Object[0]);
                EMVL2Process.this.setVerifyOfflinePinResult(result);
            }
            logger.debug("-------------------onVerifyOfflinePin end ---------------", new Object[0]);
        }

        @Override
        public void onCrash() {
        }

        private <T extends BinaryData> T load(Parcel data, T b) {
            byte[] d = data.createByteArray();
            if (d.length == 0) {
                return null;
            }
            b.fromBinary(d);
            return b;
        }
    }

    abstract class RequestExecutor
    extends EmvRequestExecutor {
        public RequestExecutor() {
            super(0xFF0003);
        }

        public RequestExecutor(String packageName) {
            super(packageName, 0xFF0003);
        }

        @Override
        protected String toCodeName(int code) {
            switch (code) {
                case 1: {
                    return "REQ_INITIAL";
                }
                case 2: {
                    return "REQ_SETPARAMBASE";
                }
                case 3: {
                    return "REQ_SETPARAMPBOC";
                }
                case 4: {
                    return "REQ_SETPARAMVISA";
                }
                case 5: {
                    return "REQ_MANAGEAID";
                }
                case 6: {
                    return "REQ_UPDATECAINDEXLIST";
                }
                case 7: {
                    return "REQ_SETCAPUBKEY";
                }
                case 8: {
                    return "REQ_SETCAPUBKEY_SM";
                }
                case 9: {
                    return "REQ_MANAGERECCERT";
                }
                case 10: {
                    return "REQ_MANAGEDOL";
                }
                case 11: {
                    return "REQ_SIGNALIN";
                }
                case 12: {
                    return "REQ_GETTRANSDATA";
                }
                case 13: {
                    return "REQ_GETBALANCE";
                }
                case 14: {
                    return "REQ_GETDATAAPDU";
                }
                case 15: {
                    return "REQ_GETICCLOG";
                }
                case 16: {
                    return "REQ_GETECCLOG";
                }
                case 17: {
                    return "REQ_KERNELVERSION";
                }
                case 18: {
                    return "REQ_SETTLV";
                }
                case 19: {
                    return "REQ_SETTLVLIST";
                }
                case 20: {
                    return "REQ_GETTLV";
                }
                case 21: {
                    return "REQ_GETLOG";
                }
                case 22: {
                    return "REQ_SETCARDDRIVER";
                }
                case 23: {
                    return "REQ_SETVERIFYOFFLINEPINRESULT";
                }
                case 24: {
                    return "REQ_SIGNALINTLV";
                }
                case 25: {
                    return "REQ_CLEARCARDDRIVER";
                }
                case 26: {
                    return "REQ_SWITCHDEBUG";
                }
                case 101: {
                    return "REQ_TRANSFER";
                }
                case 102: {
                    return "REQ_SETEMVOPTIMIZATION";
                }
                case 103: {
                    return "REQ_MANAGECAPUBKEY";
                }
                case 104: {
                    return "REQ_MANAGESMCAPUBKEY";
                }
                case 105: {
                    return "REQ_PREPROCESS";
                }
                case 106: {
                    return "REQ_MANAGEAIDEX";
                }
                case 107: {
                    return "REQ_GETCHECKSUM";
                }
                case 108: {
                    return "REQ_SETEMVOPTION";
                }
            }
            return Integer.toString(code);
        }
    }

    public static interface StepResult {
        public byte[] toBinary();
    }

    public static interface EMVL2ProcessHandler {
        public void onWaitCard(int var1);

        public void onAppSelection(boolean var1, List<CandidateAIDInfo> var2, byte[] var3);

        public void onFinalSelect(FinalSelectData var1);

        public void onReadRecord(RecordData var1);

        public void onCardHolderVerify(CVMData var1);

        public void onOnlineProcess(TransactionData var1);

        public void onDisplayMessage(DisplayMessage var1);

        public void onEndProcess(int var1, TransactionData var2);

        public void onSendOut(int var1, byte[] var2);

        public void onObtain(int var1, byte[] var2);

        public void onVerifyOfflinePin(int var1, byte[] var2, CAPKey var3, VerifyOfflinePinResult var4);
    }
}

