/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.dock;

import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;

public class DockPort {
    static final Logger logger = Logger.getLogger(DockPort.class);
    public static final int BPS_1200 = 1;
    public static final int BPS_2400 = 2;
    public static final int BPS_4800 = 3;
    public static final int BPS_9600 = 4;
    public static final int BPS_19200 = 7;
    public static final int BPS_57600 = 8;
    public static final int BPS_115200 = 9;
    public static final int BPS_38400 = 10;
    public static final int PAR_EVEN = 69;
    public static final int PAR_ODD = 79;
    public static final int PAR_NONE = 78;
    public static final int DBS_7 = 7;
    public static final int DBS_8 = 8;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_DEVICE_USED = 137;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_DEVICE_DISABLE = 141;
    public static final int ERROR_SERVER_NOT_EXIST = 165;
    public static final int ERROR_STATUS_ERROR = 167;
    public static final int ERROR_INIT = 176;
    public static final int ERROR_COMM = 177;
    private String packageName;
    private int devHandle;
    private String dockerName;
    private String portName;
    private boolean isOpen;

    DockPort(String packageName, String dockerName, String portName) {
        this.packageName = packageName;
        this.dockerName = dockerName;
        this.portName = portName;
    }

    public synchronized int open(int bps, int par, int dps) {
        int ret;
        if (this.isOpen) {
            this.close();
        }
        this.isOpen = (ret = this.nativePortOpen(this.dockerName, this.portName, bps, par, dps)) == 0;
        return ret;
    }

    public synchronized int close() {
        if (!this.isOpen) {
            return 0;
        }
        int ret = this.nativePortClose();
        this.isOpen = ret != 0;
        return ret;
    }

    public synchronized int updateConfig(int bps, int par, int dps) {
        if (!this.isOpen) {
            return 1;
        }
        return this.nativePortUpdateConfig(bps, par, dps);
    }

    public synchronized int write(byte[] sendData, int timeout) {
        Precondition.checkNotNull(sendData);
        Precondition.checkArgument(timeout >= 0, "timeout can't be negative!");
        if (!this.isOpen) {
            return 1;
        }
        return this.nativePortWrite(sendData, timeout);
    }

    public synchronized int read(int expectedLen, BytesBuffer buffer, int timeout) {
        Precondition.checkNotNull(buffer);
        Precondition.checkArgument(expectedLen >= 0, "expectedLen can't be negative!");
        Precondition.checkArgument(timeout >= 0, "timeout can't be negative!");
        if (!this.isOpen) {
            return 1;
        }
        return this.nativePortRead(expectedLen, buffer, timeout);
    }

    public synchronized boolean isBufferEmpty() {
        if (!this.isOpen) {
            return true;
        }
        IntegerBuffer baseStatus = new IntegerBuffer();
        int ret = this.nativePortIsBufferEmpty(baseStatus);
        return ret == 0 ? baseStatus.getData() != 0 : true;
    }

    public synchronized int clearBuffer() {
        if (!this.isOpen) {
            return 1;
        }
        return this.nativePortClearBuffer();
    }

    private native int nativePortOpen(String var1, String var2, int var3, int var4, int var5);

    private native int nativePortClose();

    private native int nativePortUpdateConfig(int var1, int var2, int var3);

    private native int nativePortWrite(byte[] var1, int var2);

    private native int nativePortRead(int var1, BytesBuffer var2, int var3);

    private native int nativePortIsBufferEmpty(IntegerBuffer var1);

    private native int nativePortClearBuffer();

    static {
        System.loadLibrary("eptand_jni");
    }
}

