/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device.beeper;

import com.landicorp.android.eptapi.device.beeper.AudioBeeper;
import java.util.Timer;
import java.util.TimerTask;

public class BeepApi {
    private Timer timer;
    private TimerTask task;
    private Thread thread;
    boolean isPlaySound;
    AudioBeeper audio = new AudioBeeper();
    private static BeepApi INSTANCE = new BeepApi();

    public static BeepApi getInstance() {
        return INSTANCE;
    }

    private BeepApi() {
    }

    public void beep(int rate, long time) {
        if (time == 0L) {
            this.stop();
            return;
        }
        this.stopInner();
        this.audio.start(rate);
        this.thread = new Thread(new Runnable(){

            @Override
            public void run() {
                Thread self = Thread.currentThread();
                while (BeepApi.this.isPlaySound && !self.isInterrupted()) {
                    BeepApi.this.audio.play();
                }
            }
        });
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
        if (this.task != null) {
            this.task.cancel();
            this.task = null;
        }
        this.timer = new Timer();
        this.task = new TimerTask(){

            @Override
            public void run() {
                BeepApi.this.isPlaySound = false;
                BeepApi.this.audio.stop();
            }
        };
        this.isPlaySound = true;
        this.thread.start();
        this.timer.schedule(this.task, time);
    }

    public void beep(long time) {
        this.beep(720, time);
    }

    public void stop() {
        this.stopInner();
        this.audio.stop();
    }

    private void stopInner() {
        if (this.thread != null) {
            this.isPlaySound = false;
            this.thread.interrupt();
            try {
                this.thread.join(1000L);
                this.thread = null;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }
}

