/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import java.util.HashMap;
import java.util.Map;

public class UsbHidDevice {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_TIMEOUT = 138;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_HANDLE = 140;
    public static final int ERROR_DEVICE = 141;
    private static final Map<String, UsbHidDevice> INSTANCES = new HashMap<String, UsbHidDevice>();
    private String packageName;
    private MasterController mMCtl = MasterController.getInstance();

    public static UsbHidDevice getInstance() {
        return UsbHidDevice.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UsbHidDevice getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, UsbHidDevice> map = INSTANCES;
        synchronized (map) {
            if (INSTANCES.containsKey(packageName)) {
                return INSTANCES.get(packageName);
            }
            UsbHidDevice device = new UsbHidDevice(packageName);
            INSTANCES.put(packageName, device);
            return device;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, UsbHidDevice> map = INSTANCES;
        synchronized (map) {
            if (INSTANCES.containsKey(packageName)) {
                INSTANCES.remove(packageName);
            }
        }
    }

    private UsbHidDevice(String packageName) {
        this.packageName = packageName;
    }

    public int open(final int mode) {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(mode);
            }
        }.invoke(5633);
    }

    public int close() {
        return new RemoteInvoker(){}.invoke(5634);
    }

    public int write(final byte[] inData, final IntegerBuffer actLen, final int timeoutMs) {
        Precondition.checkNotNull(inData);
        Precondition.checkNotNull(actLen);
        Precondition.checkArgument(timeoutMs >= 0);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(inData);
                data.writeInt(timeoutMs);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (actLen != null) {
                    actLen.setData(reply.readInt());
                }
            }
        }.invoke(5635);
    }

    public int setMode(final ModeType mode, final ModeValue value) {
        Precondition.checkNotNull(mode);
        Precondition.checkNotNull(value);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(mode.value);
                data.writeInt(value.value);
            }
        }.invoke(5636);
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int invoke(int code) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                this.onRequest(data);
                UsbHidDevice.this.mMCtl.request(UsbHidDevice.this.packageName, code, data, reply);
                int result = reply.readInt();
                this.onResponse(reply);
                int n = result;
                return n;
            }
            catch (RequestException e) {
                e.printStackTrace();
                int n = 1;
                return n;
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel reply) {
        }
    }

    public static enum ModeValue {
        CHINESE_MODE_ORIGIN(0),
        CHINESE_MODE_TO_CODEPAGE(3),
        CHINESE_MODE_DISABLE(4),
        CHINESE_MODE_TO_UNICODE(5);

        private final int value;

        private ModeValue(int value) {
            this.value = value;
        }
    }

    public static enum ModeType {
        HID_SEND_MODE(1);

        private final int value;

        private ModeType(int value) {
            this.value = value;
        }
    }
}

