/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class SignPanel {
    static final Logger logger = Logger.getLogger(SignPanel.class);
    public static final int EM_SUCCESS = 0;
    public static final int EM_ERROR = 1;
    public static final int EM_ABOLISH = 27;
    public static final int EM_CANCEL = 50;
    public static final int EM_SIGN_COMMERR = 51;
    public static final int EM_DEVICE_USED = 137;
    public static final int EM_TIMEOUT = 138;
    public static final int EM_ERRPARAM = 139;
    public static final int EM_ERRHANDLE = 140;
    public static final int EM_DEVICE_DISABLE = 141;
    public static final int EM_ALLOCERR = 142;
    public static final int EM_RECONNECT = 64961;
    public static final int EM_DISCONNECT = 64962;
    public static final int DATA_TYPE_BMP = 0;
    public static final int DATA_TYPE_PBM = 1;
    private static Map<String, SignPanel> sInstances = new ConcurrentHashMap<String, SignPanel>();
    private String packageName;
    private String deviceName;
    private int mOnSignListenerID = 0;
    private MasterController mMCtl = MasterController.getInstance();

    private SignPanel(String deviceName) {
        this.deviceName = deviceName;
    }

    public static SignPanel getInstance(String deviceName) {
        return SignPanel.getInstance(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SignPanel getInstance(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        Map<String, SignPanel> map = sInstances;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, deviceName);
            if (sInstances.containsKey(key)) {
                return sInstances.get(key);
            }
            SignPanel signPanel = new SignPanel(deviceName);
            signPanel.packageName = packageName;
            sInstances.put(key, signPanel);
            return signPanel;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, SignPanel> map = sInstances;
        synchronized (map) {
            for (String key : sInstances.keySet()) {
                Integer listener;
                SignPanel signPanel;
                if (!DeviceKeys.matchPackageName(key, packageName) || (signPanel = sInstances.remove(key)) == null || (listener = ServiceVariable.removeListener(signPanel.packageName, signPanel.mOnSignListenerID)) == null) continue;
                MasterController.getInstance().uninstallListener(packageName, listener);
            }
        }
    }

    public boolean openDevice() {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(StringUtil.getGBK(SignPanel.this.deviceName));
            }
        }.invoke(4097);
    }

    public boolean closeDevice() {
        this.stopSignLocal();
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(StringUtil.getGBK(SignPanel.this.deviceName));
            }
        }.invoke(4098);
    }

    private void stopSignLocal() {
        Integer listener = ServiceVariable.removeListener(this.packageName, this.mOnSignListenerID);
        if (listener != null) {
            this.mMCtl.uninstallListener(this.packageName, listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSign(final String specialCode, final int timeout, OnSignListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        Precondition.checkNotNull(specialCode);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnSignListenerID)) {
            logger.error("### startSign has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnSignListener onSignListener = listener;
        synchronized (onSignListener) {
            if (listener.isStarted() && listener.getSignPanel() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setSignPanel(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(StringUtil.getGBK(SignPanel.this.deviceName));
                request.writeByteArray(StringUtil.getGBK(specialCode));
                request.writeInt(timeout < 0 ? 0 : timeout);
            }
        }.invoke(4099, listener);
    }

    @Deprecated
    public boolean stopSign() {
        this.stopSignLocal();
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(StringUtil.getGBK(SignPanel.this.deviceName));
            }
        }.invoke(4108);
    }

    public void endSign() {
        if (ServiceVariable.getListener(this.packageName, this.mOnSignListenerID) != null) {
            logger.error("### sign panel should be confirmed or canelled before end sign! ###", new Object[0]);
            return;
        }
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            this.mMCtl.request(this.packageName, 4100, data);
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        finally {
            data.recycle();
        }
    }

    public boolean setSignParam(final SignCmd cmd, final int param) {
        if (Precondition.checkNotInRange(param, 0L, 10L)) {
            return false;
        }
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(StringUtil.getGBK(SignPanel.this.deviceName));
                request.writeInt(cmd.ordinal() + 1);
                request.writeInt(param);
            }
        }.invoke(4101);
    }

    public boolean getSignParam(final SignCmd cmd, final IntegerBuffer param) {
        Precondition.checkNotNull(cmd);
        Precondition.checkNotNull(param);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(StringUtil.getGBK(SignPanel.this.deviceName));
                request.writeInt(cmd.ordinal() + 1);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (param != null) {
                    param.setData(reply.readInt());
                }
            }
        }.invoke(4102);
    }

    public boolean getSignData(final BytesBuffer signData, final IntegerBuffer seqNum) {
        Precondition.checkNotNull(signData);
        Precondition.checkNotNull(seqNum);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(StringUtil.getGBK(SignPanel.this.deviceName));
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (seqNum != null) {
                    seqNum.setData(reply.readInt());
                }
                if (signData != null) {
                    signData.setData(reply.createByteArray());
                }
            }
        }.invoke(4103);
    }

    public final boolean jbigCompression(final byte[] data, final BytesBuffer compData, final IntegerBuffer dataType) {
        Precondition.checkNotNull(data);
        Precondition.checkNotNull(compData);
        Precondition.checkNotNull(dataType);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(data);
            }

            @Override
            protected void onResponse(Parcel reply) {
                int imageType = reply.readInt();
                if (dataType != null) {
                    switch (imageType) {
                        case 0: {
                            dataType.setData(0);
                            break;
                        }
                        case 1: {
                            dataType.setData(1);
                        }
                    }
                }
                if (compData != null) {
                    compData.setData(reply.createByteArray());
                }
            }
        }.invoke(4104);
    }

    public final boolean jbigDecompression(final byte[] data, final int dataType, final BytesBuffer decompData) {
        Precondition.checkNotNull(data);
        Precondition.checkNotNull(decompData);
        if (dataType != 0 && dataType != 1) {
            throw new IllegalArgumentException("dataType illegal");
        }
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(data);
                request.writeInt(dataType);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (decompData != null) {
                    decompData.setData(reply.createByteArray());
                }
            }
        }.invoke(4105);
    }

    public boolean transBitmapToPrinter(final byte[] data, final BytesBuffer printData) {
        Precondition.checkNotNull(data);
        Precondition.checkNotNull(printData);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel request) {
                request.writeByteArray(data);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (printData != null) {
                    printData.setData(reply.createByteArray());
                }
            }
        }.invoke(4106);
    }

    public static abstract class OnSignListener
    extends RemoteListener {
        public static final int ID = 2305;
        static final int RECONNECT = 64961;
        private SignPanel device;
        private boolean isStarted;

        public OnSignListener() {
        }

        public void setStarted(boolean b) {
            this.isStarted = b;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        public OnSignListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        protected final void onListened(Parcel data) {
            this.stopSignLocal();
            if (data.dataAvail() == 0) {
                logger.error("# OnSignListener | onListened | reply data error!", new Object[0]);
                this.onFail(1);
                return;
            }
            int errorCode = data.readInt();
            String devName = data.readString();
            if (!this.device.deviceName.equals(devName)) {
                logger.error("# OnSignListener | onListened | device name error: " + devName, new Object[0]);
                this.onFail(1);
                return;
            }
            if (errorCode != 0) {
                this.onFail(errorCode);
                return;
            }
            int cmd = data.readInt();
            int state = data.readInt();
            switch (cmd) {
                case 1: {
                    if (state == 0) {
                        this.onSigned();
                        break;
                    }
                    if (state == 50) {
                        this.onCancel();
                        break;
                    }
                    if (state != 138) break;
                    this.onTimeout();
                    break;
                }
                default: {
                    logger.error("# OnSignListener | onListened | cmd error: " + cmd, new Object[0]);
                    this.onFail(1);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopSignLocal() {
            SignPanel device = this.device;
            OnSignListener onSignListener = this;
            synchronized (onSignListener) {
                this.setStarted(false);
            }
            device.stopSignLocal();
        }

        public abstract void onSigned();

        public abstract void onCancel();

        public abstract void onTimeout();

        public abstract void onFail(int var1);

        @Override
        public final int getEventId() {
            return 2305;
        }

        public SignPanel getSignPanel() {
            return this.device;
        }

        void setSignPanel(SignPanel device) {
            this.device = device;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            OnSignListener onSignListener = this;
            synchronized (onSignListener) {
                this.setStarted(false);
            }
        }
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void invoke(int requestCode, OnSignListener listener) {
            Parcel request = Parcel.obtain();
            try {
                this.onRequest(request);
                SignPanel.this.mOnSignListenerID = ServiceVariable.saveListener(SignPanel.this.packageName, listener);
                SignPanel.this.mMCtl.requestCallback(SignPanel.this.packageName, requestCode, request, listener);
            }
            catch (RequestException e) {
                listener.onFail(1);
                e.printStackTrace();
            }
            finally {
                request.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean invoke(int requestCode) {
            Parcel request = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                this.onRequest(request);
                SignPanel.this.mMCtl.request(SignPanel.this.packageName, requestCode, request, reply);
                if (reply.dataAvail() == 0) {
                    boolean bl = false;
                    return bl;
                }
                int ret = reply.readInt();
                if (ret != 0) {
                    boolean bl = false;
                    return bl;
                }
                if (reply.dataAvail() > 0) {
                    this.onResponse(reply);
                }
                boolean bl = ret == 0;
                return bl;
            }
            catch (RequestException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                request.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel request) {
        }

        protected void onResponse(Parcel reply) {
        }
    }

    public static enum ESP_RES_CMD {
        START,
        HANDSHAKE,
        NUMS;

    }

    public static enum SignCmd {
        CHECKSIGNED,
        LANGUAGE,
        DATAFORMAT,
        DEJBIGDATAFMT,
        CALLBRATE,
        STORAGE,
        SETPENTHICK;

    }
}

