/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import android.text.TextUtils;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class NFCRFCardReader {
    static final Logger logger = Logger.getLogger(NFCRFCardReader.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_NOTAGERR = 2;
    public static final int ERROR_COLLERR = 20;
    public static final int ERROR_ABOLISH = 24;
    public static final int ERROR_ERRTYPE = 25;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_DEVICE_DISABLE = 141;
    public static final int ERROR_TRANSERR = 162;
    public static final int ERROR_MULTIERR = 164;
    public static final int ERROR_NOCARD = 165;
    public static final int ERROR_CARDEXIST = 166;
    public static final int ERROR_CARD_TIMEOUT = 167;
    public static final int ERROR_CARDNOACT = 179;
    private static final int OPEN_MODE = 8;
    private static Map<String, NFCRFCardReader> sInstances = new ConcurrentHashMap<String, NFCRFCardReader>();
    private String packageName;
    private String deviceName = "USERCARD";
    private int mOnPollListenerID = 0;
    private MasterController mMCtl = MasterController.getInstance();

    private NFCRFCardReader() {
        this("USERCARD");
    }

    private NFCRFCardReader(String deviceName) {
        this.deviceName = deviceName;
    }

    public static NFCRFCardReader getInstance(String deviceName) {
        return NFCRFCardReader.getInstance(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NFCRFCardReader getInstance(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        Map<String, NFCRFCardReader> map = sInstances;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, deviceName);
            if (sInstances.containsKey(key)) {
                return sInstances.get(key);
            }
            NFCRFCardReader reader = new NFCRFCardReader(deviceName);
            reader.packageName = packageName;
            sInstances.put(key, reader);
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, NFCRFCardReader> map = sInstances;
        synchronized (map) {
            for (String key : sInstances.keySet()) {
                Integer listener;
                NFCRFCardReader reader;
                if (!DeviceKeys.matchPackageName(key, packageName) || (reader = sInstances.remove(key)) == null || (listener = ServiceVariable.removeListener(reader.packageName, reader.mOnPollListenerID)) == null) continue;
                MasterController.getInstance().uninstallListener(reader.packageName, listener);
            }
        }
    }

    public boolean openDevice() {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(NFCRFCardReader.this.deviceName));
                data.writeInt(8);
            }
        }.invoke(3841) == 0;
    }

    public void closeDevice() {
        new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(NFCRFCardReader.this.deviceName));
            }
        }.invoke(3842);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startPollCard(OnPollCardListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        if (null != ServiceVariable.getListener(this.packageName, this.mOnPollListenerID)) {
            logger.error("### startPollCard has not finished! ###", new Object[0]);
            listener.onFail(1);
            return;
        }
        OnPollCardListener onPollCardListener = listener;
        synchronized (onPollCardListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setPackageName(this.packageName);
        }
        new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(NFCRFCardReader.this.deviceName));
            }
        }.invoke(3844, listener);
    }

    public void stopPollCard() {
        this.stopPollLocal();
        new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(NFCRFCardReader.this.deviceName));
            }
        }.invoke(3845);
    }

    public boolean setLed(final LEDID ledID, final boolean on) {
        Precondition.checkNotNull(ledID);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(NFCRFCardReader.this.deviceName));
                data.writeInt(ledID.ordinal());
                data.writeInt(on ? 1 : 0);
            }
        }.invoke(3848) == 0;
    }

    public int getCardUid(final BytesBuffer response) {
        Precondition.checkNotNull(response);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(NFCRFCardReader.this.deviceName));
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (response != null) {
                    response.setData(reply.createByteArray());
                }
            }
        }.invoke(3847);
    }

    public int transparent(final byte[] cmd, final BytesBuffer response) throws RequestException {
        Precondition.checkNotNull(cmd);
        Precondition.checkNotNull(response);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeByteArray(StringUtil.getGBK(NFCRFCardReader.this.deviceName));
                data.writeByteArray(cmd);
            }

            @Override
            protected void onResponse(Parcel reply) {
                if (response != null) {
                    response.setData(reply.createByteArray());
                }
            }
        }.invoke(3846);
    }

    private void stopPollLocal() {
        Integer listener = ServiceVariable.removeListener(this.packageName, this.mOnPollListenerID);
        if (listener != null) {
            this.mMCtl.uninstallListener(this.packageName, listener);
        }
    }

    public static abstract class OnPollCardListener
    extends RemoteListener {
        public static final int ID = 2049;
        private boolean isStarted;
        private NFCRFCardReader reader;

        public OnPollCardListener() {
        }

        public void setStarted(boolean b) {
            this.isStarted = b;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        public OnPollCardListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        protected final void onListened(Parcel data) {
            this.stopSearchLocal();
            if (data.dataAvail() == 0) {
                logger.error("# OnPollCardListener | onListened | reply data error!", new Object[0]);
                this.onFail(1);
                return;
            }
            int errorCode = data.readInt();
            if (errorCode != 0) {
                this.onFail(errorCode);
                return;
            }
            String devName = data.readString();
            if (!TextUtils.isEmpty((CharSequence)devName) && !this.reader.deviceName.equals(devName)) {
                logger.error("# OnPollCardListener | onListened | device name error: " + devName, new Object[0]);
                this.onFail(1);
                return;
            }
            this.onCardPass();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopSearchLocal() {
            NFCRFCardReader reader = this.reader;
            OnPollCardListener onPollCardListener = this;
            synchronized (onPollCardListener) {
                this.setStarted(false);
            }
            reader.stopPollLocal();
        }

        public abstract void onCardPass();

        public abstract void onFail(int var1);

        @Override
        public final int getEventId() {
            return 2049;
        }

        public NFCRFCardReader getReader() {
            return this.reader;
        }

        void setReader(NFCRFCardReader reader) {
            this.reader = reader;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            OnPollCardListener onPollCardListener = this;
            synchronized (onPollCardListener) {
                this.setStarted(false);
            }
        }
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void invoke(int requestCode, OnPollCardListener listener) {
            Parcel request = Parcel.obtain();
            try {
                this.onRequest(request);
                NFCRFCardReader.this.mOnPollListenerID = ServiceVariable.saveListener(NFCRFCardReader.this.packageName, listener);
                NFCRFCardReader.this.mMCtl.requestCallback(NFCRFCardReader.this.packageName, requestCode, request, listener);
            }
            catch (RequestException e) {
                e.printStackTrace();
                listener.onFail(1);
            }
            finally {
                request.recycle();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int invoke(int requestCode) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                this.onRequest(data);
                NFCRFCardReader.this.mMCtl.request(NFCRFCardReader.this.packageName, requestCode, data, reply);
                if (reply.dataAvail() == 0) {
                    int n = 1;
                    return n;
                }
                int ret = reply.readInt();
                if (ret != 0) {
                    int n = ret;
                    return n;
                }
                if (reply.dataAvail() > 0) {
                    this.onResponse(reply);
                }
                int n = ret;
                return n;
            }
            catch (RequestException e) {
                e.printStackTrace();
                int n = 1;
                return n;
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel reply) {
        }
    }

    public static enum LEDID {
        YELLOW,
        BLUE,
        GREEN,
        RED;

    }
}

