/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import android.text.TextUtils;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.service.ServiceVariable;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.DeviceKeys;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FelicaReader {
    static final Logger logger = Logger.getLogger(FelicaReader.class);
    public static final int ERROR_NONE = 0;
    public static final int ERROR_FAIL = 1;
    public static final int ERROR_NOTAGERR = 2;
    public static final int ERROR_CRCERR = 3;
    public static final int ERROR_AUTHERR = 4;
    public static final int ERROR_PARITYERR = 5;
    public static final int ERROR_CODEERR = 6;
    public static final int ERROR_SERNRERR = 7;
    public static final int ERROR_NOTAUTHERR = 8;
    public static final int ERROR_BITCOUNTERR = 9;
    public static final int ERROR_BYTECOUNTERR = 10;
    public static final int ERROR_OVFLERR = 17;
    public static final int ERROR_FRAMINGERR = 18;
    public static final int ERROR_ERRPARAM = 139;
    public static final int ERROR_DEVICE_USED = 137;
    public static final int ERROR_DEVICE_DISABLE = 141;
    public static final int ERROR_TRANSERR = 162;
    public static final int ERROR_PROTERR = 163;
    public static final int ERROR_MULTIERR = 164;
    public static final int ERROR_NOCARD = 165;
    public static final int ERROR_CARDEXIST = 166;
    public static final int ERROR_TIMEOUT = 167;
    public static final int ERROR_CARDNOACT = 179;
    public static final int ERROR_ABNORMAL = 180;
    public static final int OM_MIFS_TYPEA = 0;
    public static final int OM_MIFS_TYPEB = 8;
    public static final int OM_MIFS_TYPEF = 16;
    public static final int CARD_MIFS_S50 = 0;
    public static final int CARD_MIFS_S70 = 1;
    public static final int CARD_MIFS_PRO = 2;
    public static final int CARD_MIFS_PROS50 = 3;
    public static final int CARD_MIFS_PROS70 = 4;
    public static final int CARD_MIFS_TYPEB = 5;
    public static final int PARAM_MIFS_TYPEBCONFIG = 12;
    public static final int PARAM_MIFS_SETCARDTYPE = 13;
    public static final int PARAM_MIFS_EMVCONFIG = 14;
    public static final int PARAM_MIFS_SETFSC = 15;
    public static final int PARAM_MIFS_GAINA = 16;
    public static final int PARAM_MIFS_GAINB = 17;
    public static final int PARAM_MIFS_CIDSUPPORT = 18;
    public static final int PARAM_MIFS_CARRIER_SET = 19;
    private static Map<String, FelicaReader> sInstances = new ConcurrentHashMap<String, FelicaReader>();
    private String packageName;
    private String deviceName = "USERCARD";
    private int mCommandListenerID = 0;
    private MasterController mMCtl = MasterController.getInstance();

    private FelicaReader() {
        this("USERCARD");
    }

    private FelicaReader(String deviceName) {
        this.deviceName = deviceName;
    }

    public static FelicaReader getInstance() {
        return FelicaReader.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    public static FelicaReader getInstance(String packageName) {
        return FelicaReader.getInstance(packageName, "USERCARD");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FelicaReader getInstance(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        Map<String, FelicaReader> map = sInstances;
        synchronized (map) {
            String key = DeviceKeys.createKey(packageName, deviceName);
            if (sInstances.containsKey(key)) {
                return sInstances.get(key);
            }
            FelicaReader reader = new FelicaReader(deviceName);
            reader.packageName = packageName;
            sInstances.put(key, reader);
            return reader;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Map<String, FelicaReader> map = sInstances;
        synchronized (map) {
            for (String key : sInstances.keySet()) {
                Integer listener;
                FelicaReader reader;
                if (!DeviceKeys.matchPackageName(key, packageName) || (reader = sInstances.remove(key)) == null || (listener = ServiceVariable.removeListener(reader.packageName, reader.mCommandListenerID)) == null) continue;
                MasterController.getInstance().uninstallListener(reader.packageName, listener);
            }
        }
    }

    public int openDevice(final int mode) {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(mode);
            }
        }.invoke(4353);
    }

    public int closeDevice() {
        return this.simpleRequest(4354);
    }

    public int felicaCommand(final int waitTime, final byte[] sendData, final BytesBuffer respData) {
        Precondition.checkNotNull(respData);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(waitTime);
                data.writeByteArray(sendData);
            }

            @Override
            protected void onResponse(Parcel data) {
                if (respData != null) {
                    respData.setData(data.createByteArray());
                }
            }
        }.invoke(4359);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void felicaCommand(int waitTime, byte[] sendData, OnCommandListener listener) throws RequestException {
        Precondition.checkNotNull(sendData);
        Precondition.checkNotNull(listener);
        if (ServiceVariable.getListener(this.packageName, this.mCommandListenerID) != null) {
            logger.error("### felicaCommand has not finished! ###", new Object[0]);
            listener.onError(1);
            return;
        }
        OnCommandListener onCommandListener = listener;
        synchronized (onCommandListener) {
            if (listener.isStarted() && listener.getReader() != this) {
                throw new IllegalArgumentException("one listener cannot be used to listen two devices!");
            }
            listener.setReader(this);
            listener.setStarted(true);
            listener.setDeviceName(this.deviceName);
            listener.setPackageName(this.packageName);
        }
        Parcel data = Parcel.obtain();
        data.writeByteArray(StringUtil.getGBK(this.deviceName));
        data.writeInt(waitTime);
        data.writeByteArray(sendData);
        try {
            this.mMCtl.setTaskID(this.packageName, -1);
            this.mCommandListenerID = ServiceVariable.saveListener(this.packageName, listener);
            this.mMCtl.requestCallback(this.packageName, 4360, data, listener);
        }
        finally {
            data.recycle();
        }
    }

    public int setParamConfig(final int name, final int value) {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(name);
                data.writeInt(value);
            }
        }.invoke(4361);
    }

    private int simpleRequest(int requestCode) {
        return new RemoteInvoker(){}.invoke(requestCode);
    }

    public static abstract class OnCommandListener
    extends BaseRemoteListener {
        public static final int ID = 2563;

        public OnCommandListener() {
        }

        public OnCommandListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        public final int getEventId() {
            return 2563;
        }

        @Override
        protected final void onListened(Parcel data) {
            int error = data.readInt();
            logger.debug("# onListened | dataSize: " + data.dataSize() + ", error: " + error, new Object[0]);
            if (error != 0) {
                this.stopLocal(this.reader.mCommandListenerID);
                this.onError(error);
                return;
            }
            byte[] response = data.createByteArray();
            if (response == null || response.length == 0) {
                this.stopLocal(this.reader.mCommandListenerID);
                this.onError(1);
                return;
            }
            logger.debug("# onListened | responseSize: " + response.length, new Object[0]);
            if (data.dataAvail() > 0) {
                String deviceName = data.readString();
                logger.debug("# onListened | this.deviceName: " + this.deviceName + ", deviceName: " + deviceName, new Object[0]);
                if (!TextUtils.isEmpty((CharSequence)deviceName) && !deviceName.equals(this.deviceName)) {
                    this.onError(1);
                    return;
                }
            }
            this.stopLocal(this.reader.mCommandListenerID);
            this.onSuccess(response);
        }

        public abstract void onSuccess(byte[] var1);

        public abstract void onError(int var1);
    }

    private static abstract class BaseRemoteListener
    extends RemoteListener {
        protected boolean isStarted;
        protected String deviceName;
        protected FelicaReader reader;

        public BaseRemoteListener() {
        }

        public BaseRemoteListener(PausableHandler handler) {
            super(handler);
        }

        public void setDeviceName(String deviceName) {
            this.deviceName = deviceName;
        }

        public FelicaReader getReader() {
            return this.reader;
        }

        void setReader(FelicaReader reader) {
            this.reader = reader;
        }

        public void setStarted(boolean started) {
            this.isStarted = started;
        }

        public boolean isStarted() {
            return this.isStarted;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void stopLocal(int listenerID) {
            FelicaReader reader = this.reader;
            BaseRemoteListener baseRemoteListener = this;
            synchronized (baseRemoteListener) {
                this.setStarted(false);
            }
            Integer listener = ServiceVariable.removeListener(reader.packageName, listenerID);
            if (listener == null) {
                return;
            }
            MasterController.getInstance().uninstallListener(reader.packageName, listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onDetached() {
            BaseRemoteListener baseRemoteListener = this;
            synchronized (baseRemoteListener) {
                this.setStarted(false);
            }
        }
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int invoke(int requestCode) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                data.writeByteArray(StringUtil.getGBK(FelicaReader.this.deviceName));
                this.onRequest(data);
                FelicaReader.this.mMCtl.request(FelicaReader.this.packageName, requestCode, data, reply);
                if (reply.dataAvail() == 0) {
                    int n = 1;
                    return n;
                }
                int result = reply.readInt();
                this.onResponse(reply);
                int n = result;
                return n;
            }
            catch (RequestException e) {
                e.printStackTrace();
                int n = 1;
                return n;
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel replay) {
        }
    }
}

