/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.log.Logger;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class Digled {
    static final Logger logger = Logger.getLogger(Digled.class);
    public static final int EM_SUCCESS = 0;
    public static final int EM_ERROR = 1;
    public static final int EM_ERRPARAM = 139;
    public static final int EM_digled_OVERFLOW = 17;
    public static final int EM_digled_ERRDATA = 18;
    public static final int EM_DEVICE_DISABLE = 141;
    public static final int EM_digled_NO_DEVICE = 16;
    public static final int OPEN_MODE_DEFAULT = 0;
    public static final int ALIGN_RIGHT = 50;
    public static final int ALIGN_RIGHT_POSITIVE = 178;
    public static final int ALIGN_LEFT = 49;
    public static final int ALIGN_LEFT_POSITIVE = 177;
    public static final int LIGHT_AMOUT = 1;
    public static final int LIGHT_BALANCE = 2;
    public static final int LIGHT_OFF = 0;
    public static final int LIGHT_ON = 1;
    private final int ITEM_LINE_NUMBER = 1;
    private final int ITEM_LIGHT_NUMBER = 2;
    private final int ITEM_LINE_MAX = 3;
    private final int ITEM_LIGHT_TYPE = 4;
    private static Map<String, Digled> sInstances = new ConcurrentHashMap<String, Digled>();
    private String packageName;
    private MasterController mMCtl = MasterController.getInstance();

    private Digled() {
    }

    public static Digled getInstance() {
        return Digled.getInstance(MasterController.getInstance().getDefaultAppName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Digled getInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, Digled> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                return sInstances.get(packageName);
            }
            Digled instance = new Digled();
            instance.packageName = packageName;
            sInstances.put(packageName, instance);
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeInstance(String packageName) {
        Precondition.checkNotEmpty(packageName);
        Map<String, Digled> map = sInstances;
        synchronized (map) {
            if (sInstances.containsKey(packageName)) {
                sInstances.remove(packageName);
            }
        }
    }

    public boolean clearLine(final int line) {
        Precondition.checkArgument(line >= 1);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(line);
            }
        }.invoke(3589);
    }

    public boolean dispaly(final int line, final int align, final String format, final float number) {
        Precondition.checkArgument(line >= 1);
        Precondition.checkNotEmpty(format);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(line);
                data.writeInt(align);
                data.writeByteArray(StringUtil.getGBK(format));
                data.writeFloat(number);
            }
        }.invoke(3587);
    }

    public boolean displaySeg(final int line, final int align, final int[] seg) {
        Precondition.checkArgument(line >= 1);
        Precondition.checkArgument(seg != null && seg.length > 0);
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(line);
                data.writeInt(align);
                int length = seg.length;
                data.writeInt(seg.length);
                for (int i = 0; i < length; ++i) {
                    data.writeInt(seg[i]);
                }
            }
        }.invoke(3588);
    }

    public int getLineNumber() {
        final IntegerBuffer lineNum = new IntegerBuffer();
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(1);
                data.writeInt(0);
                data.writeInt(1);
            }

            @Override
            protected void onResponse(Parcel reply) {
                int size = reply.readInt();
                int value = reply.readInt();
                lineNum.setData(value);
            }
        }.invoke(3592) ? lineNum.getData() : -1;
    }

    public int getLightNumber() {
        final IntegerBuffer lightNum = new IntegerBuffer();
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(2);
                data.writeInt(0);
                data.writeInt(1);
            }

            @Override
            protected void onResponse(Parcel reply) {
                int size = reply.readInt();
                int value = reply.readInt();
                lightNum.setData(value);
            }
        }.invoke(3592) ? lightNum.getData() : -1;
    }

    public int getLineMax(final int line) {
        Precondition.checkArgument(line >= 1);
        final IntegerBuffer lineMax = new IntegerBuffer();
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(3);
                data.writeInt(line);
                data.writeInt(1);
            }

            @Override
            protected void onResponse(Parcel reply) {
                reply.readInt();
                lineMax.setData(reply.readInt());
            }
        }.invoke(3592) ? lineMax.getData() : -1;
    }

    public int[] getLightType() {
        final int length = this.getLightNumber();
        if (length <= 0) {
            logger.error("light number must > 0", new Object[0]);
            return null;
        }
        final IntegerBuffer typeNum = new IntegerBuffer();
        final int[] value = new int[32];
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(4);
                data.writeInt(0);
                data.writeInt(length);
            }

            @Override
            protected void onResponse(Parcel reply) {
                int retLen = reply.readInt();
                typeNum.setData(retLen);
                for (int i = 0; i < retLen; ++i) {
                    value[i] = reply.readInt();
                }
            }
        }.invoke(3592) ? Arrays.copyOf(value, typeNum.getData()) : null;
    }

    public int getLightStatus(final int lightName) {
        final IntegerBuffer status = new IntegerBuffer();
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(lightName);
            }

            @Override
            protected void onResponse(Parcel reply) {
                status.setData(reply.readInt());
            }
        }.invoke(3591) ? status.getData() : -1;
    }

    public boolean setLightStatus(final int lightName, final int status) {
        return new RemoteInvoker(){

            @Override
            protected void onRequest(Parcel data) {
                data.writeInt(lightName);
                data.writeInt(status);
            }
        }.invoke(3590);
    }

    private abstract class RemoteInvoker {
        private RemoteInvoker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final boolean invoke(int requestCode) {
            Parcel data = Parcel.obtain();
            Parcel reply = Parcel.obtain();
            try {
                this.onRequest(data);
                Digled.this.mMCtl.request(Digled.this.packageName, requestCode, data, reply);
                if (reply.dataAvail() == 0) {
                    boolean bl = false;
                    return bl;
                }
                int ret = reply.readInt();
                if (ret != 0) {
                    boolean bl = false;
                    return bl;
                }
                if (reply.dataAvail() > 0) {
                    this.onResponse(reply);
                }
                boolean bl = ret == 0;
                return bl;
            }
            catch (RequestException e) {
                e.printStackTrace();
                boolean bl = false;
                return bl;
            }
            finally {
                data.recycle();
                reply.recycle();
            }
        }

        protected void onRequest(Parcel data) {
        }

        protected void onResponse(Parcel reply) {
        }
    }
}

