/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Parcel;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.listener.RemoteListener;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.PausableHandler;
import com.landicorp.android.eptapi.utils.Precondition;

public class CashBox {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_IS_ALEADY_OPEN = 137;
    public static final int ERROR_DEVICE_NOT_EXIST = 141;
    public static final int ERROR_FAIL = 1;
    private String deviceName;
    private String packageName;
    private OnBoxOpenListener openListener;

    public CashBox(String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public CashBox(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        this.deviceName = deviceName;
        this.packageName = packageName;
    }

    public void setOnBoxOpenListener(OnBoxOpenListener listener) {
        this.openListener = listener;
    }

    public void openBox() throws RequestException {
        Parcel reply = Parcel.obtain();
        try {
            MasterController.getInstance().request(this.packageName, 1025, null, reply, this.openListener);
        }
        finally {
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setCashBoxKey(boolean enable) {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(enable ? 1 : 0);
            MasterController.getInstance().request(this.packageName, 1026, data, reply);
            int status = reply.readInt();
            boolean bl = status == 0;
            return bl;
        }
        catch (RequestException e) {
            e.printStackTrace();
        }
        finally {
            data.recycle();
            reply.recycle();
        }
        return false;
    }

    public static abstract class OnBoxOpenListener
    extends RemoteListener {
        public static final int ERROR_COMMERR = 1;
        public static final int ERROR_TIMEOUT = 2;
        public static final int ERROR_FAIL = 3;

        public OnBoxOpenListener() {
        }

        public OnBoxOpenListener(PausableHandler handler) {
            super(handler);
        }

        @Override
        public final int getEventId() {
            return 0;
        }

        @Override
        protected final void onListened(Parcel data) {
            int ret = data.readInt();
            if (ret == 0) {
                this.onBoxOpened();
            } else {
                this.onBoxOpenFail(ret);
            }
        }

        public abstract void onBoxOpened();

        public abstract void onBoxOpenFail(int var1);
    }
}

