/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.device;

import android.os.Build;
import com.landicorp.android.eptapi.device.beeper.BeepApi;
import com.landicorp.android.eptapi.service.SystemPropertiesManager;
import com.landicorp.android.eptapi.utils.CustomConfigsUtil;

public class Beeper {
    public static final int FREQUENCY_300 = 300;
    public static final int FREQUENCY_750 = 750;
    public static final int FREQUENCY_1000 = 1000;
    public static final int FREQUENCY_1500 = 1500;
    public static final int FREQUENCY_2000 = 2000;
    public static final int FREQUENCY_4000 = 4000;
    public static final int FREQUENCY_6000 = 6000;
    private static final int ANDROID_VERSION_10 = 29;
    private static final int ERROR_NONE = 0;
    private static final int TONE_TYPE = 1;
    private static final String EPAY_BEEP_EXIST = "ro.epay.beep.exist";
    private static final String EXIST = "1";
    private static final BeepApi beepApi;

    private Beeper() {
    }

    public static void startBeep(int msec) {
        if (Beeper.hasBeeper()) {
            Beeper.setBeepTone(1, 4000);
            Beeper.beep(msec);
        } else {
            beepApi.beep(msec);
        }
    }

    public static void stopBeep() {
        if (Beeper.hasBeeper()) {
            Beeper.beep(0);
        } else {
            beepApi.stop();
        }
    }

    public static int startBeep(int frequency, int msec) {
        int result = 0;
        if (Beeper.hasBeeper()) {
            result = Beeper.setBeepTone(1, frequency);
            Beeper.beep(msec);
        } else {
            beepApi.beep(frequency, msec);
        }
        return result;
    }

    private static boolean hasBeeper() {
        String value = null;
        if (Build.VERSION.SDK_INT >= 29) {
            CustomConfigsUtil ccu = new CustomConfigsUtil();
            value = ccu.getSyscfgBase("BEEP_TYPE");
        } else {
            value = SystemPropertiesManager.getProperty(EPAY_BEEP_EXIST, "0");
        }
        return EXIST.equals(value);
    }

    private static native void beep(int var0);

    private static native int enableBeep(int var0);

    private static native int setBeepTone(int var0, int var1);

    static {
        System.loadLibrary("eptand_jni");
        beepApi = BeepApi.getInstance();
    }
}

