/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.MifareInterface;
import com.landicorp.android.eptapi.card.RFDriver;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.LongBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class MifareDriver
implements MifareInterface<OnResultListener, OnReadListener>,
RFDriver {
    public static final int ERROR_NONE = 0;
    public static final int ERROR_CARDTYPE = 25;
    public static final int ERROR_PARAM = 139;
    public static final int ERROR_FAILED = 143;
    public static final int KEY_A = 1;
    public static final int KEY_B = 2;
    private static final int AUTH_SECTOR = 1;
    private static final int AUTH_BLOCK = 2;
    private MasterController mMCtl = MasterController.getInstance();
    private String deviceName;
    private String packageName;

    public MifareDriver(String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), deviceName);
    }

    public MifareDriver(String packageName, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        this.deviceName = deviceName;
        this.packageName = packageName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int request(int mode, IntegerBuffer tagType) throws RequestException {
        Precondition.checkNotNull(tagType);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeInt(mode);
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 535, data, reply);
            int ret = reply.readInt();
            tagType.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int antiCollision(LongBuffer snr) throws RequestException {
        Precondition.checkNotNull(snr);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 536, data, reply);
            int ret = reply.readInt();
            snr.setData(reply.readLong());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int select(long snr, IntegerBuffer cardType) throws RequestException {
        Precondition.checkNotNull(cardType);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeLong(snr);
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 537, data, reply);
            int ret = reply.readInt();
            cardType.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public void authBlock(int blockNo, int keyType, byte[] key, OnResultListener listener) throws RequestException {
        this.auth(2, blockNo, keyType, key, listener);
    }

    @Override
    public void authSector(int sectorNo, int keyType, byte[] key, OnResultListener listener) throws RequestException {
        this.auth(1, sectorNo, keyType, key, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readBlock(int blockNo, OnReadListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        this.mMCtl.installListener(this.packageName, listener);
        try {
            p.writeInt(blockNo);
            p.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 520, p, reply, listener);
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeBlock(int blockNo, byte[] data, OnResultListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeByteArray(data);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        this.mMCtl.installListener(this.packageName, listener);
        try {
            this.mMCtl.request(this.packageName, 521, p, reply, listener);
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void backup(int blockNo, OnResultListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        this.mMCtl.installListener(this.packageName, listener);
        try {
            this.mMCtl.request(this.packageName, 522, p, reply, listener);
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void restore(int blockNo, OnResultListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        this.mMCtl.installListener(this.packageName, listener);
        try {
            this.mMCtl.request(this.packageName, 523, p, reply, listener);
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increase(int blockNo, int value, OnResultListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeInt(value);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        this.mMCtl.installListener(this.packageName, listener);
        try {
            this.mMCtl.request(this.packageName, 524, p, reply, listener);
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void decrease(int blockNo, int value, OnResultListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeInt(value);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        this.mMCtl.installListener(this.packageName, listener);
        try {
            this.mMCtl.request(this.packageName, 525, p, reply, listener);
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    @Override
    public void halt() throws RequestException {
        this.mMCtl.request(this.packageName, 516);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws RequestException {
        Parcel reply = Parcel.obtain();
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 515, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public String getDriverName() {
        return "RF_M1";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void auth(int code, int addr, int keytype, byte[] key, OnResultListener listener) throws RequestException {
        Precondition.checkNotNull(listener);
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(code);
        p.writeInt(addr);
        p.writeInt(keytype);
        p.writeByteArray(key);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        MasterController.getInstance().installListener(this.packageName, listener);
        try {
            MasterController.getInstance().request(this.packageName, 519, p, reply, listener);
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    @Override
    public void restoreRAM(int blockNo, OnResultListener listener) throws RequestException {
        this.backup(blockNo, listener);
    }

    @Override
    public void transferRAM(int blockNo, OnResultListener listener) throws RequestException {
        this.restore(blockNo, listener);
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    @Override
    public int authBlock(int blockNo, int keyType, byte[] key) throws RequestException {
        return this.auth(2, blockNo, keyType, key);
    }

    @Override
    public int authSector(int sectorNo, int keyType, byte[] key) throws RequestException {
        return this.auth(1, sectorNo, keyType, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readBlock(int blockNo, BytesBuffer data) throws RequestException {
        Precondition.checkNotNull(data);
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            p.writeInt(blockNo);
            p.writeByteArray(StringUtil.getGBK(this.deviceName));
            this.mMCtl.request(this.packageName, 520, p, reply, null);
            int ret = this.getErrorCode(reply);
            if (0 == ret) {
                byte[] b = reply.createByteArray();
                data.setData(b);
            }
            int n = ret;
            return n;
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int writeBlock(int blockNo, byte[] data) throws RequestException {
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeByteArray(data);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            this.mMCtl.request(this.packageName, 521, p, reply, null);
            int n = this.getErrorCode(reply);
            return n;
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int restoreRAM(int blockNo) throws RequestException {
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            this.mMCtl.request(this.packageName, 522, p, reply, null);
            int n = this.getErrorCode(reply);
            return n;
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int transferRAM(int blockNo) throws RequestException {
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            this.mMCtl.request(this.packageName, 523, p, reply, null);
            int n = this.getErrorCode(reply);
            return n;
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int increase(int blockNo, int value) throws RequestException {
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeInt(value);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            this.mMCtl.request(this.packageName, 524, p, reply, null);
            int n = this.getErrorCode(reply);
            return n;
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int decrease(int blockNo, int value) throws RequestException {
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(blockNo);
        p.writeInt(value);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            this.mMCtl.request(this.packageName, 525, p, reply, null);
            int n = this.getErrorCode(reply);
            return n;
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int auth(int code, int addr, int keytype, byte[] key) throws RequestException {
        if (keytype != 1 && keytype != 2) {
            return 139;
        }
        Parcel p = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        p.writeInt(code);
        p.writeInt(addr);
        p.writeInt(keytype);
        p.writeByteArray(key);
        p.writeByteArray(StringUtil.getGBK(this.deviceName));
        try {
            MasterController.getInstance().request(this.packageName, 519, p, reply, null);
            int n = this.getErrorCode(reply);
            return n;
        }
        finally {
            p.recycle();
            reply.recycle();
        }
    }

    private int getErrorCode(Parcel reply) {
        return reply.readInt();
    }

    public static abstract class OnReadListener
    extends MifareInterface.OnReadListener {
        public static final int ERROR_ERRPARAM = 139;
        public static final int ERROR_FAILED = 143;
        public static final int ERROR_NOTAGERR = 2;
        public static final int ERROR_CRCERR = 3;
        public static final int ERROR_AUTHERR = 4;
        public static final int ERROR_PARITYERR = 5;
        public static final int ERROR_CODEERR = 6;
        public static final int ERROR_SERNRERR = 7;
        public static final int ERROR_NOTAUTHERR = 8;
        public static final int ERROR_BITCOUNTERR = 9;
        public static final int ERROR_BYTECOUNTERR = 10;
        public static final int ERROR_OVFLERR = 17;
        public static final int ERROR_FRAMINGERR = 18;
        public static final int ERROR_UNKNOWN_COMMAND = 19;
        public static final int ERROR_COLLERR = 20;
        public static final int ERROR_RESETERR = 1;
        public static final int ERROR_INTERFACEERR = 22;
        public static final int ERROR_RECBUF_OVERFLOW = 23;
        public static final int ERROR_VALERR = 24;
        public static final int ERROR_ERRTYPE = 25;
        public static final int ERROR_SWDIFF = 231;
        public static final int ERROR_TRANSERR = 162;
        public static final int ERROR_PROTERR = 163;
        public static final int ERROR_MULTIERR = 164;
        public static final int ERROR_NOCARD = 165;
        public static final int ERROR_CARDEXIST = 166;
        public static final int ERROR_CARDTIMEOUT = 167;
        public static final int ERROR_CARDNOACT = 179;

        @Override
        public abstract void onSuccess(byte[] var1);

        @Override
        public abstract void onFail(int var1);

        @Override
        public final int getEventId() {
            return 0;
        }
    }

    public static abstract class OnResultListener
    extends MifareInterface.OnResultListener {
        public static final int ERROR_ERRPARAM = 139;
        public static final int ERROR_FAILED = 143;
        public static final int ERROR_NOTAGERR = 2;
        public static final int ERROR_CRCERR = 3;
        public static final int ERROR_AUTHERR = 4;
        public static final int ERROR_PARITYERR = 5;
        public static final int ERROR_CODEERR = 6;
        public static final int ERROR_SERNRERR = 7;
        public static final int ERROR_NOTAUTHERR = 8;
        public static final int ERROR_BITCOUNTERR = 9;
        public static final int ERROR_BYTECOUNTERR = 10;
        public static final int ERROR_OVFLERR = 17;
        public static final int ERROR_FRAMINGERR = 18;
        public static final int ERROR_UNKNOWN_COMMAND = 19;
        public static final int ERROR_COLLERR = 20;
        public static final int ERROR_RESETERR = 1;
        public static final int ERROR_INTERFACEERR = 22;
        public static final int ERROR_RECBUF_OVERFLOW = 23;
        public static final int ERROR_VALERR = 24;
        public static final int ERROR_ERRTYPE = 25;
        public static final int ERROR_SWDIFF = 231;
        public static final int ERROR_TRANSERR = 162;
        public static final int ERROR_PROTERR = 163;
        public static final int ERROR_MULTIERR = 164;
        public static final int ERROR_NOCARD = 165;
        public static final int ERROR_CARDEXIST = 166;
        public static final int ERROR_CARDTIMEOUT = 167;
        public static final int ERROR_CARDNOACT = 179;

        @Override
        public abstract void onSuccess();

        @Override
        public abstract void onFail(int var1);

        @Override
        public final int getEventId() {
            return 0;
        }
    }
}

