/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class At24CxxDriver
implements InsertDriver {
    public static final int CARDTYPE_CARDTYPE_AT24C01 = 0;
    public static final int CARDTYPE_CARDTYPE_AT24C02 = 1;
    public static final int CARDTYPE_CARDTYPE_AT24C04 = 2;
    public static final int CARDTYPE_CARDTYPE_AT24C08 = 3;
    public static final int CARDTYPE_CARDTYPE_AT24C16 = 4;
    public static final int CARDTYPE_CARDTYPE_AT24C32 = 5;
    public static final int CARDTYPE_CARDTYPE_AT24C64 = 6;
    public static final int CARDTYPE_CARDTYPE_AT24C128 = 7;
    public static final int CARDTYPE_CARDTYPE_AT24C256 = 8;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NOPOWER = 227;
    public static final int ERROR_NOCARD = 251;
    public static final int ERROR_OTHER = 1;
    public static final int ERROR_ERRPARAM = 139;
    public static final int ERROR_FAILED = 143;
    public static final int VOL_5 = 0;
    private String deviceName;
    private int cardType;
    private String packageName;

    public At24CxxDriver(int cardType) {
        this(cardType, "USERCARD");
    }

    public At24CxxDriver(int cardType, String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), cardType, deviceName);
    }

    public At24CxxDriver(String packageName, int cardType) {
        this(packageName, cardType, "USERCARD");
    }

    public At24CxxDriver(String packageName, int cardType, String deviceName) {
        Precondition.checkNotEmpty(packageName);
        Precondition.checkNotEmpty(deviceName);
        this.packageName = packageName;
        this.cardType = cardType;
        this.deviceName = deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws RequestException {
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 771, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public void halt() throws RequestException {
        Parcel data = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 772, data);
        }
        finally {
            data.recycle();
        }
    }

    @Override
    public String getDriverName() {
        return "INSERT_AT24CXX";
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerUp(int vol) throws RequestException {
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(vol);
            data.writeInt(this.cardType);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 833, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public int powerUp() throws RequestException {
        return this.powerUp(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerDown() throws RequestException {
        Parcel data = null;
        Parcel reply = null;
        try {
            data = Parcel.obtain();
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 834, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCardType(int cardType) throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(cardType);
            MasterController.getInstance().request(this.packageName, 838, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    public int setCardType() throws RequestException {
        return this.setCardType(this.cardType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(int address, int len, BytesBuffer data) throws RequestException {
        Precondition.checkNotNull(data);
        Parcel d = null;
        Parcel reply = null;
        try {
            d = Parcel.obtain();
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(address);
            d.writeInt(len);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 836, d, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            data.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    public int read(int address, byte[] data, int offset, int len) throws RequestException {
        Precondition.checkNotNull(data);
        Precondition.checkArgument(data.length >= offset + len);
        BytesBuffer d = new BytesBuffer();
        if (data.length < offset + len) {
            return 139;
        }
        int ret = this.read(address, len, d);
        if (d.getData() != null) {
            System.arraycopy(d.getData(), 0, data, offset, len);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(int address, byte[] data) throws RequestException {
        Precondition.checkNotNull(data);
        Parcel d = null;
        Parcel reply = null;
        try {
            d = Parcel.obtain();
            d.writeByteArray(StringUtil.getGBK(this.deviceName));
            d.writeInt(address);
            d.writeByteArray(data);
            reply = Parcel.obtain();
            MasterController.getInstance().request(this.packageName, 837, d, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            d.recycle();
            reply.recycle();
        }
    }

    public int write(int address, byte[] data, int offset, int len) throws RequestException {
        Precondition.checkNotNull(data);
        Precondition.checkArgument(data.length >= offset + len);
        if (data.length < offset + len) {
            return 139;
        }
        return this.write(address, BytesUtil.subBytes(data, offset, len));
    }
}

