/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi.card;

import android.os.Parcel;
import com.landicorp.android.eptapi.card.InsertDriver;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.BytesBuffer;
import com.landicorp.android.eptapi.utils.BytesUtil;
import com.landicorp.android.eptapi.utils.IntegerBuffer;
import com.landicorp.android.eptapi.utils.Precondition;
import com.landicorp.android.eptapi.utils.StringUtil;

public class At1604Driver
implements InsertDriver {
    public static final int CARDTYPE_UNAVERAGE1604_CARD = 0;
    public static final int CARDTYPE_AVERAGE1604_CARD = 1;
    public static final int CARDTYPE_1601_CARD = 2;
    public static final int CARDTYPE_101_CARD = 3;
    public static final int CARDTYPE_102_CARD = 4;
    public static final int ERROR_NONE = 0;
    public static final int ERROR_NOPOWER = 227;
    public static final int ERROR_NOCARD = 251;
    public static final int ERROR_FAILED = 1;
    public static final int ERROR_ERRPARAM = 139;
    public static final int ERROR_OTHER = 143;
    public static final int ERROR_ERRTYPE = 194;
    public static final int ERROR_NOVERIFY = 231;
    public static final int KEYTYPE_1604_SC = 0;
    public static final int KEYTYPE_1604_SC1 = 2;
    public static final int KEYTYPE_1604_EZ1 = 3;
    public static final int KEYTYPE_1604_SC2 = 4;
    public static final int KEYTYPE_1604_EZ2 = 5;
    public static final int KEYTYPE_1604_SC3 = 6;
    public static final int KEYTYPE_1604_EZ3 = 7;
    public static final int KEYTYPE_1604_SC4 = 8;
    public static final int VOL_5 = 0;
    public static final int VOL_3 = 1;
    public static final int BLOW_TEST = 64;
    public static final int BLOW_UNTEST = 128;
    private String deviceName;
    private int cardType;
    private String packageName;

    public At1604Driver(int cardType) {
        this(cardType, "USERCARD");
    }

    public At1604Driver(int cardType, String deviceName) {
        this(MasterController.getInstance().getDefaultAppName(), cardType, deviceName);
    }

    public At1604Driver(String packageName, int cardType) {
        this(packageName, cardType, "USERCARD");
    }

    public At1604Driver(String clientPkgName, int cardType, String deviceName) {
        Precondition.checkNotEmpty(clientPkgName);
        Precondition.checkNotEmpty(deviceName);
        this.packageName = clientPkgName;
        this.cardType = cardType;
        this.deviceName = deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists() throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 771, data, reply);
            boolean bl = reply.readInt() == 1;
            return bl;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    @Override
    public void halt() throws RequestException {
        Parcel data = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 772, data);
        }
        finally {
            data.recycle();
        }
    }

    @Override
    public String getDriverName() {
        return "INSERT_AT1604";
    }

    @Override
    public String getDeviceName() {
        return this.deviceName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerUp(int vol, BytesBuffer atr) throws RequestException {
        Precondition.checkNotNull(atr);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(vol);
            MasterController.getInstance().request(this.packageName, 817, data, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            atr.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int powerDown() throws RequestException {
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            MasterController.getInstance().request(this.packageName, 818, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int verify(int keyType, byte[] password, IntegerBuffer errorCount) throws RequestException {
        Precondition.checkNotNull(password);
        Precondition.checkNotNull(errorCount);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(this.cardType);
            data.writeInt(keyType);
            data.writeByteArray(password);
            MasterController.getInstance().request(this.packageName, 819, data, reply);
            int ret = reply.readInt();
            errorCount.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int changeKey(int keyType, byte[] password) throws RequestException {
        Precondition.checkNotNull(password);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(this.cardType);
            data.writeInt(keyType);
            data.writeByteArray(password);
            MasterController.getInstance().request(this.packageName, 820, data, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readErrorCount(int keyType, IntegerBuffer errorCount) throws RequestException {
        Precondition.checkNotNull(errorCount);
        Parcel data = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            data.writeByteArray(StringUtil.getGBK(this.deviceName));
            data.writeInt(this.cardType);
            data.writeInt(keyType);
            MasterController.getInstance().request(this.packageName, 821, data, reply);
            int ret = reply.readInt();
            errorCount.setData(reply.readInt());
            int n = ret;
            return n;
        }
        finally {
            data.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(int address, int len, BytesBuffer data) throws RequestException {
        Precondition.checkArgument(len > 0);
        Precondition.checkNotNull(data);
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeByteArray(StringUtil.getGBK(this.deviceName));
            request.writeInt(address);
            request.writeInt(len);
            MasterController.getInstance().request(this.packageName, 822, request, reply);
            int ret = reply.readInt();
            if (ret != 0) {
                int n = ret;
                return n;
            }
            data.setData(reply.createByteArray());
            int n = ret;
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public int read(int address, byte[] data, int offset, int len) throws RequestException {
        Precondition.checkNotNull(data);
        Precondition.checkArgument(data.length >= offset + len);
        if (data.length < offset + len) {
            return 139;
        }
        BytesBuffer d = new BytesBuffer();
        int ret = this.read(address, len, d);
        if (d.getData() != null) {
            System.arraycopy(d.getData(), 0, data, offset, len);
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(int address, byte[] data) throws RequestException {
        Precondition.checkNotNull(data);
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeByteArray(StringUtil.getGBK(this.deviceName));
            request.writeInt(address);
            request.writeByteArray(data);
            MasterController.getInstance().request(this.packageName, 823, request, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    public int write(int address, byte[] data, int offset, int len) throws RequestException {
        Precondition.checkNotNull(data);
        Precondition.checkArgument(data.length >= offset + len);
        if (data.length < offset + len) {
            return 139;
        }
        return this.write(address, BytesUtil.subBytes(data, offset, len));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setCardType(int cardType) throws RequestException {
        this.cardType = cardType;
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeByteArray(StringUtil.getGBK(this.deviceName));
            request.writeInt(cardType);
            MasterController.getInstance().request(this.packageName, 824, request, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int blow(int cmf) throws RequestException {
        Parcel request = Parcel.obtain();
        Parcel reply = Parcel.obtain();
        try {
            request.writeByteArray(StringUtil.getGBK(this.deviceName));
            request.writeInt(this.cardType);
            request.writeInt(cmf);
            MasterController.getInstance().request(this.packageName, 825, request, reply);
            int n = reply.readInt();
            return n;
        }
        finally {
            request.recycle();
            reply.recycle();
        }
    }
}

