/*
 * Decompiled with CFR 0.152.
 */
package com.landicorp.android.eptapi;

import android.content.Context;
import android.text.TextUtils;
import com.landicorp.android.eptapi.exception.ReloginException;
import com.landicorp.android.eptapi.exception.RequestException;
import com.landicorp.android.eptapi.exception.ServiceOccupiedException;
import com.landicorp.android.eptapi.exception.UnsupportMultiProcess;
import com.landicorp.android.eptapi.service.MasterController;
import com.landicorp.android.eptapi.utils.Precondition;

public class DeviceService {
    private DeviceService() {
    }

    public static void init(Context context) {
        Precondition.checkNotNull(context);
        MasterController.getInstance().init(context);
    }

    public static void login(Context ctx) throws ServiceOccupiedException, ReloginException, UnsupportMultiProcess, RequestException {
        Precondition.checkNotNull(ctx);
        MasterController.getInstance().login(ctx);
    }

    public static void login(Context ctx, String clientPkgName) throws ServiceOccupiedException, ReloginException, UnsupportMultiProcess, RequestException {
        Precondition.checkNotNull(ctx);
        Precondition.checkNotEmpty(clientPkgName);
        MasterController.getInstance().login(ctx, clientPkgName);
    }

    public static void login(Context ctx, String[] useDeviceType) throws ServiceOccupiedException, ReloginException, UnsupportMultiProcess, RequestException {
        Precondition.checkNotNull(ctx);
        Precondition.checkNotNullEmpty(useDeviceType);
        MasterController.getInstance().login(ctx, useDeviceType);
    }

    public static void login(Context ctx, String clientPkgName, String[] useDeviceType) throws ServiceOccupiedException, ReloginException, UnsupportMultiProcess, RequestException {
        Precondition.checkNotNull(ctx);
        Precondition.checkNotEmpty(clientPkgName);
        Precondition.checkNotNullEmpty(useDeviceType);
        MasterController.getInstance().login(ctx, clientPkgName, useDeviceType);
    }

    public static void logout() {
        MasterController.getInstance().logout();
    }

    public static void logout(String clientPkgName) {
        Precondition.checkNotEmpty(clientPkgName);
        MasterController.getInstance().logout(clientPkgName);
    }

    public static boolean isLogin(String packageName) {
        if (TextUtils.isEmpty((CharSequence)packageName)) {
            return false;
        }
        return MasterController.getInstance().isClientLogin(packageName);
    }

    public static boolean isLogin() {
        Context context = MasterController.getInstance().getMasterControlContext();
        if (context == null) {
            return false;
        }
        return DeviceService.isLogin(context.getPackageName());
    }

    public static boolean switchDebug(int mode) {
        return MasterController.getInstance().switchDebug(mode);
    }
}

