/*
 * Decompiled with CFR 0.152.
 */
package com.jdcloud.sdk.client;

import com.jdcloud.sdk.JdcloudSdkException;

public interface Environment {
    public String getEndpoint();

    public String getRealEndPoints();

    public static class Builder {
        DefaultEnv env = new DefaultEnv();

        public Builder endpoint(String endpoint) {
            this.env.endpoint = endpoint;
            this.env.realEndPoints = null;
            return this;
        }

        public Builder endpoint(String endpoint, String realEndpoint) {
            this.env.endpoint = endpoint;
            this.env.realEndPoints = realEndpoint;
            return this;
        }

        public Environment build() {
            if (this.env.endpoint != null && this.env.endpoint.length() != 0) {
                return this.env;
            }
            throw new JdcloudSdkException("environment's endpoint not set");
        }

        private static class DefaultEnv
        implements Environment {
            private String endpoint;
            private String realEndPoints;

            private DefaultEnv() {
            }

            @Override
            public String getEndpoint() {
                return this.endpoint;
            }

            @Override
            public String getRealEndPoints() {
                return this.realEndPoints;
            }
        }
    }
}

