/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.util;

import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NumUtils {
    private static final Logger log = LoggerFactory.getLogger(NumUtils.class);

    private NumUtils() {
    }

    public static int intVal(String val) {
        return NumUtils.intVal(val, 0);
    }

    public static int intVal(String val, int defaultValue) {
        try {
            return NumberUtils.createNumber((String)val).intValue();
        }
        catch (Exception e) {
            log.warn("intVal(String, int) throw {}, return defaultValue = {}", (Object)e, (Object)defaultValue);
            return defaultValue;
        }
    }

    public static long longVal(String val) {
        return NumUtils.longVal(val, 0L);
    }

    public static long longVal(String val, long defaultValue) {
        try {
            return NumberUtils.createNumber((String)val).longValue();
        }
        catch (Exception e) {
            log.warn("longVal(String, int) throw {}, return defaultValue = {}", (Object)e, (Object)defaultValue);
            return defaultValue;
        }
    }
}

