/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.util;

import com.itxiaoer.commons.core.annotation.Nullable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public final class Lists {
    public static <E> List<E> newArrayList() {
        return new ArrayList();
    }

    public static <E> boolean iterable(List<E> list) {
        return list != null && !list.isEmpty();
    }

    public static <E> boolean iterable(E[] array) {
        return array != null && Array.getLength(array) != 0;
    }

    public static <E> List<E> empty(List<E> list) {
        return Optional.ofNullable(list).orElse(Lists.newArrayList());
    }

    public static <E> List<E> clean(List<E> list) {
        if (Lists.iterable(list)) {
            return list.stream().filter(e -> {
                if (Objects.isNull(e)) {
                    return false;
                }
                if (e instanceof Nullable) {
                    return !((Nullable)e).isNull();
                }
                return true;
            }).collect(Collectors.toList());
        }
        return list;
    }
}

