/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.page;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.itxiaoer.commons.core.page.ResponseCode;
import com.itxiaoer.commons.core.page.Responsive;
import java.io.Serializable;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class Response<T>
implements Responsive,
Serializable {
    private static final Logger log = LoggerFactory.getLogger(Response.class);
    private static final long serialVersionUID = -5413501204183149353L;
    private String code;
    private String msg;
    private T data;

    private Response() {
    }

    private Response(T data) {
        this(data, ResponseCode.SUCCESS.getCode(), ResponseCode.SUCCESS.getMessage());
    }

    private Response(String code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private Response(T data, String code, String msg) {
        this(code, msg);
        this.data = data;
    }

    public static Response<Boolean> ok() {
        return new Response<Boolean>(true);
    }

    public static <E> Response<E> ok(E data) {
        return new Response<E>(data);
    }

    public static <E> Response<E> ok(E data, String msg) {
        return new Response<E>(data, ResponseCode.SUCCESS.getCode(), msg);
    }

    public static <E> Response<E> failure() {
        return Response.failure(ResponseCode.SYSTEM_ERROR.getMessage());
    }

    public static <E> Response<E> failure(String msg) {
        return Response.failure(ResponseCode.SYSTEM_ERROR.getCode(), msg);
    }

    public static <E> Response<E> failure(String code, String msg) {
        return new Response(code, msg);
    }

    public static <E> Response<E> failure(ResponseCode responseCode) {
        return new Response(responseCode.getCode(), responseCode.getMessage());
    }

    public static <E> Response<E> build(E data, String code, String msg) {
        return new Response<E>(data, code, msg);
    }

    @Override
    @JsonIgnore
    public boolean isSuccess() {
        return Objects.equals(this.code, ResponseCode.SUCCESS.getCode());
    }

    public String getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Response)) {
            return false;
        }
        Response other = (Response)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$msg = this.getMsg();
        String other$msg = other.getMsg();
        if (this$msg == null ? other$msg != null : !this$msg.equals(other$msg)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Response;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $msg = this.getMsg();
        result = result * 59 + ($msg == null ? 43 : $msg.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "Response(code=" + this.getCode() + ", msg=" + this.getMsg() + ", data=" + this.getData() + ")";
    }
}

