/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.page;

import com.itxiaoer.commons.core.Exclude;
import com.itxiaoer.commons.core.Transfer;
import com.itxiaoer.commons.core.function.ThirdFunction;
import com.itxiaoer.commons.core.page.PageUtils;
import com.itxiaoer.commons.core.page.Sort;
import com.itxiaoer.commons.core.util.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Paging
implements Transfer<String, String> {
    private static final Logger log = LoggerFactory.getLogger(Paging.class);
    public static final String DESC = "desc";
    public static final String ASC = "asc";
    @Exclude
    private String page;
    @Exclude
    private String size;
    @Exclude
    private String sort;

    public Paging() {
    }

    private Paging(String page, String size, String sort) {
        this.page = page;
        this.size = size;
        this.sort = sort;
    }

    public Paging setSort(String name, String direction) {
        if (StringUtils.isBlank((CharSequence)this.sort)) {
            this.sort = name + "-" + direction;
            return this;
        }
        this.sort = this.sort + "," + name + "-" + direction;
        return this;
    }

    public static Paging of() {
        return new Paging();
    }

    public static Paging of(String page, String size) {
        return Paging.of(page, size, "");
    }

    public static Paging of(String page, String size, String sort) {
        return new Paging(page, size, sort);
    }

    public <R, F extends ThirdFunction<R, Integer, Integer, List<Sort>>> R get(F thirdFunction) {
        if (StringUtils.isBlank((CharSequence)this.sort)) {
            return thirdFunction.apply(PageUtils.page(this.page), PageUtils.size(this.size), Lists.newArrayList());
        }
        List sorts = Arrays.stream(this.sort.split(",")).map(s -> {
            try {
                String[] split = s.split("-");
                if (split.length == 1) {
                    return new Sort(this.apply(split[0]), DESC);
                }
                String direction = split[1];
                direction = !DESC.equalsIgnoreCase(direction) && !ASC.equalsIgnoreCase(direction) ? DESC : direction;
                return new Sort(this.apply(split[0]), direction);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }).collect(Collectors.toList());
        return thirdFunction.apply(PageUtils.page(this.page), PageUtils.size(this.size), sorts);
    }

    @Override
    public String apply(String name) {
        return name;
    }

    public static PagingBuilder builder() {
        return new PagingBuilder();
    }

    public String toString() {
        return "Paging(page=" + this.getPage() + ", size=" + this.getSize() + ", sort=" + this.getSort() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Paging)) {
            return false;
        }
        Paging other = (Paging)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$page = this.getPage();
        String other$page = other.getPage();
        if (this$page == null ? other$page != null : !this$page.equals(other$page)) {
            return false;
        }
        String this$size = this.getSize();
        String other$size = other.getSize();
        if (this$size == null ? other$size != null : !this$size.equals(other$size)) {
            return false;
        }
        String this$sort = this.getSort();
        String other$sort = other.getSort();
        return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Paging;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $page = this.getPage();
        result = result * 59 + ($page == null ? 43 : $page.hashCode());
        String $size = this.getSize();
        result = result * 59 + ($size == null ? 43 : $size.hashCode());
        String $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        return result;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getPage() {
        return this.page;
    }

    public void setSize(String size) {
        this.size = size;
    }

    public String getSize() {
        return this.size;
    }

    public void setSort(String sort) {
        this.sort = sort;
    }

    public String getSort() {
        return this.sort;
    }

    public static class PagingBuilder {
        private String page;
        private String size;
        private String sort;

        PagingBuilder() {
        }

        public PagingBuilder page(String page) {
            this.page = page;
            return this;
        }

        public PagingBuilder size(String size) {
            this.size = size;
            return this;
        }

        public PagingBuilder sort(String sort) {
            this.sort = sort;
            return this;
        }

        public Paging build() {
            return new Paging(this.page, this.size, this.sort);
        }

        public String toString() {
            return "Paging.PagingBuilder(page=" + this.page + ", size=" + this.size + ", sort=" + this.sort + ")";
        }
    }
}

