/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.page;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.itxiaoer.commons.core.util.Lists;
import java.io.Serializable;
import java.util.List;

public class PageResponse<T>
implements Serializable {
    private static final long serialVersionUID = -1816325636807144628L;
    private Long total;
    private List<T> data;

    private PageResponse() {
    }

    private PageResponse(Long total, List<T> data) {
        this.total = total;
        this.data = Lists.empty(data);
    }

    @JsonIgnore
    public boolean isEmpty() {
        return this.total == 0L;
    }

    public static <E> PageResponse<E> empty() {
        return new PageResponse(0L, Lists.newArrayList());
    }

    public static <E> PageResponse<E> apply(long total, List<E> data) {
        total = total < 0L ? 0L : total;
        return new PageResponse<E>(total, data);
    }

    public Long getTotal() {
        return this.total;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageResponse)) {
            return false;
        }
        PageResponse other = (PageResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$total = this.getTotal();
        Long other$total = other.getTotal();
        if (this$total == null ? other$total != null : !((Object)this$total).equals(other$total)) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $total = this.getTotal();
        result = result * 59 + ($total == null ? 43 : ((Object)$total).hashCode());
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "PageResponse(total=" + this.getTotal() + ", data=" + this.getData() + ")";
    }
}

