/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.json;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    public static <T> Optional<T> toBean(String json, Class<T> clazz) {
        if (StringUtils.isBlank((CharSequence)json)) {
            log.warn("json is blank. ");
            return Optional.empty();
        }
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return Optional.of(OBJECT_MAPPER.readValue(json, clazz));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public static <T> String toJson(T t) {
        if (Objects.isNull(t)) {
            log.warn("t is blank. ");
            return "";
        }
        try {
            return OBJECT_MAPPER.writeValueAsString(t);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return "";
        }
    }

    public static <T> Optional<T> toBean(Map<String, Object> params, Class<T> clazz) {
        if (Objects.isNull(params) || params.isEmpty()) {
            log.warn("param is blank. ");
            return Optional.empty();
        }
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return Optional.of(OBJECT_MAPPER.convertValue(params, clazz));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public static <E> Optional<Map<String, Object>> toMap(E e) {
        if (Objects.isNull(e)) {
            log.warn("param is blank. ");
            return Optional.empty();
        }
        try {
            OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            return Optional.of(OBJECT_MAPPER.convertValue(e, (TypeReference)new MapTypeReference()));
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            return Optional.empty();
        }
    }

    private static class MapTypeReference
    extends TypeReference<Map<String, Object>> {
        private MapTypeReference() {
        }
    }
}

