/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.date;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.List;

public final class LocalDateUtil {
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd";

    private LocalDateUtil() {
    }

    public static LocalDate firstDay() {
        return LocalDateUtil.firstDay(LocalDate.now());
    }

    public static LocalDate firstDay(LocalDate localDate) {
        return LocalDate.of(localDate.getYear(), localDate.getMonth(), 1);
    }

    public static LocalDate firstDay(String localDate) {
        LocalDate parse = LocalDateUtil.parse(localDate, DEFAULT_PATTERN);
        return LocalDate.of(parse.getYear(), parse.getMonth(), 1);
    }

    public static LocalDate lastDay() {
        return LocalDateUtil.lastDay(LocalDate.now());
    }

    public static LocalDate lastDay(LocalDate localDate) {
        return localDate.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate lastDay(String localDate) {
        LocalDate parse = LocalDateUtil.parse(localDate, DEFAULT_PATTERN);
        return parse.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDate addDays(String localDate, long days) {
        LocalDate parse = LocalDateUtil.parse(localDate, DEFAULT_PATTERN);
        return parse.plusDays(days);
    }

    public static String format(TemporalAccessor localDate, String pattern) {
        return DateTimeFormatter.ofPattern(pattern).format(localDate);
    }

    public static LocalDate parse(String localDate, String pattern) {
        return LocalDate.from(DateTimeFormatter.ofPattern(pattern).parse(localDate));
    }

    public static List<LocalDate> untilDays(String startDate, String endDate) {
        return LocalDateUtil.untilDays(LocalDateUtil.parse(startDate, DEFAULT_PATTERN), LocalDateUtil.parse(endDate, DEFAULT_PATTERN));
    }

    public static List<LocalDate> untilDays(String startDate, String endDate, String pattern) {
        return LocalDateUtil.untilDays(LocalDateUtil.parse(startDate, pattern), LocalDateUtil.parse(endDate, pattern));
    }

    public static List<LocalDate> untilDays(LocalDate startDate, LocalDate endDate) {
        long until = startDate.until(endDate, ChronoUnit.DAYS) + 1L;
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>();
        for (long i = 0L; i < until; ++i) {
            dates.add(startDate.plusDays(i));
        }
        return dates;
    }
}

