/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.date;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalAdjusters;

public final class LocalDateTimeUtil {
    public static final String DEFAULT_PATTERN = "yyyy-MM-dd HH:mm:ss";

    private LocalDateTimeUtil() {
    }

    public static LocalDateTime firstDay() {
        return LocalDateTimeUtil.firstDay(LocalDateTime.now());
    }

    public static LocalDateTime firstDay(LocalDateTime localDate) {
        return LocalDateTime.of(localDate.getYear(), localDate.getMonth(), 1, 0, 0, 0);
    }

    public static LocalDateTime firstDay(String localDate) {
        LocalDateTime parse = LocalDateTimeUtil.parse(localDate, DEFAULT_PATTERN);
        return LocalDateTime.of(parse.getYear(), parse.getMonth(), 1, 0, 0, 0);
    }

    public static LocalDateTime lastDay() {
        return LocalDateTimeUtil.lastDay(LocalDateTime.now());
    }

    public static LocalDateTime lastDay(LocalDateTime localDate) {
        return localDate.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime lastDay(String localDate) {
        LocalDateTime parse = LocalDateTimeUtil.parse(localDate, DEFAULT_PATTERN);
        return parse.with(TemporalAdjusters.lastDayOfMonth());
    }

    public static LocalDateTime addDays(String localDate, long days) {
        LocalDateTime parse = LocalDateTimeUtil.parse(localDate, DEFAULT_PATTERN);
        return parse.plusDays(days);
    }

    public static String format(TemporalAccessor localDate, String pattern) {
        return DateTimeFormatter.ofPattern(pattern).format(localDate);
    }

    public static LocalDateTime parse(String localDate, String pattern) {
        return LocalDateTime.from(DateTimeFormatter.ofPattern(pattern).parse(localDate));
    }
}

