/*
 * Decompiled with CFR 0.152.
 */
package com.itxiaoer.commons.core.beans;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.itxiaoer.commons.core.page.PageResponse;
import com.itxiaoer.commons.core.util.Lists;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cglib.beans.BeanCopier;

public final class ProcessUtils {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtils.class);
    private static Cache<String, BeanCopier> BEAN_COPIER_MAP = Caffeine.newBuilder().expireAfterWrite(30L, TimeUnit.MINUTES).expireAfterAccess(1L, TimeUnit.HOURS).build();

    private ProcessUtils() {
    }

    public static <T, R> List<R> processList(Class<R> clazz, List<T> src) {
        return ProcessUtils.processList(clazz, src, (r, s) -> {});
    }

    public static <T, R> List<R> processList(Class<R> clazz, List<T> src, BiConsumer<R, T> biConsumer) {
        if (!Lists.iterable(src)) {
            log.warn("the src argument must be not null, return empty list. ");
            return Lists.newArrayList();
        }
        return src.stream().map(e -> ProcessUtils.process(clazz, e, biConsumer)).collect(Collectors.toList());
    }

    public static <T, R> R process(Class<R> clazz, T src) {
        return (R)ProcessUtils.process(clazz, src, (r, s) -> {});
    }

    public static <T, R> R process(Class<R> clazz, T src, BiConsumer<R, T> biConsumer) {
        if (Objects.isNull(clazz)) {
            throw new IllegalArgumentException("the clazz argument must be not null");
        }
        if (Objects.isNull(src)) {
            log.warn("the src argument must be not null, return null. ");
            return null;
        }
        try {
            R r = clazz.newInstance();
            ProcessUtils.processObject(r, src, biConsumer);
            return r;
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static <T, R> void processObject(R r, T src) {
        ProcessUtils.processObject(r, src, (r1, src1) -> {});
    }

    public static <T, R> void processObject(R r, T src, BiConsumer<R, T> biConsumer) {
        try {
            String beanKey = ProcessUtils.generateKey(src.getClass(), r.getClass());
            BeanCopier copier = (BeanCopier)BEAN_COPIER_MAP.getIfPresent((Object)beanKey);
            if (copier == null) {
                copier = BeanCopier.create(src.getClass(), r.getClass(), (boolean)false);
                BEAN_COPIER_MAP.put((Object)beanKey, (Object)copier);
            }
            copier.copy(src, r, null);
            if (biConsumer != null) {
                biConsumer.accept(r, src);
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static <T, R> PageResponse<R> processPage(Class<R> clazz, PageResponse<T> pageResponse) {
        return ProcessUtils.processPage(clazz, pageResponse, (r1, src1) -> {});
    }

    public static <T, R> PageResponse<R> processPage(Class<R> clazz, PageResponse<T> pageResponse, BiConsumer<R, T> biConsumer) {
        if (pageResponse == null || pageResponse.isEmpty()) {
            return PageResponse.empty();
        }
        return PageResponse.apply(pageResponse.getTotal(), ProcessUtils.processList(clazz, pageResponse.getData(), biConsumer));
    }

    private static String generateKey(Class<?> class1, Class<?> class2) {
        return String.join((CharSequence)",", class1.toString(), class2.toString());
    }
}

