/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.kernel.pdf.function;

import com.itextpdf.kernel.exceptions.PdfException;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.function.AbstractPdfFunction;
import com.itextpdf.kernel.pdf.function.utils.AbstractSampleExtractor;
import java.util.Arrays;

public class PdfType0Function
extends AbstractPdfFunction<PdfStream> {
    private int[] size;
    private int order;
    private int[] encode;
    private double[] decode;
    private int bitsPerSample;
    private AbstractSampleExtractor sampleExtractor = null;
    private byte[] samples;
    private int outputDimension;
    private long decodeLimit;
    private boolean isValidated = false;
    private String errorMessage = null;
    private double[][] derivatives = null;

    public PdfType0Function(PdfStream pdfObject) {
        super(pdfObject);
        PdfArray sizeObj = pdfObject.getAsArray(PdfName.Size);
        if (super.getDomain() == null || super.getRange() == null || sizeObj == null) {
            this.setErrorMessage("Domain, range and size must be not null");
            return;
        }
        this.size = sizeObj.toIntArray();
        PdfNumber orderObj = pdfObject.getAsNumber(PdfName.Order);
        this.order = orderObj == null ? 1 : orderObj.intValue();
        PdfArray encodeObj = pdfObject.getAsArray(PdfName.Encode);
        this.initializeEncoding(encodeObj);
        PdfArray decodeObj = pdfObject.getAsArray(PdfName.Decode);
        this.decode = decodeObj == null ? super.getRange() : decodeObj.toDoubleArray();
        this.outputDimension = super.getRange().length >> 1;
        PdfNumber bitsPerSampleObj = pdfObject.getAsNumber(PdfName.BitsPerSample);
        this.bitsPerSample = bitsPerSampleObj == null ? 0 : bitsPerSampleObj.intValue();
        this.decodeLimit = (1L << this.bitsPerSample) - 1L;
        this.samples = pdfObject.getBytes(true);
        try {
            this.sampleExtractor = AbstractSampleExtractor.createExtractor(this.bitsPerSample);
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public PdfType0Function(double[] domain, int[] size, double[] range, int order, int bitsPerSample, byte[] samples) {
        this(domain, size, range, order, null, null, bitsPerSample, samples);
    }

    public PdfType0Function(double[] domain, int[] size, double[] range, int order, int[] encode, double[] decode, int bitsPerSample, byte[] samples) {
        super(new PdfStream(samples), 0, domain, range);
        if (size != null) {
            this.size = Arrays.copyOf(size, size.length);
        }
        if (super.getDomain() == null || super.getRange() == null || size == null) {
            this.setErrorMessage("Domain, range and size must be not null");
            return;
        }
        this.size = Arrays.copyOf(size, size.length);
        ((PdfStream)super.getPdfObject()).put(PdfName.Size, new PdfArray(size));
        this.order = order;
        ((PdfStream)super.getPdfObject()).put(PdfName.Order, new PdfNumber(order));
        this.initializeEncoding(encode);
        ((PdfStream)super.getPdfObject()).put(PdfName.Encode, new PdfArray(this.encode));
        this.decode = decode == null ? Arrays.copyOf(range, range.length) : Arrays.copyOf(decode, decode.length);
        ((PdfStream)super.getPdfObject()).put(PdfName.Decode, new PdfArray(this.decode));
        this.bitsPerSample = bitsPerSample;
        ((PdfStream)super.getPdfObject()).put(PdfName.BitsPerSample, new PdfNumber(bitsPerSample));
        this.outputDimension = super.getRange().length >> 1;
        this.decodeLimit = (1L << bitsPerSample) - 1L;
        this.samples = Arrays.copyOf(samples, samples.length);
        try {
            this.sampleExtractor = AbstractSampleExtractor.createExtractor(bitsPerSample);
        }
        catch (IllegalArgumentException e) {
            this.setErrorMessage(e.getMessage());
        }
        if (this.isInvalid()) {
            throw new IllegalArgumentException(this.errorMessage);
        }
    }

    public int getOrder() {
        return this.order;
    }

    public void setOrder(int order) {
        this.order = order;
        ((PdfStream)this.getPdfObject()).put(PdfName.Order, new PdfNumber(order));
        this.isValidated = false;
    }

    public int[] getSize() {
        return this.size;
    }

    public void setSize(int[] size) {
        this.size = size;
        ((PdfStream)this.getPdfObject()).put(PdfName.Size, new PdfArray(size));
        this.isValidated = false;
    }

    public int[] getEncode() {
        return this.encode;
    }

    public void setEncode(int[] encode) {
        this.initializeEncoding(encode);
        ((PdfStream)this.getPdfObject()).put(PdfName.Encode, new PdfArray(encode));
        this.isValidated = false;
    }

    public double[] getDecode() {
        return this.decode;
    }

    public void setDecode(double[] decode) {
        this.decode = decode;
        ((PdfStream)this.getPdfObject()).put(PdfName.Decode, new PdfArray(decode));
        this.isValidated = false;
    }

    @Override
    public boolean checkCompatibilityWithColorSpace(PdfColorSpace alternateSpace) {
        return this.getInputSize() == 1 && this.getOutputSize() == alternateSpace.getNumberOfComponents();
    }

    @Override
    public void setDomain(double[] domain) {
        super.setDomain(domain);
        this.isValidated = false;
    }

    @Override
    public void setRange(double[] range) {
        super.setRange(range);
        this.isValidated = false;
    }

    @Override
    public double[] calculate(double[] input) {
        if (this.isInvalid()) {
            throw new IllegalArgumentException(this.errorMessage);
        }
        double[] normal = PdfType0Function.normalize(input, this.getDomain());
        int[] floor = PdfType0Function.getFloor(normal, this.encode);
        double[] result = this.order == 3 && this.size.length == 1 && this.encode[1] - this.encode[0] > 1 ? this.interpolateByCubicSpline(normal[0], floor[0]) : this.interpolate(normal, floor);
        return PdfType0Function.clip(result, this.getRange());
    }

    @Override
    protected boolean isWrappedObjectMustBeIndirect() {
        return false;
    }

    static double encode(double normal, int encodeMin, int encodeMax) {
        return (double)encodeMin + normal * (double)(encodeMax - encodeMin);
    }

    static int[] getFloor(double[] normal, int[] encode) {
        int[] result = new int[normal.length];
        for (int i = 0; i < normal.length; ++i) {
            int j = i << 1;
            int floor = (int)PdfType0Function.encode(normal[i], encode[j], encode[j + 1]);
            result[i] = Math.min(Math.max(0, encode[j + 1] - 1), floor);
        }
        return result;
    }

    static int getSamplePosition(int[] sample, int[] size) {
        int position = sample[size.length - 1];
        for (int i = size.length - 2; i >= 0; --i) {
            position = sample[i] + size[i] * position;
        }
        return position;
    }

    static double[] getFloorWeights(double[] normal, int[] encode) {
        double[] result = new double[normal.length];
        for (int i = 0; i < normal.length; ++i) {
            result[i] = PdfType0Function.getFloorWeight(normal[i], encode[2 * i], encode[2 * i + 1]);
        }
        return result;
    }

    static double getFloorWeight(double normal, int encodeMin, int encodeMax) {
        double value = PdfType0Function.encode(normal, encodeMin, encodeMax);
        return value - (double)Math.min(encodeMax - 1, (int)value);
    }

    static double[] specialSweepMethod(double[] f) {
        int i;
        assert (f.length > 0);
        double[] x = new double[f.length + 2];
        x[1] = 4.0;
        for (i = 1; i < f.length; ++i) {
            x[0] = 1.0 / x[i];
            x[i + 1] = 4.0 - x[0];
            f[i] = f[i] - x[0] * f[i - 1];
        }
        x[f.length] = f[f.length - 1] / x[f.length];
        for (i = f.length - 1; i > 0; --i) {
            x[i] = (f[i - 1] - x[i + 1]) / x[i];
        }
        x[x.length - 1] = 0.0;
        x[0] = 0.0;
        return x;
    }

    private void initializeEncoding(PdfArray encodeObj) {
        if (encodeObj == null) {
            this.encode = this.getDefaultEncoding();
        } else {
            this.encode = encodeObj.toIntArray();
            for (int i = 0; i < this.size.length; ++i) {
                int j = i << 1;
                this.encode[j] = Math.max(0, this.encode[j]);
                this.encode[j + 1] = Math.min(this.size[i] - 1, this.encode[j + 1]);
            }
        }
    }

    private void initializeEncoding(int[] encode) {
        if (encode == null) {
            this.encode = this.getDefaultEncoding();
        } else {
            this.encode = new int[encode.length];
            for (int i = 0; i < this.size.length; ++i) {
                int j = i << 1;
                this.encode[j] = Math.max(0, encode[j]);
                this.encode[j + 1] = Math.min(this.size[i] - 1, encode[j + 1]);
            }
        }
    }

    private int[] getDefaultEncoding() {
        int[] result = new int[this.size.length << 1];
        int i = 0;
        for (int sizeItem : this.size) {
            result[i++] = 0;
            result[i++] = sizeItem - 1;
        }
        return result;
    }

    private double[] interpolate(double[] normal, int[] floor) {
        int floorPosition = PdfType0Function.getSamplePosition(floor, this.size);
        double[] x = PdfType0Function.getFloorWeights(normal, this.encode);
        int[] steps = this.getInputDimensionSteps();
        double[] result = new double[this.outputDimension];
        switch (this.order) {
            case 1: {
                for (int dim = 0; dim < this.outputDimension; ++dim) {
                    result[dim] = this.interpolateOrder1(x, floorPosition, steps, steps.length, dim);
                }
                return result;
            }
            case 3: {
                for (int dim = 0; dim < this.outputDimension; ++dim) {
                    result[dim] = this.interpolateOrder3(x, floor, floorPosition, steps, steps.length, dim);
                }
                return result;
            }
        }
        throw new PdfException("Order must be equal to 1 or 3");
    }

    private double interpolateOrder1(double[] x, int floorPosition, int[] steps, int inDim, int outDim) {
        if (inDim == 0) {
            return this.getValue(outDim, floorPosition);
        }
        int step = steps[--inDim];
        int encodeIndex = inDim << 1;
        double value0 = this.interpolateOrder1(x, floorPosition, steps, inDim, outDim);
        if (this.encode[encodeIndex] == this.encode[encodeIndex + 1]) {
            return value0;
        }
        int ceilPosition = floorPosition + step;
        double value1 = this.interpolateOrder1(x, ceilPosition, steps, inDim, outDim);
        return PdfType0Function.calculateLinearInterpolationFormula(x[inDim], value0, value1);
    }

    private double interpolateOrder3(double[] x, int[] floor, int floorPosition, int[] steps, int inDim, int outDim) {
        if (inDim == 0) {
            return this.getValue(outDim, floorPosition);
        }
        int step = steps[--inDim];
        int encodeIndex = inDim << 1;
        double value1 = this.interpolateOrder3(x, floor, floorPosition, steps, inDim, outDim);
        if (this.encode[encodeIndex] == this.encode[encodeIndex + 1]) {
            return value1;
        }
        int ceilPosition = floorPosition + step;
        double value2 = this.interpolateOrder3(x, floor, ceilPosition, steps, inDim, outDim);
        if (this.encode[encodeIndex + 1] - this.encode[encodeIndex] == 1) {
            return PdfType0Function.calculateLinearInterpolationFormula(x[inDim], value1, value2);
        }
        double value0 = floor[inDim] > this.encode[encodeIndex] ? this.interpolateOrder3(x, floor, floorPosition - step, steps, inDim, outDim) : 2.0 * value1 - value2;
        double value3 = floor[inDim] < this.encode[encodeIndex + 1] - this.encode[encodeIndex] - 1 ? this.interpolateOrder3(x, floor, ceilPosition + step, steps, inDim, outDim) : 2.0 * value2 - value1;
        return PdfType0Function.calculateCubicInterpolationFormula(x[inDim], value0, value1, value2, value3);
    }

    private double[] interpolateByCubicSpline(double normal, int position) {
        if (this.derivatives == null) {
            this.calculateSecondDerivatives();
        }
        double x = PdfType0Function.getFloorWeight(normal, this.encode[0], this.encode[1]);
        return this.calculateCubicSplineFormula(x, position);
    }

    private double[] calculateCubicSplineFormula(double x, int position) {
        double[] result = new double[this.outputDimension];
        for (int dim = 0; dim < this.outputDimension; ++dim) {
            result[dim] = PdfType0Function.calculateCubicSplineFormula(x, this.getValue(dim, position), this.getValue(dim, position + 1), this.derivatives[dim][position - this.encode[0]], this.derivatives[dim][position - this.encode[0] + 1]);
        }
        return result;
    }

    private void calculateSecondDerivatives() {
        this.derivatives = new double[this.outputDimension][];
        for (int dim = 0; dim < this.outputDimension; ++dim) {
            double[] f = new double[this.encode[1] - this.encode[0] - 1];
            for (int pos = this.encode[0]; pos < this.encode[1] - 1; ++pos) {
                f[pos - this.encode[0]] = 6.0 * (this.getValue(dim, pos) - 2.0 * this.getValue(dim, pos + 1) + this.getValue(dim, pos + 2));
            }
            this.derivatives[dim] = PdfType0Function.specialSweepMethod(f);
        }
    }

    private double getValue(int dim, int pos) {
        return this.decode(this.sampleExtractor.extract(this.samples, dim + this.outputDimension * pos), dim);
    }

    private int[] getInputDimensionSteps() {
        int[] steps = new int[this.size.length];
        steps[0] = 1;
        for (int i = 1; i < steps.length; ++i) {
            steps[i] = steps[i - 1] * this.size[i - 1];
        }
        return steps;
    }

    private double decode(long x, int dim) {
        int index = dim << 1;
        return this.decode[index] + (this.decode[index + 1] - this.decode[index]) * (double)x / (double)this.decodeLimit;
    }

    private void setErrorMessage(String message) {
        this.errorMessage = message;
        this.isValidated = true;
    }

    private boolean isInvalid() {
        if (this.isValidated) {
            return this.errorMessage != null;
        }
        if (super.getDomain() == null || super.getRange() == null || this.size == null) {
            this.setErrorMessage("Domain, range and size must be not null");
            return true;
        }
        if (this.order != 1 && this.order != 3) {
            this.setErrorMessage("Order must be equal to 1 or 3");
            return true;
        }
        if (this.getDomain().length == 0 || this.getDomain().length % 2 == 1) {
            this.setErrorMessage("Invalid domain for PDF function of type 0");
            return true;
        }
        if (this.getRange().length == 0 || this.getRange().length % 2 == 1) {
            this.setErrorMessage("Invalid encode array for PDF function of type 0");
            return true;
        }
        int inputDimension = this.getDomain().length >> 1;
        if (this.size == null || this.size.length != inputDimension) {
            this.setErrorMessage("Invalid size array for PDF function of type 0");
            return true;
        }
        for (int s : this.size) {
            if (s > 0) continue;
            this.setErrorMessage("Invalid size array for PDF function of type 0");
            return true;
        }
        if (this.encode.length != this.getDomain().length) {
            this.setErrorMessage("Invalid encode array for PDF function of type 0");
            return true;
        }
        for (int i = 0; i < this.encode.length; i += 2) {
            if (this.encode[i + 1] >= this.encode[i]) continue;
            this.setErrorMessage("Invalid encode array for PDF function of type 0");
            return true;
        }
        if (this.decode.length != this.getRange().length) {
            this.setErrorMessage("Invalid decode array for PDF function of type 0");
            return true;
        }
        int samplesMinLength = (Arrays.stream(this.size).reduce(this.outputDimension * this.bitsPerSample, (x, y) -> x * y) + 7) / 8;
        if (this.samples == null || this.samples.length < samplesMinLength) {
            this.setErrorMessage("Invalid samples array for PDF function of type 0");
            return true;
        }
        this.isValidated = true;
        return false;
    }

    private static double calculateLinearInterpolationFormula(double x, double f0, double f1) {
        return (1.0 - x) * f0 + x * f1;
    }

    private static double calculateCubicInterpolationFormula(double x, double f0, double f1, double f2, double f3) {
        return f1 + 0.5 * x * (f2 - f0 + x * (2.0 * f0 - 5.0 * f1 + 4.0 * f2 - f3 + x * (3.0 * (f1 - f2) + f3 - f0)));
    }

    private static double calculateCubicSplineFormula(double x, double f0, double f1, double d0, double d1) {
        double y = 1.0 - x;
        return f1 * x + f0 * y - x * y * (d0 * (y + 1.0) + d1 * (x + 1.0)) / 6.0;
    }
}

