/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.ui.scan.analyzer;

import android.media.Image;
import com.fshows.android.stark.utils.FsLogUtil;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/huike/nova/sdk/ui/scan/analyzer/YuvFormatConverter;", "", "()V", "LogTag", "", "readYuvDataToBuffer", "", "image", "Landroid/media/Image;", "data", "", "format", "", "nova-sdk_debug"})
public final class YuvFormatConverter {
    @NotNull
    public static final YuvFormatConverter INSTANCE = new YuvFormatConverter();
    @NotNull
    private static final String LogTag = ":= YuvFormatConverter";

    private YuvFormatConverter() {
    }

    private final boolean readYuvDataToBuffer(Image image, byte[] data) {
        if (image.getFormat() != 35) {
            FsLogUtil.error((String)LogTag, (String)"format error, only support ImageFormat.YUV_420_888", (Object[])new Object[0]);
            return false;
        }
        int imageWidth = image.getWidth();
        int imageHeight = image.getHeight();
        Image.Plane[] planes = image.getPlanes();
        int offset = 0;
        int n = planes.length;
        for (int plane = 0; plane < n; ++plane) {
            ByteBuffer buffer;
            int planeHeight;
            if (planes[plane].getBuffer() == null) {
                return false;
            }
            int rowStride = planes[plane].getRowStride();
            int pixelStride = planes[plane].getPixelStride();
            int planeWidth = plane == 0 ? imageWidth : imageWidth / 2;
            int n2 = planeHeight = plane == 0 ? imageHeight : imageHeight / 2;
            if (pixelStride == 1 && rowStride == planeWidth) {
                buffer.get(data, offset, planeWidth * planeHeight);
                offset += planeWidth * planeHeight;
                continue;
            }
            byte[] rowData = new byte[rowStride];
            int colOffset = 0;
            int n3 = planeHeight - 1;
            for (int row = 0; row < n3; ++row) {
                colOffset = 0;
                buffer.get(rowData, 0, rowStride);
                for (int col = 0; col < planeWidth; ++col) {
                    data[offset++] = rowData[colOffset];
                    colOffset += pixelStride;
                }
            }
            colOffset = 0;
            buffer.get(rowData, 0, Math.min(rowStride, buffer.remaining()));
            for (int col = 0; col < planeWidth; ++col) {
                data[offset++] = rowData[colOffset];
                colOffset += pixelStride;
            }
        }
        return true;
    }

    public final boolean readYuvDataToBuffer(@NotNull Image image, int format, @NotNull byte[] data) {
        Object $this$readYuvDataToBuffer_u24lambda_u241;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (!(format == 17 || format == 842094169)) {
            boolean $i$a$-require-YuvFormatConverter$readYuvDataToBuffer$22 = false;
            String $i$a$-require-YuvFormatConverter$readYuvDataToBuffer$22 = "output only support ImageFormat.NV21 and ImageFormat.YV12 for now";
            throw new IllegalArgumentException($i$a$-require-YuvFormatConverter$readYuvDataToBuffer$22.toString());
        }
        Object $i$a$-require-YuvFormatConverter$readYuvDataToBuffer$22 = this;
        try {
            $this$readYuvDataToBuffer_u24lambda_u241 = $i$a$-require-YuvFormatConverter$readYuvDataToBuffer$22;
            boolean bl = false;
            $this$readYuvDataToBuffer_u24lambda_u241 = Result.constructor-impl((Object)super.readYuvDataToBuffer(image, data));
        }
        catch (Throwable bl) {
            $this$readYuvDataToBuffer_u24lambda_u241 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)bl));
        }
        $i$a$-require-YuvFormatConverter$readYuvDataToBuffer$22 = $this$readYuvDataToBuffer_u24lambda_u241;
        $this$readYuvDataToBuffer_u24lambda_u241 = false;
        boolean result = (Boolean)(Result.isFailure-impl((Object)$i$a$-require-YuvFormatConverter$readYuvDataToBuffer$22) ? $this$readYuvDataToBuffer_u24lambda_u241 : $i$a$-require-YuvFormatConverter$readYuvDataToBuffer$22);
        if (!result) {
            return false;
        }
        switch (format) {
            case 17: {
                int uvOffset;
                int size = data.length;
                byte[] uv = new byte[size / 3];
                int uOffset = size / 6 * 4;
                int vOffset = size / 6 * 5;
                IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)0, (int)(uv.length - 1))), (int)2);
                int i2 = intProgression.getFirst();
                int n = intProgression.getLast();
                int n2 = intProgression.getStep();
                if (n2 > 0 && i2 <= n || n2 < 0 && n <= i2) {
                    while (true) {
                        uv[i2] = data[vOffset++];
                        uv[i2 + 1] = data[uOffset++];
                        if (i2 == n) break;
                        i2 += n2;
                    }
                }
                for (i2 = uvOffset = size / 3 * 2; i2 < size; ++i2) {
                    data[i2] = uv[i2 - uvOffset];
                }
                break;
            }
            case 842094169: {
                int size = data.length;
                byte[] tmp = new byte[size / 6];
                int uOffset = size / 6 * 4;
                int vOffset = size / 6 * 5;
                System.arraycopy(data, uOffset, tmp, 0, tmp.length);
                System.arraycopy(data, vOffset, data, uOffset, tmp.length);
                System.arraycopy(tmp, 0, data, vOffset, tmp.length);
            }
        }
        return true;
    }
}

