/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.ui.base;

import androidx.lifecycle.MutableLiveData;
import androidx.lifecycle.ViewModel;
import com.android.volley.Request;
import com.huike.nova.sdk.api.VolleyRequestQueueKt;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\f\u001a\u00020\u000bH\u0004J\u0006\u0010\r\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u000eH\u0014J\u0006\u0010\u0010\u001a\u00020\u000eJ\n\u0010\u0011\u001a\u00020\u000e*\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u000e\"\u0004\b\u0000\u0010\u0014*\b\u0012\u0004\u0012\u0002H\u00140\u0015R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/huike/nova/sdk/ui/base/NovaSdkBaseViewModel;", "Landroidx/lifecycle/ViewModel;", "()V", "compositeDisposable", "Lio/reactivex/disposables/CompositeDisposable;", "loadingStatus", "Landroidx/lifecycle/MutableLiveData;", "", "getLoadingStatus", "()Landroidx/lifecycle/MutableLiveData;", "uuid", "", "guid", "hideLoading", "", "onCleared", "showLoading", "addDisposable", "Lio/reactivex/disposables/Disposable;", "addToRequestQueue", "T", "Lcom/android/volley/Request;", "nova-sdk_debug"})
public class NovaSdkBaseViewModel
extends ViewModel {
    @NotNull
    private final MutableLiveData<Integer> loadingStatus;
    @NotNull
    private final CompositeDisposable compositeDisposable;
    @NotNull
    private final String uuid;

    public NovaSdkBaseViewModel() {
        VolleyRequestQueueKt.checkVolleyDebugLogEnable();
        this.loadingStatus = new MutableLiveData();
        this.compositeDisposable = new CompositeDisposable();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.uuid = string;
    }

    @NotNull
    public final MutableLiveData<Integer> getLoadingStatus() {
        return this.loadingStatus;
    }

    public final <T> void addToRequestQueue(@NotNull Request<T> $this$addToRequestQueue) {
        Intrinsics.checkNotNullParameter($this$addToRequestQueue, (String)"<this>");
        $this$addToRequestQueue.setTag((Object)this.uuid);
        VolleyRequestQueueKt.getGlobalRequestQueue().add($this$addToRequestQueue);
    }

    @NotNull
    protected final String guid() {
        return this.uuid;
    }

    protected void onCleared() {
        super.onCleared();
        this.compositeDisposable.dispose();
        VolleyRequestQueueKt.getGlobalRequestQueue().cancelAll((Object)this.uuid);
    }

    public final void showLoading() {
        this.loadingStatus.postValue((Object)0);
    }

    public final void hideLoading() {
        this.loadingStatus.postValue((Object)1);
    }

    public final void addDisposable(@NotNull Disposable $this$addDisposable) {
        Intrinsics.checkNotNullParameter((Object)$this$addDisposable, (String)"<this>");
        this.compositeDisposable.add($this$addDisposable);
    }
}

