/*
 * Decompiled with CFR 0.152.
 */
package com.huike.nova.sdk.widget;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.method.LinkMovementMethod;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BulletSpan;
import android.text.style.ClickableSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.ImageSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.StyleSpan;
import android.text.style.SubscriptSpan;
import android.text.style.SuperscriptSpan;
import android.text.style.TypefaceSpan;
import android.text.style.UnderlineSpan;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.widget.TextView;
import androidx.annotation.ColorInt;
import androidx.annotation.ColorRes;
import androidx.annotation.DimenRes;
import androidx.annotation.StringRes;
import androidx.core.content.ContextCompat;
import com.huike.nova.sdk.ext.ContextExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0016\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u0015\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u0010\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0014\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0012J\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u0017\u001a\u00020\u0000J\u001f\u0010\u0018\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u00062\n\b\u0001\u0010\u001a\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u001bJ\u000e\u0010\u001c\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001d\u001a\u00020\u0012J\u001c\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0000J\u000e\u0010!\u001a\u00020\u00002\u0006\u0010\u0011\u001a\u00020\u0012J\u0006\u0010\"\u001a\u00020\u0000J\u001c\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'J&\u0010#\u001a\u00020\u00002\u0006\u0010$\u001a\u00020%2\f\u0010&\u001a\b\u0012\u0004\u0012\u00020(0'2\b\b\u0002\u0010)\u001a\u00020*J\u0016\u0010+\u001a\u00020\u00002\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u0006J \u0010.\u001a\u00020\u00002\u0018\u0010.\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\r0\fJ\u000e\u0010/\u001a\u00020\u00002\u0006\u00100\u001a\u00020\u0006J\u000e\u00101\u001a\u00020\u00002\u0006\u00102\u001a\u00020\u0006J\u000e\u00103\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u0006J\u0010\u00104\u001a\u00020\u00002\b\b\u0001\u00102\u001a\u00020\u0006J\u0018\u00105\u001a\u00020\u00002\u0006\u00103\u001a\u00020\u00062\b\b\u0002\u00106\u001a\u00020\u0006J\u0006\u00107\u001a\u00020\u0000J\u0006\u00108\u001a\u00020\u0000J\u0006\u00109\u001a\u00020\u0000J\u0010\u0010\u000f\u001a\u00020\u00002\b\b\u0001\u0010\u001a\u001a\u00020\u0006J\u0006\u0010:\u001a\u00020\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0006X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006;"}, d2={"Lcom/huike/nova/sdk/widget/NovaSdkSpannableString;", "Landroid/text/SpannableString;", "text", "", "(Ljava/lang/CharSequence;)V", "stringResId", "", "(I)V", "context", "Landroid/content/Context;", "(Landroid/content/Context;Ljava/lang/CharSequence;)V", "rangeList", "", "Lkotlin/Pair;", "spanMode", "textColor", "all", "target", "", "between", "startText", "endText", "bold", "bold_italic", "bullet", "dp", "colorRes", "(ILjava/lang/Integer;)Lcom/huike/nova/sdk/widget/NovaSdkSpannableString;", "first", "font", "indexesOf", "src", "italic", "last", "normal", "onClick", "textView", "Landroid/widget/TextView;", "onTextClickListener", "Lkotlin/Function0;", "", "disableUnderLine", "", "range", "from", "to", "ranges", "scaleSize", "proportion", "setTextIcon", "resourceId", "size", "sizeByRes", "sizeSpecUnit", "unit", "strikethrough", "subscript", "superscript", "underline", "nova-sdk_debug"})
public final class NovaSdkSpannableString
extends SpannableString {
    @NotNull
    private final Context context;
    private final int spanMode;
    @NotNull
    private final List<Pair<Integer, Integer>> rangeList;
    private int textColor;

    public NovaSdkSpannableString(@NotNull Context context, @NotNull CharSequence text) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        super(text);
        this.context = context;
        this.spanMode = 33;
        Object[] objectArray = new Pair[]{new Pair((Object)0, (Object)text.length())};
        this.rangeList = CollectionsKt.mutableListOf((Object[])objectArray);
    }

    public NovaSdkSpannableString(@Nullable CharSequence text) {
        Context context = ContextExtKt.applicationContext();
        CharSequence charSequence = text;
        if (charSequence == null) {
            charSequence = "";
        }
        this(context, charSequence);
    }

    public NovaSdkSpannableString(@StringRes int stringResId) {
        Context context = ContextExtKt.applicationContext();
        CharSequence charSequence = ContextExtKt.applicationContext().getText(stringResId);
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"applicationContext().getText(stringResId)");
        this(context, charSequence);
    }

    @NotNull
    public final NovaSdkSpannableString first(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.rangeList.clear();
        String string2 = this.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        int index = StringsKt.indexOf$default((CharSequence)string2, (String)target, (int)0, (boolean)false, (int)6, null);
        Pair range = new Pair((Object)index, (Object)(index + target.length()));
        this.rangeList.add((Pair<Integer, Integer>)range);
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString last(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.rangeList.clear();
        String string2 = this.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        int index = StringsKt.lastIndexOf$default((CharSequence)string2, (String)target, (int)0, (boolean)false, (int)6, null);
        Pair range = new Pair((Object)index, (Object)(index + target.length()));
        this.rangeList.add((Pair<Integer, Integer>)range);
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString all(@NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.rangeList.clear();
        String string2 = this.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        List<Integer> indexes = this.indexesOf(string2, target);
        Iterator<Integer> iterator = indexes.iterator();
        while (iterator.hasNext()) {
            int index = ((Number)iterator.next()).intValue();
            Pair range = new Pair((Object)index, (Object)(index + target.length()));
            this.rangeList.add((Pair<Integer, Integer>)range);
        }
        return this;
    }

    @NotNull
    public final List<Integer> indexesOf(@NotNull String src, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)src, (String)"src");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        List positions = new ArrayList();
        int index = StringsKt.indexOf$default((CharSequence)src, (String)target, (int)0, (boolean)false, (int)6, null);
        while (index >= 0) {
            positions.add(index);
            index = StringsKt.indexOf$default((CharSequence)src, (String)target, (int)(index + 1), (boolean)false, (int)4, null);
        }
        return positions;
    }

    @NotNull
    public final NovaSdkSpannableString range(int from, int to) {
        this.rangeList.clear();
        Pair range = new Pair((Object)from, (Object)(to + 1));
        this.rangeList.add((Pair<Integer, Integer>)range);
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString ranges(@NotNull List<Pair<Integer, Integer>> ranges) {
        Intrinsics.checkNotNullParameter(ranges, (String)"ranges");
        this.rangeList.clear();
        this.rangeList.addAll((Collection<Pair<Integer, Integer>>)ranges);
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString between(@NotNull String startText, @NotNull String endText) {
        Intrinsics.checkNotNullParameter((Object)startText, (String)"startText");
        Intrinsics.checkNotNullParameter((Object)endText, (String)"endText");
        this.rangeList.clear();
        String string2 = this.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString()");
        int startIndex = StringsKt.indexOf$default((CharSequence)string2, (String)startText, (int)0, (boolean)false, (int)6, null) + startText.length() + 1;
        String string3 = this.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString()");
        int endIndex = StringsKt.lastIndexOf$default((CharSequence)string3, (String)endText, (int)0, (boolean)false, (int)6, null) - 1;
        Pair range = new Pair((Object)startIndex, (Object)endIndex);
        this.rangeList.add((Pair<Integer, Integer>)range);
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString size(int dp) {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new AbsoluteSizeSpan(dp, true), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString sizeSpecUnit(int size, int unit) {
        for (Pair<Integer, Integer> range : this.rangeList) {
            int sz = (int)TypedValue.applyDimension((int)unit, (float)size, (DisplayMetrics)this.context.getResources().getDisplayMetrics());
            this.setSpan(new AbsoluteSizeSpan(sz, false), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    public static /* synthetic */ NovaSdkSpannableString sizeSpecUnit$default(NovaSdkSpannableString novaSdkSpannableString, int n, int n2, int n3, Object object) {
        if ((n3 & 2) != 0) {
            n2 = 2;
        }
        return novaSdkSpannableString.sizeSpecUnit(n, n2);
    }

    @NotNull
    public final NovaSdkSpannableString sizeByRes(@DimenRes int resourceId) {
        for (Pair<Integer, Integer> range : this.rangeList) {
            int sz = this.context.getResources().getDimensionPixelSize(resourceId);
            this.setSpan(new AbsoluteSizeSpan(sz, false), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString scaleSize(int proportion) {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new RelativeSizeSpan((float)proportion), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString bold() {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new StyleSpan(1), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString italic() {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new StyleSpan(2), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString normal() {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new StyleSpan(0), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString bold_italic() {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new StyleSpan(3), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString font(@NotNull String font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new TypefaceSpan(font), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString strikethrough() {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new StrikethroughSpan(), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString underline() {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new UnderlineSpan(), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString bullet(int dp, @ColorInt @Nullable Integer colorRes) {
        for (Pair<Integer, Integer> range : this.rangeList) {
            Integer n = colorRes;
            this.setSpan(new BulletSpan(dp, n != null ? n : this.textColor), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString textColor(@ColorRes int colorRes) {
        this.textColor = ContextCompat.getColor((Context)this.context, (int)colorRes);
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new ForegroundColorSpan(this.textColor), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString subscript() {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new SubscriptSpan(), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString superscript() {
        for (Pair<Integer, Integer> range : this.rangeList) {
            this.setSpan(new SuperscriptSpan(), ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        return this;
    }

    @NotNull
    public final NovaSdkSpannableString onClick(@NotNull TextView textView, @NotNull Function0<Unit> onTextClickListener, boolean disableUnderLine) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter(onTextClickListener, (String)"onTextClickListener");
        for (Pair<Integer, Integer> range : this.rangeList) {
            ClickableSpan span2 = new ClickableSpan(onTextClickListener, disableUnderLine){
                final /* synthetic */ Function0<Unit> $onTextClickListener;
                final /* synthetic */ boolean $disableUnderLine;
                {
                    this.$onTextClickListener = $onTextClickListener;
                    this.$disableUnderLine = $disableUnderLine;
                }

                public void onClick(@NotNull View widget) {
                    Intrinsics.checkNotNullParameter((Object)widget, (String)"widget");
                    this.$onTextClickListener.invoke();
                }

                public void updateDrawState(@NotNull TextPaint ds) {
                    Intrinsics.checkNotNullParameter((Object)ds, (String)"ds");
                    ds.setUnderlineText(!this.$disableUnderLine);
                }
            };
            this.setSpan(span2, ((Number)range.getFirst()).intValue(), ((Number)range.getSecond()).intValue(), this.spanMode);
        }
        textView.setHighlightColor(0);
        textView.setMovementMethod(LinkMovementMethod.getInstance());
        return this;
    }

    public static /* synthetic */ NovaSdkSpannableString onClick$default(NovaSdkSpannableString novaSdkSpannableString, TextView textView, Function0 function0, boolean bl, int n, Object object) {
        if ((n & 4) != 0) {
            bl = true;
        }
        return novaSdkSpannableString.onClick(textView, (Function0<Unit>)function0, bl);
    }

    @NotNull
    public final NovaSdkSpannableString onClick(@NotNull TextView textView, @NotNull Function0<Unit> onTextClickListener) {
        Intrinsics.checkNotNullParameter((Object)textView, (String)"textView");
        Intrinsics.checkNotNullParameter(onTextClickListener, (String)"onTextClickListener");
        return this.onClick(textView, onTextClickListener, true);
    }

    @NotNull
    public final NovaSdkSpannableString setTextIcon(int resourceId) {
        block1: {
            Drawable drawable2;
            Drawable drawable3 = drawable2 = ContextCompat.getDrawable((Context)this.context, (int)resourceId);
            if (drawable3 != null) {
                drawable3.setBounds(8, 0, 25, 30);
            }
            Drawable drawable4 = drawable2;
            if (drawable4 == null) break block1;
            Drawable it = drawable4;
            boolean bl = false;
            ImageSpan image = new ImageSpan(drawable2, 1);
            this.setSpan(image, this.length() - 1, this.length(), this.spanMode);
        }
        return this;
    }
}

